<?php
/**
 * The file that defines the core plugin class
 *
 * A class definition that includes attributes and functions used across both the
 * public-facing side of the site and the admin area.
 *
 * @link       https://www.dukeyin.com/corona-virus-data/
 * @since      1.0.0
 *
 * @package    Corona_Virus_Data
 * @subpackage Corona_Virus_Data/includes
 */
/**
 * The core plugin class.
 *
 * This is used to define internationalization, admin-specific hooks, and
 * public-facing site hooks.
 *
 * Also maintains the unique identifier of this plugin as well as the current
 * version of the plugin.
 *
 * @since      1.0.0
 * @package    Corona_Virus_Data
 * @subpackage Corona_Virus_Data/includes
 * @author     Duke Yin <duke@dukeyin.com>
 */
class Corona_Virus_Data
{
    /**
     * The loader that's responsible for maintaining and registering all hooks that power
     * the plugin.
     *
     * @since    1.0.0
     * @access   protected
     * @var      Corona_Virus_Data_Loader    $loader    Maintains and registers all hooks for the plugin.
     */
    protected $loader;
    /**
     * The unique identifier of this plugin.
     *
     * @since    1.0.0
     * @access   protected
     * @var      string    $plugin_name    The string used to uniquely identify this plugin.
     */
    protected $plugin_name;
    /**
     * The current version of the plugin.
     *
     * @since    1.0.0
     * @access   protected
     * @var      string    $version    The current version of the plugin.
     */
    protected $version;
    /**
     * Define the core functionality of the plugin.
     *
     * Set the plugin name and the plugin version that can be used throughout the plugin.
     * Load the dependencies, define the locale, and set the hooks for the admin area and
     * the public-facing side of the site.
     *
     * @since    1.0.0
     */
    public function __construct()
    {
        if (defined('CORONA_VIRUS_DATA_VERSION')) {
            $this->version = CORONA_VIRUS_DATA_VERSION;
        } else {
            $this->version = '1.4.2';
        }
        $this->plugin_name = 'corona-virus-data';
        $this->load_dependencies();
        $this->set_locale();
        $this->define_admin_hooks();
        $this->define_public_hooks();
    }
    /**
     * Load the required dependencies for this plugin.
     *
     * Include the following files that make up the plugin:
     *
     * - Corona_Virus_Data_Loader. Orchestrates the hooks of the plugin.
     * - Corona_Virus_Data_i18n. Defines internationalization functionality.
     * - Corona_Virus_Data_Admin. Defines all hooks for the admin area.
     * - Corona_Virus_Data_Public. Defines all hooks for the public side of the site.
     *
     * Create an instance of the loader which will be used to register the hooks
     * with WordPress.
     *
     * @since    1.0.0
     * @access   private
     */
    private function load_dependencies()
    {
        /**
         * The class responsible for orchestrating the actions and filters of the
         * core plugin.
         */
        require_once plugin_dir_path(dirname(__FILE__)) . 'includes/class-corona-virus-data-loader.php';
        /**
         * The class responsible for defining internationalization functionality
         * of the plugin.
         */
        require_once plugin_dir_path(dirname(__FILE__)) . 'includes/class-corona-virus-data-i18n.php';
        /**
         * The class responsible for defining all actions that occur in the admin area.
         */
        require_once plugin_dir_path(dirname(__FILE__)) . 'admin/class-corona-virus-data-admin.php';
        /**
         * The class responsible for defining all actions that occur in the public-facing
         * side of the site.
         */
        require_once plugin_dir_path(dirname(__FILE__)) . 'public/class-corona-virus-data-public.php';
        $this->loader = new Corona_Virus_Data_Loader();
    }
    /**
     * Define the locale for this plugin for internationalization.
     *
     * Uses the Corona_Virus_Data_i18n class in order to set the domain and to register the hook
     * with WordPress.
     *
     * @since    1.0.0
     * @access   private
     */
    private function set_locale()
    {
        $plugin_i18n = new Corona_Virus_Data_i18n();
        $this->loader->add_action('plugins_loaded', $plugin_i18n, 'load_plugin_textdomain');
    }
    /**
     * Register all of the hooks related to the admin area functionality
     * of the plugin.
     *
     * @since    1.0.0
     * @access   private
     */
    private function define_admin_hooks()
    {
        $plugin_admin = new Corona_Virus_Data_Admin($this->get_plugin_name(), $this->get_version());
        $this->loader->add_action('admin_enqueue_scripts', $plugin_admin, 'enqueue_styles');
        $this->loader->add_action('admin_enqueue_scripts', $plugin_admin, 'enqueue_scripts');
    }
    /**
     * Register all of the hooks related to the public-facing functionality
     * of the plugin.
     *
     * @since    1.0.0
     * @access   private
     */
    private function define_public_hooks()
    {
        $plugin_public = new Corona_Virus_Data_Public($this->get_plugin_name(), $this->get_version());
        $this->loader->add_action('wp_enqueue_scripts', $plugin_public, 'enqueue_styles');
        $this->loader->add_action('wp_enqueue_scripts', $plugin_public, 'enqueue_scripts');
    }
    /**
     * Run the loader to execute all of the hooks with WordPress.
     *
     * @since    1.0.0
     */
    public function run()
    {
        $this->loader->run();
    }
    /**
     * The name of the plugin used to uniquely identify it within the context of
     * WordPress and to define internationalization functionality.
     *
     * @since     1.0.0
     * @return    string    The name of the plugin.
     */
    public function get_plugin_name()
    {
        return $this->plugin_name;
    }
    /**
     * The reference to the class that orchestrates the hooks with the plugin.
     *
     * @since     1.0.0
     * @return    Corona_Virus_Data_Loader    Orchestrates the hooks of the plugin.
     */
    public function get_loader()
    {
        return $this->loader;
    }
    /**
     * Retrieve the version number of the plugin.
     *
     * @since     1.0.0
     * @return    string    The version number of the plugin.
     */
    public function get_version()
    {
        return $this->version;
    }
}
function cov_wp_head()
{
    echo '<script>
var cov__contry = "' . get_option('cov__settings')['cov__select_field_0'] . '";
var cov__contry_text = "' . __(get_option('cov__settings')['cov__select_field_0'],'corona-virus-data'). '";
var cov__mbx_token = "' . get_option('cov__settings')['cov__text_field_2'] . '";
var cov__err_msg ="' . __('Failed to fetch data, maybe there is no data in your selected country, or the API is temporarily inaccessible.', 'corona-virus-data') . '";
var cov__plugin_dir = "' . plugin_dir_url(__DIR__) . '";
var cov__cases = "' . __('Cases', 'corona-virus-data') . '";
var cov__deaths = "' . __('Deaths', 'corona-virus-data') . '";
var cov__recoverd = "' . __('Recovered', 'corona-virus-data') . '";
var cov__cases_today = "' . __('Cases Today', 'corona-virus-data') . '";
var cov__deaths_today = "' . __('Deaths Today', 'corona-virus-data') . '";
var cov__critical = "' . __('Critical', 'corona-virus-data') . '";
var cov__active = "' . __('Active', 'corona-virus-data') . '";
var cov__casepmillion = "' . __('Cases Per Million', 'corona-virus-data') . '";
var cov__deathspmillion = "' . __('Deaths Per Million', 'corona-virus-data') . '";
var cov__history_global = "' . __('Global Daily Data', 'corona-virus-data') . '";
var cov__history_c = "' . __('Daily Data', 'corona-virus-data') . '";
var cov__popu = "' . __('Population', 'corona-virus-data') . '";
</script>';
}
add_action('wp_head', 'cov_wp_head');

//[cov2019] world and a country
function cov_func($atts, $content = null, $shortcodename = "")
{
	wp_enqueue_style( 'corona-virus-data' );
    $cov_country_n = __(get_option('cov__settings')['cov__select_field_0'],'corona-virus-data');
    $return = '<div class="ncov2019">
<div class="title text-center">' . __('Global Total', 'corona-virus-data') . '</div>
<div>' . __('Last update on: ', 'corona-virus-data') . '<span id="cov-time"></span></div>
<div class="one_half text-center"><h5>' . __('Cases', 'corona-virus-data') . '</h5><h3 id="cov-total-cases" class="has-text-color has-luminous-vivid-orange-color"><i class="cov-loading1"></i></h3></div>
<div class="one_half text-center"><h5>' . __('Deaths', 'corona-virus-data') . '</h5><h3 id="cov-total-dead"><i class="cov-loading1"></i></h3></div>
<div class="one_half text-center"><h5>' . __('Recovered', 'corona-virus-data') . '</h5><h3 id="cov-total-recoverd" class="has-text-color has-vivid-green-cyan-color"><i class="cov-loading1"></i></h3></div>
<div class="one_half text-center"><h5>' . __('Active', 'corona-virus-data') . '</h5><h3 id="cov-total-active" class="has-text-color has-luminous-vivid-orange-color"><i class="cov-loading1"></i></h3></div>
<div class="one_half text-center"><h5>' . __('Cases Today', 'corona-virus-data') . '</h5><h3 id="cov-total-today-case" class="has-text-color has-luminous-vivid-orange-color"><i class="cov-loading2"></i></h3></div>
<div class="one_half text-center"><h5>' . __('Deaths Today', 'corona-virus-data') . '</h5><h3 id="cov-total-today-deaths"><i class="cov-loading2"></i></h3></div>
<div class="one_half text-center"><h5>' . __('Critical', 'corona-virus-data') . '</h5><h3 id="cov-total-critical" class="has-text-color has-vivid-red-color"><i class="cov-loading2"></i></h3></div>
<div class="one_half text-center"><h5><small>' . __('Affected Countries', 'corona-virus-data') . '</small></h5><h3 id="cov-total-affected-countries" class="has-text-color has-vivid-cyan-blue-color"><i class="cov-loading2"></i></h3></div><div class="clear"></div>';
    $return .= '</div>';
	wp_enqueue_script('corona-virus-data');
    return $return;
}
add_shortcode("cov2019", "cov_func");

//[cov2019contry] country
function cov_cty_func($atts, $content = null, $shortcodename = "")
{
	wp_enqueue_style( 'corona-virus-data' );
    $cov_country_n = __(get_option('cov__settings')['cov__select_field_0'],'corona-virus-data');
    $return = '<div class="ncov2019"><div class="title text-center"><span id="cov_flag"></span>' . sprintf(__('Total in %s', 'corona-virus-data'), $cov_country_n) . '</div>
		<div>' . __('Last update on: ', 'corona-virus-data') . '<span id="cov-time-country"></span></div>
<div class="one_half text-center"><h5>' . __('Cases', 'corona-virus-data') . '</h5><h3 id="cov-new-confirm" class="has-text-color has-luminous-vivid-orange-color"><i class="cov-loading2"></i></h3></div>
<div class="one_half text-center"><h5>' . __('Deaths', 'corona-virus-data') . '</h5><h3 id="cov-new-dead"><i class="cov-loading2"></i></h3></div>
<div class="one_half text-center"><h5>' . __('Recovered', 'corona-virus-data') . '</h5><h3 id="cov-new-recoverd" class="has-text-color has-vivid-green-cyan-color"><i class="cov-loading2"></i></h3></div>
<div class="one_half text-center"><h5>' . __('Active', 'corona-virus-data') . '</h5><h3 id="cov-active" class="has-text-color has-luminous-vivid-orange-color"><i class="cov-loading2"></i></h3></div>
<div class="one_half text-center"><h5>' . __('Cases Today', 'corona-virus-data') . '</h5><h3 id="cov-today-case" class="has-text-color has-luminous-vivid-orange-color"><i class="cov-loading2"></i></h3></div>
<div class="one_half text-center"><h5>' . __('Deaths Today', 'corona-virus-data') . '</h5><h3 id="cov-today-deaths"><i class="cov-loading2"></i></h3></div>
<div class="one_half text-center"><h5>' . __('Critical', 'corona-virus-data') . '</h5><h3 id="cov-critical" class="has-text-color has-vivid-red-color"><i class="cov-loading2"></i></h3></div>
<div class="one_half text-center"><h5><small>' . __('Cases Per Million', 'corona-virus-data') . '</small></h5><h3 id="cov-case-million" class="has-text-color has-vivid-cyan-blue-color"><i class="cov-loading2"></i></h3></div><div class="clear"></div></div>';
	wp_enqueue_script('corona-virus-data');
    return $return;
}
add_shortcode("cov2019contry", "cov_cty_func");


//[cov2019all] data in table
function cov_all_func($atts, $content = null, $shortcodename = "")
{
    if (!is_admin()) {
        wp_enqueue_script('json2html');
		wp_enqueue_style( 'corona-virus-data' );
		wp_enqueue_script('corona-virus-data');
    }
    $return = '<div class="ncov2019"><p>' . __('Sort by confirmed numbers.', 'corona-virus-data') . '</p><div id="cov_table_container"><table id="cov_all_table"><tbody><tr><th>' . __('Country or Region', 'corona-virus-data') . '</th><th>' . __('Cases', 'corona-virus-data') . '</th><th>' . __('Deaths', 'corona-virus-data') . '</b></th><th>' . __('Recovered', 'corona-virus-data') . '</th></tr></tbody></table><i class="cov-loading3"></i></div></div>';
    return $return;
}
add_shortcode("cov2019all", "cov_all_func");

//[cov2019map] a mapbox map
function cov_map_func($atts, $content = null, $shortcodename = "")
{
		wp_enqueue_style( 'corona-virus-data' );
		wp_enqueue_script('corona-virus-data');
		
        wp_enqueue_style('leaflet');
        wp_enqueue_script('leaflet');
        wp_enqueue_script('cov_load_map');

    $return = '<div class="ncov2019"><i class="cov-loading4"></i><div id="cov__map" class="cov_map"></div></div>';
    return $return;
}
add_shortcode("cov2019map", "cov_map_func");

//[cov2019history] of the world
function cov_hist_all_func($atts, $content = null, $shortcodename = "")
{
		wp_enqueue_style( 'corona-virus-data' );
		wp_enqueue_script('corona-virus-data');
		wp_enqueue_script('chart.js');
		wp_enqueue_script('chartjs-utils');
	$return = '<div class="ncov2019"><div class="cov_chart_wrapper"><i class="cov-loading2"></i><canvas id="cov_hs_all" class="cov"></canvas></div>' ;
	$return .= "<script>var getJSON=function(url,type){type=type||'get';return new Promise(function(resolve,reject){var xhr=new XMLHttpRequest();xhr.open(type,url,true);xhr.responseType='json';xhr.onload=function(){var status=xhr.status;if(status==200){resolve(xhr.response)}else{reject(status)}};xhr.send()})};getJSON('https://disease.sh/v3/covid-19/historical/all?lastdays=all').then(function(data){var config={type:'line',data:{labels:Object.keys(data.cases),datasets:[{label:cov__cases,backgroundColor:window.chartColors.red,borderColor:window.chartColors.red,data:Object.values(data.cases),fill:false,},{label:cov__deaths,fill:false,backgroundColor:window.chartColors.gray,borderColor:window.chartColors.gray,data:Object.values(data.deaths),}]},options:{responsive:true,devicePixelRatio:4,elements:{line:{borderWidth:4},point:{radius:4,hoverRadius:8}},title:{display:true,text:cov__history_global,fontSize:30,},legend:{display:true,labels:{fontSize:12,padding:20,}},tooltips:{mode:'index',intersect:false,titleFontSize:20,},tooltipFontSize:20,hover:{mode:'nearest',intersect:true},scales:{x:{display:true,ticks:{fontSize:14}},y:{display:true,ticks:{fontSize:14}}},maintainAspectRatio:false}};var ctx=document.getElementById('cov_hs_all').getContext('2d');window.myLine=new Chart(ctx,config)},function(status){console.log(status)});</script></div>";
	return $return;
}
add_shortcode("cov2019history", "cov_hist_all_func");

//[cov2019historyc] of a country
function cov_hist_c_func($atts, $content = null, $shortcodename = "")
{
		wp_enqueue_style( 'corona-virus-data' );
		wp_enqueue_script('corona-virus-data');
		wp_enqueue_script('chart.js');
		wp_enqueue_script('chartjs-utils');
	$return = '<div class="ncov2019"><div class="cov_chart_wrapper"><i class="cov-loading2"></i><canvas id="cov_hs_c" class="cov"></canvas></div>' ;
	$return .= "<script>var getJSON=function(url,type){type=type||'get';return new Promise(function(resolve,reject){var xhr=new XMLHttpRequest();xhr.open(type,url,true);xhr.responseType='json';xhr.onload=function(){var status=xhr.status;if(status==200){resolve(xhr.response)}else{reject(status)}};xhr.send()})};getJSON('https://disease.sh/v3/covid-19/historical/'+cov__contry).then(function(data){var config={type:'line',data:{labels:Object.keys(data.timeline.cases),datasets:[{label:cov__cases,backgroundColor:window.chartColors.red,borderColor:window.chartColors.red,data:Object.values(data.timeline.cases),fill:false,},{label:cov__deaths,fill:false,backgroundColor:window.chartColors.gray,borderColor:window.chartColors.gray,data:Object.values(data.timeline.deaths),}]},options:{responsive:true,devicePixelRatio:4,elements:{line:{borderWidth:4},point:{radius:4,hoverRadius:8}},title:{display:true,text:cov__contry_text+' '+cov__history_c,fontSize:30,},legend:{display:true,labels:{fontSize:12,padding:20,}},tooltips:{mode:'index',intersect:false,titleFontSize:20,},tooltipFontSize:20,hover:{mode:'nearest',intersect:true},scales:{x:{display:true,ticks:{fontSize:14}},y:{display:true,ticks:{fontSize:14}}},maintainAspectRatio:false}};var ctx=document.getElementById('cov_hs_c').getContext('2d');window.myLine=new Chart(ctx,config)},function(status){console.log(status)});</script></div>";
	return $return;
}
add_shortcode("cov2019historyc", "cov_hist_c_func");

//[cov2019namerica] North America na
function cov_n_america($atts, $content = null, $shortcodename = ""){
	wp_enqueue_style( 'corona-virus-data' );
	wp_enqueue_script('corona-virus-data');
	$return = '<div class="ncov2019">
	<div class="title text-center">' . __('North America', 'corona-virus-data') . '</div>
	<div>' . __('Last update on: ', 'corona-virus-data') . '<span id="cov-time-na"></span></div>
	<div class="one_half text-center"><h5>' . __('Cases', 'corona-virus-data') . '</h5><h3 id="cov-na-cases" class="has-text-color has-luminous-vivid-orange-color"><i class="cov-loading1"></i></h3></div>
	<div class="one_half text-center"><h5>' . __('Deaths', 'corona-virus-data') . '</h5><h3 id="cov-na-dead"><i class="cov-loading1"></i></h3></div>
	<div class="one_half text-center"><h5>' . __('Recovered', 'corona-virus-data') . '</h5><h3 id="cov-na-recoverd" class="has-text-color has-vivid-green-cyan-color"><i class="cov-loading1"></i></h3></div>
	<div class="one_half text-center"><h5>' . __('Active', 'corona-virus-data') . '</h5><h3 id="cov-na-active" class="has-text-color has-luminous-vivid-orange-color"><i class="cov-loading1"></i></h3></div>
	<div class="one_half text-center"><h5>' . __('Cases Today', 'corona-virus-data') . '</h5><h3 id="cov-na-today-case" class="has-text-color has-luminous-vivid-orange-color"><i class="cov-loading2"></i></h3></div>
	<div class="one_half text-center"><h5>' . __('Deaths Today', 'corona-virus-data') . '</h5><h3 id="cov-na-today-deaths"><i class="cov-loading2"></i></h3></div>
	<div class="one_half text-center"><h5>' . __('Critical', 'corona-virus-data') . '</h5><h3 id="cov-na-critical" class="has-text-color has-vivid-red-color"><i class="cov-loading2"></i></h3></div>
	<div class="one_half text-center"><h5>' . __('Cases Per Million', 'corona-virus-data') . '</h5><h3 id="cov-na-case-million" class="has-text-color has-vivid-cyan-blue-color"><i class="cov-loading2"></i></h3></div>
	</div><div class="clear"></div>';
	return $return;
}
add_shortcode("cov2019namerica", "cov_n_america");

//[cov2019samerica]South America sa
function cov_s_america($atts, $content = null, $shortcodename = ""){
	wp_enqueue_style( 'corona-virus-data' );
	wp_enqueue_script('corona-virus-data');
	$return = '<div class="ncov2019">
	<div class="title text-center">' . __('South America', 'corona-virus-data') . '</div>
	<div>' . __('Last update on: ', 'corona-virus-data') . '<span id="cov-time-sa"></span></div>
	<div class="one_half text-center"><h5>' . __('Cases', 'corona-virus-data') . '</h5><h3 id="cov-sa-cases" class="has-text-color has-luminous-vivid-orange-color"><i class="cov-loading1"></i></h3></div>
	<div class="one_half text-center"><h5>' . __('Deaths', 'corona-virus-data') . '</h5><h3 id="cov-sa-dead"><i class="cov-loading1"></i></h3></div>
	<div class="one_half text-center"><h5>' . __('Recovered', 'corona-virus-data') . '</h5><h3 id="cov-sa-recoverd" class="has-text-color has-vivid-green-cyan-color"><i class="cov-loading1"></i></h3></div>
	<div class="one_half text-center"><h5>' . __('Active', 'corona-virus-data') . '</h5><h3 id="cov-sa-active" class="has-text-color has-luminous-vivid-orange-color"><i class="cov-loading1"></i></h3></div>
	<div class="one_half text-center"><h5>' . __('Cases Today', 'corona-virus-data') . '</h5><h3 id="cov-sa-today-case" class="has-text-color has-luminous-vivid-orange-color"><i class="cov-loading2"></i></h3></div>
	<div class="one_half text-center"><h5>' . __('Deaths Today', 'corona-virus-data') . '</h5><h3 id="cov-sa-today-deaths"><i class="cov-loading2"></i></h3></div>
	<div class="one_half text-center"><h5>' . __('Critical', 'corona-virus-data') . '</h5><h3 id="cov-sa-critical" class="has-text-color has-vivid-red-color"><i class="cov-loading2"></i></h3></div>
	<div class="one_half text-center"><h5>' . __('Cases Per Million', 'corona-virus-data') . '</h5><h3 id="cov-sa-case-million" class="has-text-color has-vivid-cyan-blue-color"><i class="cov-loading2"></i></h3></div>
	</div><div class="clear"></div>';
	return $return;
}
add_shortcode("cov2019samerica", "cov_s_america");

//[cov2019europe]Europe eu
function cov_europe($atts, $content = null, $shortcodename = ""){
	wp_enqueue_style( 'corona-virus-data' );
	wp_enqueue_script('corona-virus-data');
	$return = '<div class="ncov2019">
	<div class="title text-center">' . __('Europe', 'corona-virus-data') . '</div>
	<div>' . __('Last update on: ', 'corona-virus-data') . '<span id="cov-time-eu"></span></div>
	<div class="one_half text-center"><h5>' . __('Cases', 'corona-virus-data') . '</h5><h3 id="cov-eu-cases" class="has-text-color has-luminous-vivid-orange-color"><i class="cov-loading1"></i></h3></div>
	<div class="one_half text-center"><h5>' . __('Deaths', 'corona-virus-data') . '</h5><h3 id="cov-eu-dead"><i class="cov-loading1"></i></h3></div>
	<div class="one_half text-center"><h5>' . __('Recovered', 'corona-virus-data') . '</h5><h3 id="cov-eu-recoverd" class="has-text-color has-vivid-green-cyan-color"><i class="cov-loading1"></i></h3></div>
	<div class="one_half text-center"><h5>' . __('Active', 'corona-virus-data') . '</h5><h3 id="cov-eu-active" class="has-text-color has-luminous-vivid-orange-color"><i class="cov-loading1"></i></h3></div>
	<div class="one_half text-center"><h5>' . __('Cases Today', 'corona-virus-data') . '</h5><h3 id="cov-eu-today-case" class="has-text-color has-luminous-vivid-orange-color"><i class="cov-loading2"></i></h3></div>
	<div class="one_half text-center"><h5>' . __('Deaths Today', 'corona-virus-data') . '</h5><h3 id="cov-eu-today-deaths"><i class="cov-loading2"></i></h3></div>
	<div class="one_half text-center"><h5>' . __('Critical', 'corona-virus-data') . '</h5><h3 id="cov-eu-critical" class="has-text-color has-vivid-red-color"><i class="cov-loading2"></i></h3></div>
	<div class="one_half text-center"><h5>' . __('Cases Per Million', 'corona-virus-data') . '</h5><h3 id="cov-eu-case-million" class="has-text-color has-vivid-cyan-blue-color"><i class="cov-loading2"></i></h3></div>
	</div><div class="clear"></div>';
	return $return;
}
add_shortcode("cov2019europe", "cov_europe");

//[cov2019asia]Asia as
function cov_asia($atts, $content = null, $shortcodename = ""){
	wp_enqueue_style( 'corona-virus-data' );
	wp_enqueue_script('corona-virus-data');
	$return = '<div class="ncov2019">
	<div class="title text-center">' . __('Asia', 'corona-virus-data') . '</div>
	<div>' . __('Last update on: ', 'corona-virus-data') . '<span id="cov-time-as"></span></div>
	<div class="one_half text-center"><h5>' . __('Cases', 'corona-virus-data') . '</h5><h3 id="cov-as-cases" class="has-text-color has-luminous-vivid-orange-color"><i class="cov-loading1"></i></h3></div>
	<div class="one_half text-center"><h5>' . __('Deaths', 'corona-virus-data') . '</h5><h3 id="cov-as-dead"><i class="cov-loading1"></i></h3></div>
	<div class="one_half text-center"><h5>' . __('Recovered', 'corona-virus-data') . '</h5><h3 id="cov-as-recoverd" class="has-text-color has-vivid-green-cyan-color"><i class="cov-loading1"></i></h3></div>
	<div class="one_half text-center"><h5>' . __('Active', 'corona-virus-data') . '</h5><h3 id="cov-as-active" class="has-text-color has-luminous-vivid-orange-color"><i class="cov-loading1"></i></h3></div>
	<div class="one_half text-center"><h5>' . __('Cases Today', 'corona-virus-data') . '</h5><h3 id="cov-as-today-case" class="has-text-color has-luminous-vivid-orange-color"><i class="cov-loading2"></i></h3></div>
	<div class="one_half text-center"><h5>' . __('Deaths Today', 'corona-virus-data') . '</h5><h3 id="cov-as-today-deaths"><i class="cov-loading2"></i></h3></div>
	<div class="one_half text-center"><h5>' . __('Critical', 'corona-virus-data') . '</h5><h3 id="cov-as-critical" class="has-text-color has-vivid-red-color"><i class="cov-loading2"></i></h3></div>
	<div class="one_half text-center"><h5>' . __('Cases Per Million', 'corona-virus-data') . '</h5><h3 id="cov-as-case-million" class="has-text-color has-vivid-cyan-blue-color"><i class="cov-loading2"></i></h3></div>
	</div><div class="clear"></div>';
	return $return;
}
add_shortcode("cov2019asia", "cov_asia");

//[cov2019oceania]Oceania oa
function cov_oceania($atts, $content = null, $shortcodename = ""){
	wp_enqueue_style( 'corona-virus-data' );
	wp_enqueue_script('corona-virus-data');
	$return = '<div class="ncov2019">
	<div class="title text-center">' . __('Oceania', 'corona-virus-data') . '</div>
	<div>' . __('Last update on: ', 'corona-virus-data') . '<span id="cov-time-oa"></span></div>
	<div class="one_half text-center"><h5>' . __('Cases', 'corona-virus-data') . '</h5><h3 id="cov-oa-cases" class="has-text-color has-luminous-vivid-orange-color"><i class="cov-loading1"></i></h3></div>
	<div class="one_half text-center"><h5>' . __('Deaths', 'corona-virus-data') . '</h5><h3 id="cov-oa-dead"><i class="cov-loading1"></i></h3></div>
	<div class="one_half text-center"><h5>' . __('Recovered', 'corona-virus-data') . '</h5><h3 id="cov-oa-recoverd" class="has-text-color has-vivid-green-cyan-color"><i class="cov-loading1"></i></h3></div>
	<div class="one_half text-center"><h5>' . __('Active', 'corona-virus-data') . '</h5><h3 id="cov-oa-active" class="has-text-color has-luminous-vivid-orange-color"><i class="cov-loading1"></i></h3></div>
	<div class="one_half text-center"><h5>' . __('Cases Today', 'corona-virus-data') . '</h5><h3 id="cov-oa-today-case" class="has-text-color has-luminous-vivid-orange-color"><i class="cov-loading2"></i></h3></div>
	<div class="one_half text-center"><h5>' . __('Deaths Today', 'corona-virus-data') . '</h5><h3 id="cov-oa-today-deaths"><i class="cov-loading2"></i></h3></div>
	<div class="one_half text-center"><h5>' . __('Critical', 'corona-virus-data') . '</h5><h3 id="cov-oa-critical" class="has-text-color has-vivid-red-color"><i class="cov-loading2"></i></h3></div>
	<div class="one_half text-center"><h5>' . __('Cases Per Million', 'corona-virus-data') . '</h5><h3 id="cov-oa-case-million" class="has-text-color has-vivid-cyan-blue-color"><i class="cov-loading2"></i></h3></div>
	</div><div class="clear"></div>';
	return $return;
}
add_shortcode("cov2019oceania", "cov_oceania");

//[cov2019africa]Africa af
function cov_africa($atts, $content = null, $shortcodename = ""){
	wp_enqueue_style( 'corona-virus-data' );
	wp_enqueue_script('corona-virus-data');
	$return = '<div class="ncov2019">
	<div class="title text-center">' . __('Africa', 'corona-virus-data') . '</div>
	<div>' . __('Last update on: ', 'corona-virus-data') . '<span id="cov-time-af"></span></div>
	<div class="one_half text-center"><h5>' . __('Cases', 'corona-virus-data') . '</h5><h3 id="cov-af-cases" class="has-text-color has-luminous-vivid-orange-color"><i class="cov-loading1"></i></h3></div>
	<div class="one_half text-center"><h5>' . __('Deaths', 'corona-virus-data') . '</h5><h3 id="cov-af-dead"><i class="cov-loading1"></i></h3></div>
	<div class="one_half text-center"><h5>' . __('Recovered', 'corona-virus-data') . '</h5><h3 id="cov-af-recoverd" class="has-text-color has-vivid-green-cyan-color"><i class="cov-loading1"></i></h3></div>
	<div class="one_half text-center"><h5>' . __('Active', 'corona-virus-data') . '</h5><h3 id="cov-af-active" class="has-text-color has-luminous-vivid-orange-color"><i class="cov-loading1"></i></h3></div>
	<div class="one_half text-center"><h5>' . __('Cases Today', 'corona-virus-data') . '</h5><h3 id="cov-af-today-case" class="has-text-color has-luminous-vivid-orange-color"><i class="cov-loading2"></i></h3></div>
	<div class="one_half text-center"><h5>' . __('Deaths Today', 'corona-virus-data') . '</h5><h3 id="cov-af-today-deaths"><i class="cov-loading2"></i></h3></div>
	<div class="one_half text-center"><h5>' . __('Critical', 'corona-virus-data') . '</h5><h3 id="cov-af-critical" class="has-text-color has-vivid-red-color"><i class="cov-loading2"></i></h3></div>
	<div class="one_half text-center"><h5>' . __('Cases Per Million', 'corona-virus-data') . '</h5><h3 id="cov-af-case-million" class="has-text-color has-vivid-cyan-blue-color"><i class="cov-loading2"></i></h3></div>
	</div><div class="clear"></div>';
	return $return;
}
add_shortcode("cov2019africa", "cov_africa");