<?php
/* 
 * Plugin Name: Covid19 Toolkit
 * Author: EnvyTheme
 * Author URI: envytheme.com
 * Description: A Light weight and easy toolkit for Elementor page builder widgets.
 * Version: 2.0.0
 */

if (!defined('ABSPATH')) {
    exit; //Exit if accessed directly
}

define('COVID19_ACC_PATH', plugin_dir_path(__FILE__));
if( !defined('COVID19_FRAMEWORK_VAR') ) define('COVID19_FRAMEWORK_VAR', 'covid19_opt');

// Custom Post
function covid19_toolkit_custom_post(){

	// Doctor permalink 
	global $covid19_opt;
	if( isset( $covid19_opt['doctor_permalink'] ) ):
		$doctor_permalink = $covid19_opt['doctor_permalink'];
	else:
		$doctor_permalink = 'doctor-post';
	endif;

    // Doctors Custom Post
    register_post_type('doctor',
        array(
            'labels' => array(
                'name' => esc_html__('Doctors', 'covid19-toolkit'),
                'singular_name' => esc_html__('Doctor', 'covid19-toolkit'),
            ),
            'menu_icon'   => 'dashicons-businessperson',
            'supports' => array('title', 'thumbnail', 'editor'),
			'public' => true,  
			'rewrite' => array( 'slug' => $doctor_permalink ),
			
        )
    );
}
add_action('init', 'covid19_toolkit_custom_post');


// Main Elementor covid19 Extension Class
final class Elementor_Covid19_Extension {

	const VERSION = '1.0.0';
	const MINIMUM_ELEMENTOR_VERSION = '2.0.0';
	const MINIMUM_PHP_VERSION = '7.0';

	// Instance
    private static $_instance = null;
    
	public static function instance() {

		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;

	}

	// Constructor
	public function __construct() {
		add_action( 'plugins_loaded', [ $this, 'init' ] );

	}

	// init
	public function init() {
        load_plugin_textdomain( 'covid19-toolkit' );

		// Check if Elementor installed and activated
		if ( ! did_action( 'elementor/loaded' ) ) {
			add_action( 'admin_notices', [ $this, 'admin_notice_missing_main_plugin' ] );
			return;
		}

		// Check for required Elementor version
		if ( ! version_compare( ELEMENTOR_VERSION, self::MINIMUM_ELEMENTOR_VERSION, '>=' ) ) {
			add_action( 'admin_notices', [ $this, 'admin_notice_minimum_elementor_version' ] );
			return;
		}

		// Check for required PHP version
		if ( version_compare( PHP_VERSION, self::MINIMUM_PHP_VERSION, '<' ) ) {
			add_action( 'admin_notices', [ $this, 'admin_notice_minimum_php_version' ] );
			return;
		}

		// Add Plugin actions
		add_action( 'elementor/widgets/widgets_registered', [ $this, 'init_widgets' ] );
        
        add_action('elementor/elements/categories_registered',[ $this, 'register_new_category'] );
        
    }

    public function register_new_category($manager){
        $manager->add_category('covid19-elements',[
            'title'=>esc_html__('covid19','covid19-toolkit'),
            'icon'=> 'fa fa-image'
        ]);
    }

	//Admin notice
	public function admin_notice_missing_main_plugin() {

		if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );

		$message = sprintf(
			/* translators: 1: Plugin name 2: Elementor */
			esc_html__( '"%1$s" requires "%2$s" to be installed and activated.', 'covid19-toolkit' ),
			'<strong>' . esc_html__( 'Covid19 Toolkit', 'covid19-toolkit' ) . '</strong>',
			'<strong>' . esc_html__( 'Elementor', 'covid19-toolkit' ) . '</strong>'
		);

		printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

	}
	public function admin_notice_minimum_elementor_version() {

		if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );

		$message = sprintf(
			/* translators: 1: Plugin name 2: Elementor 3: Required Elementor version */
			esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'covid19-toolkit' ),
			'<strong>' . esc_html__( 'Covid19 Toolkit', 'covid19-toolkit' ) . '</strong>',
			'<strong>' . esc_html__( 'Elementor', 'covid19-toolkit' ) . '</strong>',
			 self::MINIMUM_ELEMENTOR_VERSION
		);

		printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

	}
	public function admin_notice_minimum_php_version() {

		if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );

		$message = sprintf(
			/* translators: 1: Plugin name 2: PHP 3: Required PHP version */
			esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'covid19-toolkit' ),
			'<strong>' . esc_html__( 'Covid19 Toolkit', 'covid19-toolkit' ) . '</strong>',
			'<strong>' . esc_html__( 'PHP', 'covid19-toolkit' ) . '</strong>',
			 self::MINIMUM_PHP_VERSION
		);

		printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

	}

	// Toolkit Widgets
	public function init_widgets() {

		// Include Widget files
		require_once( __DIR__ . '/widgets/banner-slider.php' );
		require_once( __DIR__ . '/widgets/banner-one.php' );
		require_once( __DIR__ . '/widgets/banner-three.php' );
		require_once( __DIR__ . '/widgets/banner-four.php' );
		require_once( __DIR__ . '/widgets/one-page-banner.php' );
		require_once( __DIR__ . '/widgets/about-us.php' );
		require_once( __DIR__ . '/widgets/section.php' );
		require_once( __DIR__ . '/widgets/blog-posts.php' );
		require_once( __DIR__ . '/widgets/symptom.php' );
		require_once( __DIR__ . '/widgets/symptom2.php' );
		require_once( __DIR__ . '/widgets/symptom3.php' );
		require_once( __DIR__ . '/widgets/outbreak-area.php' );
		require_once( __DIR__ . '/widgets/prevention.php' );
		require_once( __DIR__ . '/widgets/prevention-two.php' );
		require_once( __DIR__ . '/widgets/faq.php' );
		require_once( __DIR__ . '/widgets/faq2.php' );
		require_once( __DIR__ . '/widgets/faq3.php' );
		require_once( __DIR__ . '/widgets/faq-video.php' );
		require_once( __DIR__ . '/widgets/doctor.php' );
		require_once( __DIR__ . '/widgets/cta.php' );
		require_once( __DIR__ . '/widgets/cta2.php' );
		require_once( __DIR__ . '/widgets/contact-area.php' );
		require_once( __DIR__ . '/widgets/spreads-virus.php' );
		require_once( __DIR__ . '/widgets/spreads-virus2.php' );
		require_once( __DIR__ . '/widgets/coming-soon.php' );
		require_once( __DIR__ . '/widgets/contact-card.php' );
		require_once( __DIR__ . '/widgets/single-doctor-card.php' );
		require_once( __DIR__ . '/widgets/live-tracker.php' );
		
	}

}
Elementor_covid19_Extension::instance();

// Redux Theme Options
require_once(COVID19_ACC_PATH . 'redux/ReduxCore/framework.php');
require_once(COVID19_ACC_PATH . 'redux/sample/sample-config.php');
require_once(COVID19_ACC_PATH . 'inc/widgets.php');

// Registering crazy toolkit files
function covid19_toolkit_files()
{
    wp_enqueue_style('font-awesome-4.7', plugin_dir_url(__FILE__) . 'assets/css/font-awesome.min.css');
}

add_action('wp_enqueue_scripts', 'covid19_toolkit_files');

add_filter('the_content', 'covid19_remove_empty_p', 20, 1);
function covid19_remove_empty_p($content){
    $content = force_balance_tags($content);
    return preg_replace('#<p>\s*+(<br\s*/*>)?\s*</p>#i', '', $content);
}

add_filter('script_loader_tag', 'covid19_clean_script_tag');
function covid19_clean_script_tag($input) {
        $input = str_replace( array( 'type="text/javascript"', "type='text/javascript'" ), '', $input );
        return $input;
}

// Post Category Select
function covid19_toolkit_get_post_cat_list() {
	$post_category_id = get_queried_object_id();
	$args = array(
		'parent' => $post_category_id
	);

	$terms = get_terms( 'category', get_the_ID());
	$cat_options = array(esc_html__('', 'covid19-toolkit') => '');

	if ($terms) {
		foreach ($terms as $term) {
			$cat_options[$term->name] = $term->name;
		}
	}
	return $cat_options;
}


// Select page for link
function covid19_toolkit_get_page_as_list() {
    $args = wp_parse_args(array(
        'post_type' => 'page',
        'numberposts' => -1,
    ));

    $posts = get_posts($args);
    $post_options = array(esc_html__('', 'covid19-toolkit') => '');

    if ($posts) {
        foreach ($posts as $post) {
            $post_options[$post->post_title] = $post->ID;
        }
    }
    $flipped = array_flip($post_options);
    return $flipped;
}

$opt_name = COVID19_FRAMEWORK_VAR;