<?php

class Covid19_posts_thumbs extends WP_Widget{

    function __construct(){
        $widget_ops = array('description' => esc_html__('Display Random or Recent posts with a small image.', 'covid19-toolkit'));
        parent::__construct( false, esc_html__('Covid19 Recent Posts With Image', 'covid19-toolkit'), $widget_ops);
    }

    function widget($args, $instance){
        global $covid19_theme;
        extract($args); //it receives an associative array

        $title = apply_filters('widget_title', $instance['title']);
        $args = array(
            'posts_per_page' => $instance['number'],
            'post_type' => 'post',
            'order' => 'DESC',
            'orderby' => $instance['orderby']
        );
        $query = new WP_Query($args);

        if( !$query->have_posts() ) return;
        echo $before_widget;
        if($title) echo $before_title.$title.$after_title;
        if(!$instance['number']) $instance['number'] = 4;

        if($query->have_posts()):
            $c = 0;
            
            while($query->have_posts()): $query->the_post(); ?>
                <?php
                $class = 'item';
                $post_id = get_the_ID();
                $thumb_size = 'covid19_widget_thumb';
                ?>
                <?php if( !has_post_thumbnail() ) $class .= ' no-thumb'; ?>
                <article <?php post_class($class); ?>>

                    <?php if( has_post_thumbnail() ): ?>
                        <?php
                        $thumb_id   = get_post_thumbnail_id($post_id);
                        $thumb_type = get_post_mime_type($thumb_id);
                        $image_alt  = get_post_meta( $thumb_id, '_wp_attachment_image_alt', true);
                        if( !$image_alt ){
                            $image_alt = get_the_title($post_id);
                        }
                        if($thumb_type == 'image/gif'){
                            $thumb_size = '';
                        }
                        ?>
                        <a href="<?php the_permalink(); ?>" class="thumb hover-effect" aria-label="<?php echo substr(get_the_title(), 0, 50); ?>...">
                        <span class="fullimage cover" role="img" aria-label="<?php echo esc_attr($image_alt); ?>" style="background: url('<?php the_post_thumbnail_url($thumb_size); ?>');"></span>
                        </a>
                    <?php endif; ?>

                    <div class="info gradient-effect">
                        <time datetime="<?php the_time('Y-m-d'); ?>"><?php the_time( get_option('date_format') ); ?></time>
                        <h4 class="title usmall"><a href="<?php the_permalink(); ?>"><?php echo substr(get_the_title(), 0, 50); ?>...</a></h4>								
                    </div>

                    <div class="clear"></div>
                </article>
            <?php
            endwhile;
            wp_reset_postdata();
        endif;
        echo $after_widget;
    }

    function update($new_instance, $old_instance){
        $instance = $old_instance;
        $instance['title'] = strip_tags($new_instance['title']);
        $instance['number'] = (int) $new_instance['number'];
        $instance['orderby'] = $new_instance['orderby'];
        return $instance;
    }

    function form($instance){
        $defaults = array(
            'title' => 'Recent posts',
            'number' => 4,
            'orderby' => 'date'
        );
        $instance = wp_parse_args((array)$instance, $defaults);
        $number = isset( $instance['number'] ) ? absint( $instance['number'] ) : 4;
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>">
                <?php esc_html_e('Title:', 'covid19-toolkit'); ?>
                <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $instance['title']; ?>" />
            </label>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('number'); ?>"><?php esc_html_e( 'Number of posts to show:', 'covid19-toolkit'); ?></label>
            <input id="<?php echo $this->get_field_id('number'); ?>" name="<?php echo $this->get_field_name('number'); ?>" type="text" value="<?php echo $number; ?>" size="3" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('orderby'); ?>"><?php esc_html_e('Mode:', 'covid19-toolkit') ?> </label>
            <select id="<?php echo $this->get_field_id('orderby'); ?>" name="<?php echo $this->get_field_name('orderby'); ?>">
                <option <?php if ($instance['orderby'] == 'date') echo 'selected="selected"'; ?> value="date"><?php esc_html_e('Recent Posts', 'covid19-toolkit'); ?></option>
                <option <?php if ($instance['orderby'] == 'rand') echo 'selected="selected"'; ?> value="rand"><?php esc_html_e('Random Posts', 'covid19-toolkit'); ?></option>
                <?php if( function_exists('get_field') ): // By views ?>
                    <option <?php if ($instance['orderby'] == 'views') echo 'selected="selected"'; ?> value="views"><?php esc_html_e('Post views', 'covid19-toolkit'); ?></option>
                <?php endif; ?>
            </select>
        </p>
        <?php
    }

}

function covid19_register_posts_thumbs() {
    register_widget('covid19_posts_thumbs');
}

add_action('widgets_init', 'covid19_register_posts_thumbs');


/**
 * Contact Info Widget
 */
class Covid19_Contact_Info extends WP_Widget{

    function __construct(){
        $widget_ops = array('description' => esc_html__('Display Contact Info', 'covid19-toolkit'));
        parent::__construct( false, esc_html__('Covid19 Contact Info', 'covid19-toolkit'), $widget_ops);
    }

    function widget($args, $instance){
        extract($args);
        global $covid19_theme;

        $title  = apply_filters('widget_title', $instance['title']);

        echo $before_widget;
        if($title) echo $before_title.$title.$after_title;
        ?>
        <ul class="footer-contact-info">
            <?php if( $instance['location'] != '' ): ?>
                <li>
                    <span><?php echo esc_html( $instance['location_title'] ); ?></span>
                    <?php echo $instance['location']; ?>
                </li>
            <?php endif; ?>

            <?php if( $instance['phone'] != '' ): ?>
                <li>
                    <span><?php echo esc_html( $instance['phone_title'] ); ?></span>
                    <a href="<?php echo esc_url( $instance['phone_link'] ); ?>"><?php echo $instance['phone']; ?></a>
                </li>
            <?php endif; ?>

            <?php if( $instance['email'] != '' ): ?>
                <li>
                    <span><?php echo esc_html( $instance['email_title'] ); ?></span>
                    <a href="<?php echo esc_url( $instance['email_link'] ); ?>"><?php echo $instance['email']; ?></a>
                </li>
            <?php endif; ?>

            <?php if( $instance['fax'] != '' ): ?>
                <li>
                    <span><?php echo esc_html( $instance['fax_title'] ); ?></span>
                    <a href="<?php echo esc_url( $instance['fax_link'] ); ?>"><?php echo $instance['fax']; ?></a>
                </li>
            <?php endif; ?>
        </ul>
        <?php
        echo $after_widget;
    }

    function update($new_instance, $old_instance){
        $instance                    = $old_instance;
        $instance['title']           = strip_tags($new_instance['title']);
        $instance['location_title']  = $new_instance['location_title'];
        $instance['location']        = $new_instance['location'];
        $instance['phone_title']     = $new_instance['phone_title'];
        $instance['phone']           = $new_instance['phone'];
        $instance['phone_link']      = $new_instance['phone_link'];
        $instance['email_title']     = $new_instance['email_title'];
        $instance['email']           = $new_instance['email'];
        $instance['email_link']      = $new_instance['email_link'];
        $instance['phone_link']      = $new_instance['phone_link'];
        $instance['fax_title']       = $new_instance['fax_title'];
        $instance['fax_link']        = $new_instance['fax_link'];
        $instance['fax']             = $new_instance['fax'];
        return $instance;
    }

    function form($instance){
        $defaults = array(
            'title'             => 'Contact Us',
            'location_title'    => 'Address:',
            'location'          => '2750 Quadra Street Victoria, Canada.',
            'phone_title'       => 'Phone:',
            'phone'             => '+44587154756',
            'phone_link'        => 'tel:+44587154756',
            'email_title'       => 'Email:',
            'email'             => 'hello@covid19.com',
            'email_link'        => 'mailto:hello@covid19.com',
            'fax_title'         => 'Fax:',
            'fax_link'          => 'tel:+557854578964',
            'fax'               => '+55 785 4578964',
            


        );
        $instance = wp_parse_args((array)$instance, $defaults);
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>">
                <?php esc_html_e('Title:', 'covid19-toolkit'); ?>
                <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $instance['title']; ?>" />
            </label>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('location_title'); ?>">
                <?php esc_html_e('Location Title:', 'covid19-toolkit'); ?>
                <input class="widefat" id="<?php echo $this->get_field_id('location_title'); ?>" name="<?php echo $this->get_field_name('location_title'); ?>" type="text" value="<?php echo $instance['location_title']; ?>" />
            </label>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('location'); ?>">
                <?php esc_html_e('Location:', 'covid19-toolkit'); ?>
                <input class="widefat" id="<?php echo $this->get_field_id('location'); ?>" name="<?php echo $this->get_field_name('location'); ?>" type="text" value="<?php echo $instance['location']; ?>" />
            </label>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('phone_title'); ?>">
                <?php esc_html_e('Phone Title:', 'covid19-toolkit'); ?>
                <input class="widefat" id="<?php echo $this->get_field_id('phone_title'); ?>" name="<?php echo $this->get_field_name('phone_title'); ?>" type="text" value="<?php echo $instance['phone_title']; ?>" />
            </label>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('phone'); ?>">
                <?php esc_html_e('Phone Number:', 'covid19-toolkit'); ?>
                <input class="widefat" id="<?php echo $this->get_field_id('phone'); ?>" name="<?php echo $this->get_field_name('phone'); ?>" type="text" value="<?php echo $instance['phone']; ?>" />
            </label>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('phone_link'); ?>">
                <?php esc_html_e('Number Link:', 'covid19-toolkit'); ?>
                <input class="widefat" id="<?php echo $this->get_field_id('phone_link'); ?>" name="<?php echo $this->get_field_name('phone_link'); ?>" type="text" value="<?php echo $instance['phone_link']; ?>" />
            </label>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('email_title'); ?>">
                <?php esc_html_e('Email Title:', 'covid19-toolkit'); ?>
                <input class="widefat" id="<?php echo $this->get_field_id('email_title'); ?>" name="<?php echo $this->get_field_name('email_title'); ?>" type="text" value="<?php echo $instance['email_title']; ?>" />
            </label>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('email'); ?>">
                <?php esc_html_e('Email:', 'covid19-toolkit'); ?>
                <input class="widefat" id="<?php echo $this->get_field_id('email'); ?>" name="<?php echo $this->get_field_name('email'); ?>" type="text" value="<?php echo $instance['email']; ?>" />
            </label>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('email_link'); ?>">
                <?php esc_html_e('Email Link:', 'covid19-toolkit'); ?>
                <input class="widefat" id="<?php echo $this->get_field_id('email_link'); ?>" name="<?php echo $this->get_field_name('email_link'); ?>" type="text" value="<?php echo $instance['email_link']; ?>" />
            </label>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('fax_title'); ?>">
                <?php esc_html_e('Fax Title:', 'covid19-toolkit'); ?>
                <input class="widefat" id="<?php echo $this->get_field_id('fax_title'); ?>" name="<?php echo $this->get_field_name('fax_title'); ?>" type="text" value="<?php echo $instance['fax_title']; ?>" />
            </label>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('fax'); ?>">
                <?php esc_html_e('Fax:', 'covid19-toolkit'); ?>
                <input class="widefat" id="<?php echo $this->get_field_id('fax'); ?>" name="<?php echo $this->get_field_name('fax'); ?>" type="text" value="<?php echo $instance['fax']; ?>" />
            </label>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('fax_link'); ?>">
                <?php esc_html_e('Fax Link:', 'covid19-toolkit'); ?>
                <input class="widefat" id="<?php echo $this->get_field_id('fax_link'); ?>" name="<?php echo $this->get_field_name('fax_link'); ?>" type="text" value="<?php echo $instance['fax_link']; ?>" />
            </label>
        </p>
        <?php
    }

}

function covid19_register_contact_info() {
    register_widget('Covid19_Contact_Info');
}

add_action('widgets_init', 'covid19_register_contact_info');