<?php
    /**
     * ReduxFramework Sample Config File
     * For full documentation, please visit: http://docs.reduxframework.com/
     */

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }

    // This is your option name where all the Redux data is stored.
    $opt_name = COVID19_FRAMEWORK_VAR;
    
    // This line is only for altering the demo. Can be easily removed.
    $opt_name = apply_filters( 'opt_name/opt_name', $opt_name );

    // Used within different fields. Simply examples. Search for ACTUAL DECLARATION for field examples
    $sampleHTML = '';
    if ( file_exists( dirname( __FILE__ ) . '/info-html.html' ) ) {
        Redux_Functions::initWpFilesystem();

        global $wp_filesystem;

        $sampleHTML = $wp_filesystem->get_contents( dirname( __FILE__ ) . '/info-html.html' );
    }

    // Background Patterns Reader
    $sample_patterns_path = ReduxFramework::$_dir . '../sample/patterns/';
    $sample_patterns_url  = ReduxFramework::$_url . '../sample/patterns/';
    $sample_patterns      = array();
    
    if ( is_dir( $sample_patterns_path ) ) {
        if ( $sample_patterns_dir = opendir( $sample_patterns_path ) ) {
            $sample_patterns = array();
            while ( ( $sample_patterns_file = readdir( $sample_patterns_dir ) ) !== false ) {
                if ( stristr( $sample_patterns_file, '.png' ) !== false || stristr( $sample_patterns_file, '.jpg' ) !== false ) {
                    $name              = explode( '.', $sample_patterns_file );
                    $name              = str_replace( '.' . end( $name ), '', $sample_patterns_file );
                    $sample_patterns[] = array(
                        'alt' => $name,
                        'img' => $sample_patterns_url . $sample_patterns_file
                    );
                }
            }
        }
    }

    // All the possible arguments for Redux.
    $theme = wp_get_theme(); // For use with some settings. Not necessary.
    $args = array(
        // TYPICAL -> Change these values as you need/desire
        'opt_name'             => $opt_name,
        // This is where your data is stored in the database and also becomes your global variable name.
        'display_name'         => $theme->get( 'Name' ),
        // Name that appears at the top of your panel
        'display_version'      => $theme->get( 'Version' ),
        // Version that appears at the top of your panel
        'menu_type'            => 'menu',
        //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
        'allow_sub_menu'       => true,
        // Show the sections below the admin menu item or not
        'menu_title'           => __( 'Theme Options', 'covid19-toolkit' ),
        'page_title'           => __( 'Theme Options', 'covid19-toolkit' ),
        // You will need to generate a Google API key to use this feature.
        // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
        'google_api_key'       => '',
        // Set it you want google fonts to update weekly. A google_api_key value is required.
        'google_update_weekly' => false,
        // Must be defined to add google fonts to the typography module
        'async_typography'     => false,
        // Use a asynchronous font on the front end or font string
        //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
        'admin_bar'            => true,
        // Show the panel pages on the admin bar
        'admin_bar_icon'       => 'dashicons-portfolio',
        // Choose an icon for the admin bar menu
        'admin_bar_priority'   => 50,
        // Choose an priority for the admin bar menu
        'global_variable'      => '',
        // Set a different name for your global variable other than the opt_name
        'dev_mode'             => false,
        // Show the time the page took to load, etc
        'update_notice'        => false,
        // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
        'customizer'           => true,
        // Enable basic customizer support
        //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
        //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field

        // OPTIONAL -> Give you extra features
        'page_priority'        => null,
        // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
        'page_parent'          => 'themes.php',
        // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
        'page_permissions'     => 'manage_options',
        // Permissions needed to access the options panel.
        'menu_icon'            => '',
        // Specify a custom URL to an icon
        'last_tab'             => '',
        // Force your panel to always open to a specific tab (by id)
        'page_icon'            => 'icon-themes',
        // Icon displayed in the admin panel next to your menu_title
        'page_slug'            => 'opt_nameion',
        // Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided
        'save_defaults'        => true,
        // On load save the defaults to DB before user clicks save or not
        'default_show'         => false,
        // If true, shows the default value next to each field that is not the default value.
        'default_mark'         => '',
        // What to print by the field's title if the value shown is default. Suggested: *
        'show_import_export'   => true,
        // Shows the Import/Export panel when not used as a field.

        // CAREFUL -> These options are for advanced use only
        'transient_time'       => 60 * MINUTE_IN_SECONDS,
        'output'               => true,
        // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
        'output_tag'           => true,
        // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
        // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

        // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
        'database'             => '',
        // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
        'use_cdn'              => true,
        // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

        // HINTS
        'hints'                => array(
            'icon'          => 'el el-question-sign',
            'icon_position' => 'right',
            'icon_color'    => 'lightgray',
            'icon_size'     => 'normal',
            'tip_style'     => array(
                'color'   => 'red',
                'shadow'  => true,
                'rounded' => false,
                'style'   => '',
            ),
            'tip_position'  => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect'    => array(
                'show' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'mouseover',
                ),
                'hide' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'click mouseleave',
                ),
            ),
        )
    );

    // Panel Intro text -> before the form
    if ( ! isset( $args['global_variable'] ) || $args['global_variable'] !== false ) {
        if ( ! empty( $args['global_variable'] ) ) {
            $v = $args['global_variable'];
        } else {
            $v = str_replace( '-', '_', $args['opt_name'] );
        }
        $args['intro_text'] = sprintf( __( '<p></p>', 'covid19-toolkit' ), $v );
    } else {
        $args['intro_text'] = __( '<p>This text is displayed above the options panel. It isn\'t required, but more info is always better! The intro_text field accepts all HTML.</p>', 'covid19-toolkit' );
    }
    Redux::setArgs( $opt_name, $args );
    // END ARGUMENTS

    // START HELP TABS
    $tabs = array(
        array(
            'id'      => 'redux-help-tab-1',
            'title'   => __( 'Theme Information 1', 'covid19-toolkit' ),
            'content' => __( '<p>This is the tab content, HTML is allowed.</p>', 'covid19-toolkit' )
        ),
        array(
            'id'      => 'redux-help-tab-2',
            'title'   => __( 'Theme Information 2', 'covid19-toolkit' ),
            'content' => __( '<p>This is the tab content, HTML is allowed.</p>', 'covid19-toolkit' )
        )
    );
    Redux::setHelpTab( $opt_name, $tabs );

    // Set the help sidebar
    $content = __( '<p>This is the sidebar content, HTML is allowed.</p>', 'covid19-toolkit' );
    Redux::setHelpSidebar( $opt_name, $content );

// General Options
Redux::setSection( $opt_name, array(
    'title'             => __( 'General Options', 'covid19-toolkit' ),
    'id'                => 'general_options',
    'customizer'        => false,
    'icon'              => ' el el-home',
    'fields'     => array(
        array(
            'id' => 'covid19_enable_rtl',
            'type' => 'select',
            'options' => array(
                'enable'        => 'Enable',
                'disable'       => 'Disable',
            ),
            'title'     => esc_html__( 'RTL', 'covid19-toolkit' ),
            'default'   => 'disable',
        ),
        array(
            'id'       => 'covid19_main_logo',
            'type'     => 'media',
            'url'      => true,
            'title'    => __( 'Site Primary Logo', 'covid19-toolkit' ),
            'desc'     => __( 'Recommended sizes - width: 195px, height: 40px.', 'covid19-toolkit' ),
        ),
        array(
            'id'       => 'covid19_secondary_logo',
            'type'     => 'media',
            'url'      => true,
            'title'    => __( 'Site Secondary Logo', 'covid19-toolkit' ),
            'desc'     => __( 'Recommended sizes - width: 195px, height: 40px.', 'covid19-toolkit' ),
        ),
        array(
            'id'       => 'covid19_mobile_logo',
            'type'     => 'media',
            'url'      => true,
            'title'    => __( 'Logo For Mobile (optional)', 'covid19-toolkit' ),
            'desc'     => __( 'Recommended sizes - width: 195px, height: 40px.', 'covid19-toolkit' ),
        ),

        array(
            'id'        => 'enable_sticky_header',
            'type'      => 'switch',
            'title'     => esc_html__('Enable Sticky Header', 'covid19-toolkit'),
            'desc'      => esc_html__('', 'covid19-toolkit'),
            'default'   => '1'
        ),
        array(
            'id'        => 'enable_back_to_top',
            'type'      => 'switch',
            'title'     => esc_html__('Enable back-to-top Button', 'covid19-toolkit'),
            'default'   => '1'
        ),
        array(
            'id'        => 'enable_preloader',
            'type'      => 'switch',
            'title'     => esc_html__('Enable Preloader', 'covid19-toolkit'),
            'default'   => '1'
        ),
        array(
			'id'    => 'covid19_search_placeholder_text',
            'type'  => 'text',
			'title' => esc_html__('Search Placeholder Text', 'covid19-toolkit'),
        ),
        array(
            'id'        => 'enable_cart_icon',
            'type'      => 'switch',
            'title'     => esc_html__('Enable Cart Icon', 'covid19-toolkit'),
            'default'   => '1'
        ),
        
    ),
) );

// Header Option
Redux::setSection( $opt_name, array(
	'title' => esc_html__('Header', 'covid19-toolkit'),
	'icon'  => 'el el-caret-up',
	'customizer' => false,
	'fields' => array(
        array(
            'id'        => 'covid19_enable_search_icon',
            'type'      => 'switch',
            'title'     => esc_html__('Enable Search Icon', 'covid19-toolkit'),
            'default'   => '1'
        ),
        array(
			'id'    => 'covid19_header_button_text',
            'type'  => 'text',
			'title' => esc_html__('Header Button Text', 'covid19-toolkit'),
        ),
        array(
			'id'    => 'covid19_header_button_link',
            'type'  => 'text',
			'title' => esc_html__('Header Button Link', 'covid19-toolkit'),
        ),
        array(
			'id'    => 'covid19_header_button_icon_class_name',
            'type'  => 'text',
			'title' => esc_html__('Header Button Icon Class Name', 'covid19-toolkit'),
            'desc'  => 'e.g. flaticon-open-book. You can use Font Awesome and Boxicons icon here',
        ),
	)
) );

// Top Basic Fields
Redux::setSection( $opt_name, array(
    'title'            => __( 'Top Header', 'covid19-toolkit' ),
    'id'               => 'basic',
    'customizer'       => false,
    'subsection'       => true,
    'icon'             => 'el el-chevron-up',
    'fields' => array(
        array(
            'id'        => 'covid19_enable_top_header',
            'type'      => 'switch',
            'title'     => esc_html__('Enable Top Header', 'covid19-toolkit'),
            'default'   => '1'
        ),
        array(
            'id'        => 'covid19_enable_top_social',
            'type'      => 'switch',
            'title'     => esc_html__('Enable Top Header Social Icons', 'covid19-toolkit'),
            'default'   => '1'
        ),
        array(
			'id'    => 'covid19_top_header_location',
            'type'  => 'text',
			'title' => esc_html__('Location', 'covid19-toolkit'),
            'required'      => array('covid19_enable_top_header','equals','1'),
        ),
        array(
			'id'    => 'covid19_top_header_phone_title',
            'type'  => 'text',
			'title' => esc_html__('Phone Title', 'covid19-toolkit'),
            'required'      => array('covid19_enable_top_header','equals','1'),
        ),
        array(
			'id'    => 'covid19_top_header_phone',
            'type'  => 'text',
			'title' => esc_html__('Phone Number', 'covid19-toolkit'),
            'required'      => array('covid19_enable_top_header','equals','1'),
        ),
        array(
			'id'    => 'covid19_top_header_phone_link',
            'type'  => 'text',
			'title' => esc_html__('Phone Number Link', 'covid19-toolkit'),
            'required'      => array('covid19_enable_top_header','equals','1'),
        ),
	),
) );


// Social Profiles
Redux::setSection( $opt_name, array(
	'title' => esc_html__('Social Profiles', 'covid19-toolkit'),
	'desc'  => 'Social profiles are used in different places inside the theme.',
	'icon'  => 'el-icon-user',
	'customizer' => false,
	'fields' => array(
        array(
            'id' => 'covid19_social_target',
            'type' => 'select',
            'options' => array(
                '_blank'    => 'Load in a new window. ( _blank )',
                '_self'     => 'Load in the same frame as it was clicked. ( _self )',
                '_parent'   => 'Load in the parent frameset. ( _parent )',
                '_top'      => 'Load in the full body of the window ( _top )',
            ),
            'title'     => __( 'Social Link Target', 'covid19-toolkit' ),
            'default'   => '_blank',
        ),
        
        array(
			'id'    => 'twitter_url',
            'type'  => 'text',
			'title' => esc_html__('Twitter URL', 'covid19-toolkit')
		),
		array(
			'id'    => 'facebook_url',
			'type'  => 'text',
			'title' =>esc_html__('Facebook URL', 'covid19-toolkit')
		),
		array(
			'id'    => 'instagram_url',
			'type'  => 'text',
			'title' => esc_html__('Instagram URL', 'covid19-toolkit')
		),
		array(
			'id'    => 'linkedin_url',
			'type'  => 'text',
			'title' => esc_html__('Linkedin URL', 'covid19-toolkit')
		),
		array(
			'id'    => 'pinterest_url',
			'type'  => 'text',
			'title' =>esc_html__('Pinterest URL', 'covid19-toolkit')
		),
		array(
			'id'    => 'dribbble_url',
			'type'  => 'text',
			'title' =>esc_html__('Dribbble URL', 'covid19-toolkit')
		),
		array(
			'id'    => 'tumblr_url',
			'type'  => 'text',
			'title' =>esc_html__('Tumblr URL', 'covid19-toolkit')
		),
		array(
			'id'    => 'youtube_url',
			'type'  => 'text',
			'title' =>  esc_html__('Youtube URL', 'covid19-toolkit')
		),
		array(
			'id'    => 'flickr_url',
			'type'  => 'text',
			'title' =>  esc_html__('Flickr URL', 'covid19-toolkit')
		),
		array(
			'id'    => 'behance_url',
			'type'  => 'text',
			'title' =>  esc_html__('Behance URL', 'covid19-toolkit'),
		),
		array(
			'id'    => 'github_url',
			'type'  => 'text',
			'title' =>  esc_html__('Github URL', 'covid19-toolkit'),
		),
		array(
			'id'    => 'skype_url',
			'type'  => 'text',
			'title' =>  esc_html__('Skype URL', 'covid19-toolkit'),
		),
		array(
			'id'    => 'rss_url',
			'type'  => 'text',
			'title' =>  esc_html__('RSS URL', 'covid19-toolkit')
		),
	)
) );

// Footer Area
Redux::setSection( $opt_name, array(
    'title'             => __( 'Footer', 'covid19-toolkit' ),
    'id'                => 'footer',
    'customizer'        => false,
    'icon'              => 'el el-edit',
    'fields' => array(
        array(
            'id'        => 'covid19_enable_newsletter',
            'type'      => 'switch',
            'title'     => esc_html__('Enable Footer Newsletter', 'covid19-toolkit'),
            'default'   => '1'
        ),
		array(
			'id'        => 'covid19_newsletter_title',
			'type'      => 'text',
			'title'     =>  esc_html__('Newsletter Title', 'covid19-toolkit'),
            'required'  => array('covid19_enable_newsletter','equals','1'),
        ),
        array(
			'id'    => 'covid19_newsletter_placeholder',
			'type'  => 'text',
			'title' =>  esc_html__('Newsletter Placeholder Text', 'covid19-toolkit'),
            'required'  => array('covid19_enable_newsletter','equals','1'),
        ),
        array(
			'id'    => 'covid19_newsletter_button',
			'type'  => 'text',
			'title' =>  esc_html__('Newsletter Button Text', 'covid19-toolkit'),
            'required'  => array('covid19_enable_newsletter','equals','1'),
        ),
        array(
			'id'    => 'covid19_newsletter_button_icon',
            'type'  => 'text',
			'title' => esc_html__('Newsletter Button Icon Class Name', 'covid19-toolkit'),
            'desc'  => 'e.g. flaticon-plane. You can use Font Awesome and Boxicons icon here',
            'required'  => array('covid19_enable_newsletter','equals','1'),
        ),
        array(
            'id'        => 'covid19_copyright_text',
            'type'      => 'editor',
            'title'     => esc_html__('Footer copyright text (optional)', 'covid19-toolkit'),
            'subtitle'  => esc_html__('HTML and Shortcodes are allowed', 'covid19-toolkit'),
            'desc'      => '',
            'args' => array(
                'teeny'         => true,
                'media_buttons' => false
            ),
        ),
        array(
            'id'        => 'covid19_footer_text',
            'type'      => 'editor',
            'title'     => esc_html__('Footer info text', 'covid19-toolkit'),
            'subtitle'  => esc_html__('HTML and Shortcodes are allowed', 'covid19-toolkit'),
            'desc'      => '',
            'args' => array(
                'teeny'         => true,
                'media_buttons' => false
            ),
        ),
        array(
            'id'       => 'covid19_footer_shape1',
            'type'     => 'media',
            'url'      => true,
            'title'    => __( 'Footer Shape Image One', 'covid19-toolkit' ),
        ),
        array(
            'id'       => 'covid19_footer_shape2',
            'type'     => 'media',
            'url'      => true,
            'title'    => __( 'Footer Shape Image Two', 'covid19-toolkit' ),
        ),
        array(
            'id'       => 'covid19_footer_shape3',
            'type'     => 'media',
            'url'      => true,
            'title'    => __( 'Footer Shape Image Three', 'covid19-toolkit' ),
        ),
    ) 
));

// Styling 
Redux::setSection( $opt_name, array(
    'title'        => __( 'Styling Options', 'covid19-toolkit' ),
    'id'           => 'styling_options',
    'customizer'   => false,
    'icon'         => ' el el-magic',
    'fields'     => array(
        array(
            'id'            => 'primary_color',
            'type'          => 'color',
            'title'         => esc_html__('Primary Color', 'covid19-toolkit'),
            'default'       => '#4f87fb',
            'validate'      => 'color',
            'transparent'   => false,
        ),
        array(
            'id'            => 'secondary_color',
            'type'          => 'color',
            'title'         => esc_html__('Secondary Color', 'covid19-toolkit'),
            'default'       => '#130947',
            'validate'      => 'color',
            'transparent'   => false,
        ),
        array(
            'id'            => 'top_bar_bg_color',
            'type'          => 'color',
            'title'         => esc_html__('Top Bar Background Color', 'covid19-toolkit'),
            'default'       => '#4f87fb',
            'validate'      => 'color',
            'transparent'   => false
        ),
        array(
            'id'            => 'top_bar_text_color',
            'type'          => 'color',
            'title'         => esc_html__('Top Bar Text Color', 'covid19-toolkit'),
            'default'       => '#ffffff',
            'validate'      => 'color',
            'transparent'   => false
        ),
        array(
            'id'            => 'nav_bg_color',
            'type'          => 'color',
            'title'         => esc_html__('Navbar Background Color', 'covid19-toolkit'),
            'default'       => '#ffffff',
            'validate'      => 'color',
            'transparent'   => false
        ),
        array(
            'id'            => 'nav_item_color',
            'type'          => 'color',
            'title'         => esc_html__('Navbar Item Color', 'covid19-toolkit'),
            'default'       => '#130947',
            'validate'      => 'color',
            'transparent'   => false
        ),
        array(
            'id'            => 'nav_item_active_color',
            'type'          => 'color',
            'title'         => esc_html__('Navbar Item Active Color', 'covid19-toolkit'),
            'default'       => '#4f87fb',
            'validate'      => 'color',
            'transparent'   => false
        ),
        array(
            'id'            => 'nav_two_bg_color',
            'type'          => 'color',
            'title'         => esc_html__('Navbar Style Two Background Color', 'covid19-toolkit'),
            'default'       => '#130947 ',
            'validate'      => 'color',
            'transparent'   => false
        ),
        array(
            'id'            => 'covid19_footer_bg',
            'type'          => 'color',
            'title'         => esc_html__('Footer Background Color.', 'covid19-toolkit'),
            'default'       => '#130947',
            'validate'      => 'color',
            'transparent'   => false
        ),
        array(
            'id' => 'covid19_footer_heading',
            'type' => 'color',
            'title' => __('Footer Heading Title Color', 'parco-toolkit'),
            'default' => '#ffffff',
            'validate' => 'color',
            'transparent' => false
        ),
        array(
            'id' => 'covid19_footer_text_color',
            'type' => 'color',
            'title' => __('Footer Text Color', 'parco-toolkit'),
            'default' => '#e4e4e4',
            'validate' => 'color',
            'transparent' => false
        ),
        array(
            'id'            => 'covid19_footer_bottom_bg',
            'type'          => 'color',
            'title'         => esc_html__('Bottom Footer Background Color.', 'covid19-toolkit'),
            'default'       => '#07002b',
            'validate'      => 'color',
            'transparent'   => false
        ),
        array(
            'id' => 'covid19_f_bottom_text',
            'type' => 'color',
            'title' => __('Footer Bottom Text Color', 'parco-toolkit'),
            'default' => '#f8f8f8',
            'validate' => 'color',
            'transparent' => false
        ),
        array(
            'id' => 'covid19_f_bottom_hover',
            'type' => 'color',
            'title' => __('Footer Bottom Link Hover Color', 'parco-toolkit'),
            'default' => '#4f87fb',
            'validate' => 'color',
            'transparent' => false
        ),
    ),
) );

// Blog Area
Redux::setSection( $opt_name, array(
    'title'         => esc_html__( 'Blog Settings', 'covid19-toolkit' ),
    'id'            => 'covid19_blog',
    'customizer'    => false,
    'icon'          => 'el el-file-edit',
    'desc'          => 'Manage your blog settings.',
    'fields' => array(
        
        array(
			'id'    => 'covid19_hide_blog_banner',
            'type'  => 'switch',
            'title' => esc_html__('Hide Blog Banner', 'covid19-toolkit'),
            'default'   => '0'
        ),
        array(
            'id'       => 'covid19_blog_bg',
            'type'     => 'media',
            'url'      => true,
            'title'    => __( 'Blog Page Background Image', 'covid19-toolkit' ),
            'required'  => array('covid19_hide_blog_banner','equals','0'),
        ),
        array(
            'id'       => 'covid19_search_bg',
            'type'     => 'media',
            'url'      => true,
            'title'    => __( 'Search Page Background Image', 'covid19-toolkit' ),
            'required'  => array('covid19_hide_blog_banner','equals','0'),
        ),
        array(
            'id'       => 'covid19_archive_bg',
            'type'     => 'media',
            'url'      => true,
            'title'    => __( 'Archive Page Background Image', 'covid19-toolkit' ),
            'required'  => array('covid19_hide_blog_banner','equals','0'),
        ),
        array(
			'id'    => 'covid19_search_page',
            'type'  => 'switch',
            'title' => esc_html__('Enable Pages on Search Result Page', 'covid19-toolkit'),
        ),
        array(
			'id'        => 'covid19_hide_breadcrumb',
            'type'      => 'switch',
			'title'     => esc_html__('Hide Blog Breadcrumb', 'covid19-toolkit'),
            'default'   => '0',
            'required'  => array('covid19_hide_blog_banner','equals','0'),
        ),
        array(
            'id'       => 'covid19_blog_title',
            'type'     => 'text',
            'title'    => esc_html__( 'Blog Page Title', 'covid19-toolkit' ),
            'required'      => array('covid19_hide_blog_banner','equals','0'),
        ),
        array(
            'id'       => 'covid19_read_more',
            'type'     => 'text',
            'title'    => esc_html__( 'Blog Read More Text', 'covid19-toolkit' ),
        ),
        array(
            'id'       => 'covid19_by_text',
            'type'     => 'text',
            'title'    => esc_html__( 'Blog By Text', 'covid19-toolkit' ),
        ),
        array(
            'id' => 'covid19_blog_sidebar',
            'type' => 'select',
            'options' => array(
                'covid19_with_sidebar'              => 'With Sidebar',
                'covid19_without_sidebar'           => 'Without Sidebar ( full width )',
                'covid19_without_sidebar_center'    => 'Without Sidebar( center )',
            ),
            'title'     => __( 'Blog Sidebar', 'covid19-toolkit' ),
            'default'   => 'covid19_with_sidebar',
        ),
    ) 
));

// Doctor Area
Redux::setSection( $opt_name, array(
    'title'         => esc_html__( 'Doctor Settings', 'covid19-toolkit' ),
    'id'            => 'covid19_doctor',
    'customizer'    => false,
    'icon'          => 'el el-adult',
    'desc'          => 'Manage your doctor settings.',
    'fields' => array(
        
        array(
			'id'    => 'covid19_hide_doctor_banner',
            'type'  => 'switch',
            'title' => esc_html__('Hide Doctor Banner', 'covid19-toolkit'),
            'default'   => '0'
        ),
        array(
			'id'        => 'covid19_doctor_hide_breadcrumb',
            'type'      => 'switch',
			'title'     => esc_html__('Hide Doctor Breadcrumb', 'covid19-toolkit'),
            'default'   => '0',
            'required'  => array('covid19_hide_doctor_banner','equals','0'),
        ),
        
        array(
            'id'       => 'doctor_permalink',
            'type'     => 'text',
            'title'    => esc_html__( 'Single Doctor Permalink', 'simile-toolkit' ),
            'default'  => __('doctor-post', 'simile-toolkit'),
            'desc'     => '<p>After changing the permalink go to <strong style="color:#28a745;">Settings Permalinks</strong> and hit <strong style="color:#28a745;">Save Changes</strong> button.</p>',
        ),
    ) 
));

// WooCommerce Product
Redux::setSection( $opt_name, array(
    'title' => esc_html__( 'WooCommerce Product', 'covid19-toolkit' ),
    'desc'  => esc_html__( 'Manage product page settings.', 'covid19-toolkit' ),
    'icon'  => 'el-icon-list-alt',
    'customizer'    => false,
    'fields' => array(
        array(
            'id'        => 'enable_shop_pages_banner',
            'type'      => 'switch',
            'title'     => esc_html__('Enable WooCommerce Page Banner', 'covid19-toolkit'),
            'default'   => '0'
        ),
        array(
			'id'    => 'hide_woo_breadcrumb',
            'type'  => 'switch',
			'title' => esc_html__('Hide WooCommerce Breadcrumb', 'covid19-toolkit'),
            'default'   => '0',
            'required'      => array('enable_shop_pages_banner','equals','1'),
        ),
        array(
            'id'       => 'product_bg_image',
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'WooCommerce Page Background Image', 'covid19-toolkit' ),
            'required' => array('enable_shop_pages_banner','equals','1'),
        ),
        array(
            'id'        => 'products_page_count',
            'desc'      => esc_html__( 'Number of products per page on product pages.', 'covid19-toolkit' ),
            'type'      => 'text',
            'title'     => esc_html__( 'Products per page', 'covid19-toolkit' ),
            'default'   => '6',
        ),
        array(
            'id'    => 'covid19_product_sidebar',
            'type'  => 'select',
            'options' => array(
                'covid19_product_no_sidebar'       => 'None',
                'covid19_product_left_sidebar'     => 'Sidebar on the left',
                'covid19_product_right_sidebar'    => 'Sidebar on the right',
            ),
            'title'     => esc_html__( 'Product Sidebar Position', 'covid19-toolkit' ),
            'default'   => 'covid19_product_no_sidebar',
        ),
        array(
            'id'    => 'covid19_related_product_count',
            'type'  => 'text',
            'title' => esc_html__( 'Product Details Related Product Count', 'covid19-toolkit' ),
            'desc'  => esc_html__( 'e.g. 3', 'covid19-toolkit' ),
            'default' => '3',
        ),
    ),
));

// Typography
Redux::setSection( $opt_name, array(
    'title' => __( 'Typography', 'covid19-toolkit' ),
    'desc' => __( 'Manage your fonts and typefaces.', 'covid19-toolkit' ),
    'icon' => 'el-icon-fontsize',
    'customizer'    => false,
    'fields' => array(
        array(
            'id'            => 'opt-typography-body',
            'type'          => 'typography',
            'title'         => __( 'Body font', 'covid19-toolkit' ),
            'google'        => true, // Disable google fonts. Won't work if you haven't defined your google api key
            'font-backup'   => true, // Select a backup non-google font in addition to a google font
            'all_styles'    => false, // Enable all Google Font style/weight variations to be added to the page
            'font-style'    => false,
            'font-weight'   => false,
            'font-size'     => false,
            'text-align'    => false,
            'color'         => false,
            'line-height'   => false,
            'output' => array(
                'body',
            ), // An array of CSS selectors to apply this font style to dynamically
            'default' => array(
                'font-family' => 'Open Sans',
                'google' => true,
            ),
        ),
    ),
) );

// Advanced Settings
Redux::setSection( $opt_name, array(
	'title'         => esc_html__('Advanced Settings', 'covid19-toolkit'),
    'icon'          => 'el-icon-cogs',
    'customizer'    => false,
	'fields' => array(
		array(
			'id' => 'css_code',
			'type' => 'ace_editor',
			'title' => esc_html__('Custom CSS Code', 'covid19-toolkit'),
			'desc' => esc_html__('e.g. .btn-primary{ background: #000; } Don\'t use &lt;style&gt; tags', 'covid19-toolkit'),
			'subtitle' => esc_html__('Paste your CSS code here.', 'covid19-toolkit'),
			'mode' => 'css',
			'theme' => 'monokai'
		),
		array(
			'id'        => 'js_code',
			'type'      => 'ace_editor',
			'title'     => esc_html__('Custom JS Code', 'covid19-toolkit'),
			'desc'      => esc_html__('e.g. alert("Hello World!"); Don\'t use&lt;script&gt;tags.', 'covid19-toolkit'),
			'subtitle'  => esc_html__('Paste your JS code here.', 'covid19-toolkit'),
			'mode'      => 'javascript',
			'theme'     => 'monokai'
		)
	)
) );

// 404 Area
Redux::setSection( $opt_name, array(
    'title'             => esc_html__( '404 Settings', 'covid19-toolkit' ),
    'id'                => 'covid19_404',
    'customizer'        => false,
    'icon'              => 'el el-question-sign',
    'fields'            => array(
        array(
            'id'    => 'covid19_top_title_not_found',
            'type'  => 'text',
            'title' => esc_html__('404 Top Title', 'covid19-toolkit'),
        ),
        array(
            'id'    => 'covid19_title_not_found',
            'type'  => 'text',
            'title' => esc_html__('404 Title', 'covid19-toolkit'),
        ),
        array(
            'id'       => 'covid19_content_not_found',
            'type'     => 'textarea',
            'title'    => esc_html__( '404 Content', 'covid19-toolkit' ),
        ),
        array(
            'id'       => 'covid19_button_not_found',
            'type'     => 'text',
            'title'    => esc_html__( 'Back to Home Button Text', 'covid19-toolkit' ),
        ),
    ) 
));

    /**
     * This is a test function that will let you see when the compiler hook occurs.
     * It only runs if a field    set with compiler=>true is changed.
     * */
    if ( ! function_exists( 'compiler_action' ) ) {
        function compiler_action( $options, $css, $changed_values ) {
            echo '<h1>The compiler hook has run!</h1>';
            echo "<pre>";
            print_r( $changed_values ); // Values that have changed since the last save
            echo "</pre>";
            //print_r($options); //Option values
            //print_r($css); // Compiler selector CSS values  compiler => array( CSS SELECTORS )
        }
    }

    // Custom function for the callback validation referenced above
    if ( ! function_exists( 'redux_validate_callback_function' ) ) {
        function redux_validate_callback_function( $field, $value, $existing_value ) {
            $error   = false;
            $warning = false;

            //do your validation
            if ( $value == 1 ) {
                $error = true;
                $value = $existing_value;
            } elseif ( $value == 2 ) {
                $warning = true;
                $value   = $existing_value;
            }

            $return['value'] = $value;

            if ( $error == true ) {
                $field['msg']    = 'your custom error message';
                $return['error'] = $field;
            }

            if ( $warning == true ) {
                $field['msg']      = 'your custom warning message';
                $return['warning'] = $field;
            }

            return $return;
        }
    }

    // Custom function for the callback referenced above
    if ( ! function_exists( 'redux_my_custom_field' ) ) {
        function redux_my_custom_field( $field, $value ) {
            print_r( $field );
            echo '<br/>';
            print_r( $value );
        }
    }

    /**
     * Custom function for filtering the sections array. Good for child themes to override or add to the sections.
     * Simply include this function in the child themes functions.php file.
     * NOTE: the defined constants for URLs, and directories will NOT be available at this point in a child theme,
     * so you must use get_template_directory_uri() if you want to use any of the built in icons
     * */
    if ( ! function_exists( 'dynamic_section' ) ) {
        function dynamic_section( $sections ) {
            //$sections = array();
            $sections[] = array(
                'title'  => __( 'Section via hook', 'covid19-toolkit' ),
                'desc'   => __( '<p class="description">This is a section created by adding a filter to the sections array. Can be used by child themes to add/remove sections from the options.</p>', 'covid19-toolkit' ),
                'icon'   => 'el el-paper-clip',
                // Leave this as a blank section, no options just some intro text set above.
                'fields' => array()
            );

            return $sections;
        }
    }

    // Filter hook for filtering the args. Good for child themes to override or add to the args array. Can also be used in other functions.
    if ( ! function_exists( 'change_arguments' ) ) {
        function change_arguments( $args ) {
            //$args['dev_mode'] = true;

            return $args;
        }
    }

    // Filter hook for filtering the default value of any given field. Very useful in development mode.
    if ( ! function_exists( 'change_defaults' ) ) {
        function change_defaults( $defaults ) {
            $defaults['str_replace'] = 'Testing filter hook!';

            return $defaults;
        }
    }

    // Removes the demo link and the notice of integrated demo from the redux-framework plugin
    if ( ! function_exists( 'remove_demo' ) ) {
        function remove_demo() {
            // Used to hide the demo mode link from the plugin page. Only used when Redux is a plugin.
            if ( class_exists( 'ReduxFrameworkPlugin' ) ) {
                remove_filter( 'plugin_row_meta', array(
                    ReduxFrameworkPlugin::instance(),
                    'plugin_metalinks'
                ), null, 2 );

                // Used to hide the activation notice informing users of the demo panel. Only used when Redux is a plugin.
                remove_action( 'admin_notices', array( ReduxFrameworkPlugin::instance(), 'admin_notices' ) );
            }
        }
    }

