<?php
/**
 * Doctrine About Us Widget
 */

namespace Elementor;
class Doctrine_About_Us extends Widget_Base {

	public function get_name() {
        return 'Doctrine_About_Us';
    }

	public function get_title() {
        return __( 'About Us', 'covid19-toolkit' );
    }

	public function get_icon() {
        return 'eicon-info-box';
    }

	public function get_categories() {
        return [ 'covid19-elements' ];
    }

	protected function _register_controls() {

        $this->start_controls_section(
			'Doctrine_About_Us',
			[
				'label' => __( 'About Us', 'covid19-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

            $this->add_control(
                'choose_style',
                [
                    'label' => __( 'Choose Style', 'covid19-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        '1'   => __( 'Style One', 'covid19-toolkit' ),
                        '2'   => __( 'Style Two', 'covid19-toolkit' ),
                        '3'   => __( 'Style Three', 'covid19-toolkit' ),
                    ],
                    'default' => '1',
                ]
            );

			$this->add_control(
				'top_title',
				[
					'label' => __( 'Top Title', 'covid19-toolkit' ),
					'type' => Controls_Manager::TEXT,
					'default' => esc_html__('Covid-19', 'covid19-toolkit'),
				]
			);
			$this->add_control(
				'title',
				[
					'label' => __( 'Title', 'covid19-toolkit' ),
					'type' => Controls_Manager::TEXTAREA,
					'default' => esc_html__('About Coronavirus Disease', 'covid19-toolkit'),
				]
            );
            $this->add_control(
                'title_tag',
                [
                    'label' => __( 'Title Tag', 'covid19-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1'         => __( 'h1', 'covid19-toolkit' ),
                        'h2'         => __( 'h2', 'covid19-toolkit' ),
                        'h3'         => __( 'h3', 'covid19-toolkit' ),
                        'h4'         => __( 'h4', 'covid19-toolkit' ),
                        'h5'         => __( 'h5', 'covid19-toolkit' ),
                        'h6'         => __( 'h6', 'covid19-toolkit' ),
                    ],
                    'default' => 'h2',
                ]
            );
			$this->add_control(
				'content',
				[
					'label' => __( 'Content', 'covid19-toolkit' ),
					'type' => Controls_Manager::WYSIWYG,
					'default' => esc_html__('In 2019, the Centers for Disease Control and Prevention (CDC) started monitoring the outbreak of a new coronavirus, SARS-CoV-2, which causes the respiratory illness now known as COVID-19. Authorities first identified the virus in Wuhan, China.', 'covid19-toolkit'),
				]
            );
            $this->add_control(
                'image_alignment',
                [
                    'label' => __( 'Image Alignment', 'covid19-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'left'         => __( 'Left', 'covid19-toolkit' ),
                        'right'        => __( 'Right', 'covid19-toolkit' ),
                    ],
                    'default' => 'left',
                    'condition' => [
                        'choose_style' => '3',
                    ]
                ]
            );
			$this->add_control(
				'image1',
				[
					'label' => __( 'About Image One', 'covid19-toolkit' ),
					'type' => Controls_Manager::MEDIA,
				]
			);
			$this->add_control(
				'image2',
				[
					'label' => __( 'About Image Two', 'covid19-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                    'condition' => [
                        'choose_style!' => '3',
                    ]
				]
			);
			$this->add_control(
				'button_text',
				[
					'label' => __( 'Button Text', 'covid19-toolkit' ),
					'type' => Controls_Manager::TEXT,
					'default' => __('Know More', 'covid19-toolkit'),
				]
            );
            $this->add_control(
				'button_icon',
				[
					'label' => __( 'Button Icon Class', 'covid19-toolkit' ),
					'type' => Controls_Manager::TEXT,
                    'default' => __('flaticon-open-book', 'covid19-toolkit'),
                    'description' => __('e.g flaticon-open-book. You can use Font-Awesome/Boxicons', 'covid19-toolkit'),
				]
			);
			$this->add_control(
                'link_type',
                [
                    'label' => esc_html__( 'Button Link Type', 'covid19-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options' => [
                        '1'  => esc_html__( 'Link To Page', 'covid19-toolkit' ),
                        '2' => esc_html__( 'External Link', 'covid19-toolkit' ),
                    ], 
                ]
            );
            
            $this->add_control(
                'link_to_page',
                [
                    'label' => esc_html__( 'Button Link Page', 'covid19-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options' => covid19_toolkit_get_page_as_list(),
                    'condition' => [
                        'link_type' => '1',
                    ]
                ]
            );
            
            $this->add_control(
                'ex_link',
                [
                    'label'=>esc_html__('Button External Link', 'covid19-toolkit'),
                    'type'=>Controls_Manager:: TEXT,
                    'condition' => [
                        'link_type' => '2',
                    ]
                ]
            );
        $this->end_controls_section();

        $this->start_controls_section(
			'about_style',
			[
				'label' => __( 'Style', 'covid19-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'top_title_typography',
                    'label' => __( 'Top Title Typography', 'covid19-toolkit' ),
                    'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .about-content .sub-title, .about-content-two .sub-title',
                ]
            );

            $this->add_control(
                'top_title_color',
                [
                    'label' => __( 'Top Title Color', 'covid19-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-content .sub-title, .about-content-two .sub-title' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => __( 'Title Typography', 'covid19-toolkit' ),
                    'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .about-content h1, .about-content h2, .about-content h3, .about-content h4, .about-content h5, .about-content h6, .about-content-two h2, .about-content-two h1, .about-content-two h3, .about-content-two h4, .about-content-two h5',
                ]
            );
            
            $this->add_control(
                'title_color',
                [
                    'label' => __( 'Title Color', 'covid19-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-content h1, .about-content h2, .about-content h3, .about-content h4, .about-content h5, .about-content h6, .about-content-two h2, .about-content-two h1, .about-content-two h3, .about-content-two h4, .about-content-two h5' => 'color: {{VALUE}}',
                    ],
                ]
            );

        $this->end_controls_section();
    }

	protected function render() {

        $settings = $this->get_settings_for_display();	

        // Get Button Link
        if($settings['link_type'] == 1 ):
            $link = get_page_link($settings['link_to_page']); 
        else:
            $link = $settings['ex_link'];
        endif;
        ?>
        <?php if ( $settings['choose_style']  == '1' ) : ?>
            <div class="about-area ptb-100">
                <div class="container">
                    <div class="row align-items-center">
                        <div class="col-lg-6 col-md-12">
                            <div class="about-image">
                                <?php if( $settings['image1']['url'] ): ?>
                                    <img src="<?php echo esc_url( $settings['image1']['url'] ); ?>" alt="<?php echo esc_attr( $settings['title'] ); ?>">
                                <?php endif; ?>

                                <?php if( $settings['image2']['url'] ): ?>
                                    <img src="<?php echo esc_url( $settings['image2']['url'] ); ?>" alt="<?php echo esc_attr( $settings['title'] ); ?>">
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="col-lg-6 col-md-12">
                            <div class="about-content">
                                <span class="sub-title"><?php echo esc_html( $settings['top_title'] ); ?></span>
                                <<?php echo esc_attr( $settings['title_tag'] ); ?>><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>

                                <?php echo wp_kses_post( $settings['content'] ) ?>

                                <?php if( $settings['button_text'] != '' ): ?>
                                    <?php if( $settings['button_icon'] != '' ): ?>
                                        <a href="<?php echo esc_url( $link ); ?>" class="default-btn"><i class="<?php echo esc_attr( $settings['button_icon'] ); ?>"></i> <?php echo esc_html( $settings['button_text'] ); ?></a>
                                    <?php else: ?>                                
                                        <a href="<?php echo esc_url( $link ); ?>" class="default-btn btn_without_icon"> <?php echo esc_html( $settings['button_text'] ); ?></a>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php elseif ( $settings['choose_style']  == '2' ) : ?>
            <div class="about-section pt-100">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-6 col-md-12">
                            <div class="about-img">
                                <?php if( $settings['image1']['url'] ): ?>
                                    <img src="<?php echo esc_url( $settings['image1']['url'] ); ?>" alt="<?php echo esc_attr( $settings['title'] ); ?>">
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="col-lg-6 col-md-12">
                            <div class="about-content">
                                <span class="sub-title"><?php echo esc_html( $settings['top_title'] ); ?></span>
                                <<?php echo esc_attr( $settings['title_tag'] ); ?>><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>

                                <?php echo wp_kses_post( $settings['content'] ) ?>

                                <?php if ( $settings['button_text'] != '' ) : ?>
                                    <?php if ( $settings['button_icon'] != '' ) : ?>
                                        <a href="<?php echo esc_url( $link ); ?>" class="default-btn"><i class="<?php echo esc_attr( $settings['button_icon'] ); ?>"></i> <?php echo esc_html( $settings['button_text'] ); ?></a>
                                    <?php else: ?>                                
                                        <a href="<?php echo esc_url( $link ); ?>" class="default-btn btn_without_icon"> <?php echo esc_html( $settings['button_text'] ); ?></a>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="about-shape1">
                    <?php if( $settings['image2']['url'] ): ?>
                        <img src="<?php echo esc_url( $settings['image2']['url'] ); ?>" alt="<?php echo esc_attr( $settings['title'] ); ?>">
                    <?php endif; ?>
                </div>
            </div>
        <?php elseif ( $settings['choose_style']  == '3' ) : ?>
            <div class="container">
                <div class="about-inner-area">
                    <div class="row align-items-center">
                        <?php if ( $settings['image_alignment'] == 'left' ) : ?>
                            <div class="col-lg-6 col-md-12 image">
                                <div class="about-image-two">
                                    <?php if( $settings['image1']['url'] ): ?>
                                        <img src="<?php echo esc_url( $settings['image1']['url'] ); ?>" alt="<?php echo esc_attr( $settings['title'] ); ?>">
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endif; ?>

                        <div class="col-lg-6 col-md-12 content">
                            <div class="about-content-two">
                                <span class="sub-title"><?php echo esc_html( $settings['top_title'] ); ?></span>
                                <<?php echo esc_attr( $settings['title_tag'] ); ?>><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>

                                <?php echo wp_kses_post( $settings['content'] ) ?>
                            </div>
                        </div>
                        <?php if ( $settings['image_alignment'] == 'right' ) : ?>
                            <div class="col-lg-6 col-md-12 image">
                                <div class="about-image-two">
                                    <?php if( $settings['image1']['url'] ): ?>
                                        <img src="<?php echo esc_url( $settings['image1']['url'] ); ?>" alt="<?php echo esc_attr( $settings['title'] ); ?>">
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endif; ?>

                    </div>
                </div>
            </div>
        <?php endif; ?>

        <?php
	}
	protected function _content_template() {}
}
Plugin::instance()->widgets_manager->register_widget_type( new Doctrine_About_Us );