<?php
/**
 * Banner Four Widget
 */

namespace Elementor;
class Doctrine_Banner_Four extends Widget_Base {

	public function get_name() {
        return 'BannerFour';
    }

	public function get_title() {
        return __( 'Banner Four', 'covid19-toolkit' );
    }

	public function get_icon() {
        return 'eicon-banner';
    }

	public function get_categories() {
        return [ 'covid19-elements' ];
    }

	protected function _register_controls() {

        $this->start_controls_section(
			'section',
			[
				'label' => __( 'Banner Content', 'covid19-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );
            $this->add_control(
                'title_tag',
                [
                    'label' => __( 'Title Tag', 'holab-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1'         => __( 'h1', 'holab-toolkit' ),
                        'h2'         => __( 'h2', 'holab-toolkit' ),
                        'h3'         => __( 'h3', 'holab-toolkit' ),
                        'h4'         => __( 'h4', 'holab-toolkit' ),
                        'h5'         => __( 'h5', 'holab-toolkit' ),
                        'h6'         => __( 'h6', 'holab-toolkit' ),
                    ],
                    'default' => 'h1',
                ]
            );
           $this->add_control(
                'title', 
                [
                    'label' => __( 'Title', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXTAREA,
                    'label_block' => true,
					'default' => __('We’ll Defeat Coronavirus!', 'covid19-toolkit'),
                ]
            );            
           $this->add_control(
                'content', [
                    'label' => __( 'Content', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXTAREA,
                    'show_label' => false,
					'default' => __('Be Clean & Keep Clean, Maintain Social Distance, Avoid All Kinds of Crowds including Social Gathering, Protect Yourself and Others, Save Humankind!', 'covid19-toolkit'),
                ]
            );
           $this->add_control(
                'background_image',
                [
                    'label' => __( 'Background Image', 'plugin-domain' ),
                    'type' => Controls_Manager::MEDIA,
                    'label_block' => true,
                    'separator'=>'after', 
                    'separator'=>'before',
                ]
            );
           $this->add_control(
                'left_button', 
                [
                    'label' => __( 'Left Button Text', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
					'default' => __('Learn More', 'covid19-toolkit'),
                ]
            );
           $this->add_control(
                'left_button_icon', 
                [
                    'label' => __( 'Left Button Icon Class Name', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                    'placeholder' => __( 'flaticon-open-book', 'plugin-domain' ),
					'default' 	=> __('flaticon-open-book', 'covid19-toolkit'),
                ]
            );
            $this->add_control(
                'link_type',
                [
                    'label' => esc_html__( 'Button Link Type', 'covid19-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options' => [
                        '1'  => esc_html__( 'Link To Page', 'covid19-toolkit' ),
                        '2' => esc_html__( 'External Link', 'covid19-toolkit' ),
                    ], 
                ]
            );
            
            $this->add_control(
                'link_to_page',
                [
                    'label' => esc_html__( 'Button Link Page', 'covid19-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options' => covid19_toolkit_get_page_as_list(),
                    'condition' => [
                        'link_type' => '1',
                    ]
                ]
            );
            
            $this->add_control(
                'ex_link',
                [
                    'label'=>esc_html__('Button External Link', 'covid19-toolkit'),
                    'type'=>Controls_Manager:: TEXT,
                    'condition' => [
                        'link_type' => '2',
                    ]
                ]
            );
            $this->add_control(
                'right_button_icon', 
                [
                    'label' => __( 'Video Button Icon Class Name', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                    'placeholder' => __( 'flaticon-play-button', 'plugin-domain' ),
					'default' 	=> __('flaticon-play-button', 'covid19-toolkit'),
                ]
            );
            $this->add_control(
                'right_button', 
                [
                    'label' => __( 'Video Button Text', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
					'default' 	=> __('Watch Video', 'covid19-toolkit'),
                ]
            );
            $this->add_control(
                'right_button_link', 
                [
                    'label' => esc_html__( 'Video Button Link( YouTube )', 'covid19-toolkit' ),
                    'type' => Controls_Manager::URL,
                    'label_block' => true,
                    'separator'=>'after', 
                    'separator'=>'before',   
                ]
            ); 

        $this->end_controls_section();
        
        $this->start_controls_section(
			'banner_style',
			[
				'label' => __( 'Style', 'covid19-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => __( 'Title Typography', 'covid19-toolkit' ),
                    'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .banner-wrapper-content h1, .banner-wrapper-content h2, .banner-wrapper-content h3, .banner-wrapper-content h4, .banner-wrapper-content h5, .banner-wrapper-content h6',
                ]
            );
            
            $this->add_control(
                'title_color',
                [
                    'label' => __( 'Title Color', 'covid19-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .banner-wrapper-content h1, .banner-wrapper-content h2, .banner-wrapper-content h3, .banner-wrapper-content h4, .banner-wrapper-content h5, .banner-wrapper-content h6' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'content_typography',
                    'label' => __( 'Content Typography', 'covid19-toolkit' ),
                    'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .banner-wrapper-content p',
                ]
            );
            $this->add_control(
                'content_color',
                [
                    'label' => __( 'Content Color', 'covid19-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .banner-wrapper-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );

        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        // Get Button Link
        if($settings['link_type'] == 1 ):
            $link = get_page_link($settings['link_to_page']); 
        else:
            $link = $settings['ex_link'];
        endif;
        
        ?>

        <div class="banner-wrapper banner-bg1 jarallax" style="background-image:url(<?php echo esc_url($settings['background_image']['url']); ?>);" data-jarallax='{"speed": 0.3}'>
            <div class="d-table">
                <div class="d-table-cell">
                    <div class="container">
                        <div class="banner-wrapper-content">
                            <<?php echo esc_attr( $settings['title_tag'] ); ?> data-shadow='<?php echo esc_html( $settings['title'] ); ?>'><?php echo esc_html( $settings['title'] ); ?> </<?php echo esc_attr( $settings['title_tag'] ); ?>>

                            <p><?php echo wp_kses_post( $settings['content'] ); ?></p>

                            <div class="btn-box">
								<?php if( $settings['left_button'] != '' ): ?>
									<?php if( $settings['left_button_icon'] != '' ): ?>
										<a href="<?php echo esc_url( $link ); ?>" class="default-btn">
											<i class="<?php echo esc_attr( $settings['left_button_icon'] ); ?>"></i>
											<?php echo esc_html( $settings['left_button'] ); ?>
										</a>
									<?php else: ?>
										<a href="<?php echo esc_url( $link ); ?>" class="default-btn btn_without_icon">
											<?php echo esc_html( $settings['left_button'] ); ?>
										</a>
									<?php endif; ?>
								<?php endif; ?>

								<?php if( $settings['right_button'] != '' ): ?>
									<?php if( $settings['right_button_icon'] != '' ): ?>
										<a href="<?php echo esc_url( $settings['right_button_link']['url'] ); ?>" class="popup-youtube optional-btn">
											<i class="<?php echo esc_attr( $settings['right_button_icon'] ); ?>"></i>
											<?php echo esc_html( $settings['right_button'] ); ?>
										</a>
									<?php else: ?>
										<a href="<?php echo esc_url( $settings['right_button_link']['url'] ); ?>" class="popup-youtube optional-btn btn_without_icon">
											<?php echo esc_html( $settings['right_button'] ); ?>
										</a>
									<?php endif; ?>
								<?php endif; ?>
							</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
	}

	protected function _content_template() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Doctrine_Banner_Four );