<?php
/**
 * Banner Slider Widget
 */

namespace Elementor;
class Doctrine_Banner_Slider extends Widget_Base {

	public function get_name() {
        return 'BannerSlider';
    }

	public function get_title() {
        return __( 'Banner Slider', 'covid19-toolkit' );
    }

	public function get_icon() {
        return 'eicon-slides';
    }

	public function get_categories() {
        return [ 'covid19-elements' ];
    }

	protected function _register_controls() {

        $this->start_controls_section(
			'slider_section',
			[
				'label' => __( 'Add a Slider', 'covid19-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );
            $this->add_control(
                'style',
                [
                    'label' => __( 'Style', 'tryo-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        '1'         => __( 'Style One', 'tryo-toolkit' ),
                        '2'         => __( 'Style Two', 'tryo-toolkit' ),
                    ],
                    'default' => '1',
                ]
            );
            $this->add_control(
                'title_tag',
                [
                    'label' => __( 'Slider Title Tag', 'holab-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1'         => __( 'h1', 'holab-toolkit' ),
                        'h2'         => __( 'h2', 'holab-toolkit' ),
                        'h3'         => __( 'h3', 'holab-toolkit' ),
                        'h4'         => __( 'h4', 'holab-toolkit' ),
                        'h5'         => __( 'h5', 'holab-toolkit' ),
                        'h6'         => __( 'h6', 'holab-toolkit' ),
                    ],
                    'default' => 'h1',
                ]
            );
        
            $slider = new Repeater();

            $slider->add_control(
                'slider_top_title', 
                [
                    'label' => __( 'Top Title', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );
            $slider->add_control(
                'slider_title', 
                [
                    'label' => __( 'Title', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXTAREA,
                    'label_block' => true,
                ]
            );            
            $slider->add_control(
                'slider_content', [
                    'label' => __( 'Content', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXTAREA,
                    'show_label' => false,
                ]
            );
            $slider->add_control(
                'background_image',
                [
                    'label' => __( 'Background Image', 'covid19-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                    'label_block' => true,
                    'separator'=>'after', 
                    'separator'=>'before',
                ]
            );
            $slider->add_control(
                'image',
                [
                    'label' => __( 'Image', 'covid19-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                    'label_block' => true,
                    'separator'=>'after', 
                    'separator'=>'before',
                ]
            );
            $slider->add_control(
                'left_slider_button', 
                [
                    'label' => __( 'Left Button Text', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );
            $slider->add_control(
                'left_slider_button_icon', 
                [
                    'label' => __( 'Left Button Icon Class Name', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                    'placeholder' => __( 'flaticon-open-book', 'covid19-toolkit' ),
                ]
            );
            $slider->add_control(
                'link_type',
                [
                    'label' => esc_html__( 'Left Button Link Type', 'covid19-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options' => [
                        '1'     => esc_html__( 'Link To Page', 'covid19-toolkit' ),
                        '2'     => esc_html__( 'External Link', 'covid19-toolkit' ),
                    ], 
                ]
            );
            
            $slider->add_control(
                'link_to_page',
                [
                    'label'         => esc_html__( 'Left Button Link Page', 'covid19-toolkit' ),
                    'type'          => Controls_Manager::SELECT,
                    'label_block'   => true,
                    'options'       => covid19_toolkit_get_page_as_list(),
                    'condition'      => [
                        'link_type' => '1',
                    ]
                ]
            );
            
            $slider->add_control(
                'ex_link',
                [
                    'label'=>esc_html__('Left Button External Link', 'covid19-toolkit'),
                    'type'=>Controls_Manager:: TEXT,
                    'condition' => [
                        'link_type' => '2',
                    ]
                ]
            );
            $slider->add_control(
                'right_slider_button_icon', 
                [
                    'label' => __( 'Video Button Icon Class Name', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                    'placeholder' => __( 'flaticon-play-button', 'covid19-toolkit' ),
                ]
            );
            $slider->add_control(
                'right_slider_button', 
                [
                    'label' => __( 'Video Button Text', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );
            $slider->add_control(
                'right_button_link', 
                [
                    'label' => esc_html__( 'Video Button Link( YouTube )', 'covid19-toolkit' ),
                    'type' => Controls_Manager::URL,
                    'label_block' => true,
                    'separator'=>'after', 
                    'separator'=>'before',   
                ]
            );        
            
            $this->add_control(
                'slider_list',
                [
                    'label' => __( 'Slider List', 'covid19-toolkit' ),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $slider->get_controls(),
                    'default' => [
                        [
                            'slider_top_title'          => __( 'Stay Safe &', 'covid19-toolkit' ),
                            'slider_title'              => __( 'Be Informed About Covid-19', 'covid19-toolkit' ),
                            'slider_content'            => __( 'Stay Aware of the Coronavirus, Stay Home & Safe for You and Others, and Maintain All the Safety Measures by Medical Professionals to Defeat It!', 'covid19-toolkit' ),
                            'left_slider_button'        => __( 'Learn More', 'covid19-toolkit' ),
                            'left_slider_button_icon'   => __( 'flaticon-open-book', 'covid19-toolkit' ),
                            'left_button_link'          => __( '#', 'covid19-toolkit' ),
                            'right_button_link'         => __( '#', 'covid19-toolkit' ),
                            'right_slider_button'       => __( 'Watch Video', 'covid19-toolkit' ),
                            'right_slider_button_icon'  => __( 'flaticon-play-button', 'covid19-toolkit' ),
                        ],
                        [
                            'slider_top_title'      => __( 'Stay Safe &', 'covid19-toolkit' ),
                            'slider_title'          => __( "We'll Defeat Coronavirus!", 'covid19-toolkit' ),
                            'slider_content'        => __( 'Be Clean & Keep Clean, Maintain Social Distance, Avoid All Kinds of Crowds Including Social Gathering, Protect Yourself and Others, Save Humankind!', 'covid19-toolkit' ),
                            'left_slider_button'       => __( 'Learn More', 'covid19-toolkit' ),
                            'left_slider_button_icon'   => __( 'flaticon-open-book', 'covid19-toolkit' ),
                            'left_button_link'         => __( '#', 'covid19-toolkit' ),
                            'right_slider_button'        => __( 'Watch Video', 'covid19-toolkit' ),
                            'right_button_link'          => __( '#', 'covid19-toolkit' ),
                            'right_slider_button_icon'  => __( 'flaticon-play-button', 'covid19-toolkit' ),
                        ],
                        [
                            'slider_top_title'          => __( 'COVID-19', 'covid19-toolkit' ),
                            'slider_title'              => __( "Learn Better to Prevent Covid-19", 'covid19-toolkit' ),
                            'slider_content'            => __( 'Know the Symptoms of the Coronavirus(Covid-19) and Inform Others, Follow the Safety Steps Instructed by World Health Organization (WHO).', 'covid19-toolkit' ),
                            'left_slider_button'        => __( 'Learn More', 'covid19-toolkit' ),
                            'left_slider_button_icon'   => __( 'flaticon-open-book', 'covid19-toolkit' ),
                            'left_button_link'          => __( '#', 'covid19-toolkit' ),
                            'right_slider_button'       => __( 'Watch Video', 'covid19-toolkit' ),
                            'right_button_link'         => __( '#', 'covid19-toolkit' ),
                            'right_slider_button_icon'  => __( 'flaticon-play-button', 'covid19-toolkit' ),
                        ],
                    ],
                    'title_field' => '{{{ slider_title }}}',
                ]
            );

        $this->end_controls_section();
        
        $this->start_controls_section(
			'banner_style',
			[
				'label' => __( 'Style', 'covid19-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'top_title_typography',
                    'label' => __( 'Top Title Typography', 'covid19-toolkit' ),
                    'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .main-banner-content .sub-title',
                ]
            );

            $this->add_control(
                'top_title_color',
                [
                    'label' => __( 'Top Title Color', 'covid19-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .main-banner-content .sub-title' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => __( 'Title Typography', 'covid19-toolkit' ),
                    'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .main-banner-content h1, .main-banner-content h2, .main-banner-content h3, .main-banner-content h4, .main-banner-content h5, .main-banner-content h6',
                ]
            );
            
            $this->add_control(
                'title_color',
                [
                    'label' => __( 'Title Color', 'covid19-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .main-banner-content h1, .main-banner-content h2, .main-banner-content h3, .main-banner-content h4, .main-banner-content h5, .main-banner-content h6' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'content_typography',
                    'label' => __( 'Content Typography', 'covid19-toolkit' ),
                    'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .main-banner-content p',
                ]
            );
            $this->add_control(
                'content_color',
                [
                    'label' => __( 'Content Color', 'covid19-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .main-banner-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );

        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display();
        if ( $settings['style'] == '1' ) :
            if ( $settings['slider_list'] ) : ?>
                <div class="home-slides owl-carousel owl-theme">
                    <?php foreach (  $settings['slider_list'] as $item ): ?>
                        <?php
                        // Get Button Link
                        if($item['link_type'] == 1):
                            $link = get_page_link($item['link_to_page']); 
                        else:
                            $link = $item['ex_link'];
                        endif;
                        ?>
                        <div class="main-banner banner-bg1" style="background-image:url(<?php echo esc_url($item['background_image']['url']); ?>);">
                            <div class="container">
                                <div class="row align-items-center">
                                    <div class="col-lg-6 col-md-12">
                                        <div class="main-banner-content">
                                            <span class="sub-title"><?php echo esc_html( $item['slider_top_title'] ); ?></span>
                                            <<?php echo esc_attr( $settings['title_tag'] ); ?> data-shadow='<?php echo esc_html( $item['slider_title'] ); ?>'><?php echo esc_html( $item['slider_title'] ); ?> </<?php echo esc_attr( $settings['title_tag'] ); ?>>

                                            <p><?php echo wp_kses_post( $item['slider_content'] ); ?></p>

                                            <div class="btn-box">
                                                <?php if( $item['left_slider_button'] != '' ): ?>
                                                    <?php if( $item['left_slider_button_icon'] != '' ): ?>
                                                        <a href="<?php echo esc_url( $link ); ?>" class="default-btn">
                                                            <i class="<?php echo esc_attr( $item['left_slider_button_icon'] ); ?>"></i>
                                                            <?php echo esc_html( $item['left_slider_button'] ); ?>
                                                        </a>
                                                    <?php else: ?>
                                                        <a href="<?php echo esc_url( $link ); ?>" class="default-btn btn_without_icon">
                                                            <?php echo esc_html( $item['left_slider_button'] ); ?>
                                                        </a>
                                                    <?php endif; ?>
                                                <?php endif; ?>

                                                <?php if( $item['right_slider_button'] != '' ): ?>
                                                    <?php if( $item['right_slider_button_icon'] != '' ): ?>
                                                        <a href="<?php echo esc_url( $item['right_button_link']['url'] ); ?>" class="popup-youtube optional-btn">
                                                            <i class="<?php echo esc_attr( $item['right_slider_button_icon'] ); ?>"></i>
                                                            <?php echo esc_html( $item['right_slider_button'] ); ?>
                                                        </a>
                                                    <?php else: ?>
                                                        <a href="<?php echo esc_url( $item['right_button_link']['url'] ); ?>" class="popup-youtube optional-btn btn_without_icon">
                                                            <?php echo esc_html( $item['right_slider_button'] ); ?>
                                                        </a>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-lg-6 col-md-12">
                                        <?php if( $item['image']['url'] != '' ): ?>
                                            <div class="main-banner-image">
                                                <img src="<?php echo esc_url( $item['image']['url'] ); ?>" alt="<?php echo esc_attr( $item['slider_title'] ); ?>">
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>                
                </div>
            <?php endif;
        else :
            if ( $settings['slider_list'] ) : ?>
                <div class="home-slides-two owl-carousel owl-theme">
                    <?php foreach (  $settings['slider_list'] as $item ): ?>
                        <?php
                        // Get Button Link
                        if($item['link_type'] == 1):
                            $link = get_page_link($item['link_to_page']); 
                        else:
                            $link = $item['ex_link'];
                        endif;
                        ?>
                        <div class="main-banner banner-bg4" style="background-image:url(<?php echo esc_url($item['background_image']['url']); ?>);">
                            <div class="d-table">
                                <div class="d-table-cell">
                                    <div class="container">
                                        <div class="row align-items-center">
                                            <div class="col-lg-6 col-md-12">
                                                <div class="main-banner-content black-text">
                                                    <span class="sub-title"><?php echo esc_html( $item['slider_top_title'] ); ?></span>
                                                    <<?php echo esc_attr( $settings['title_tag'] ); ?> data-shadow='<?php echo esc_html( $item['slider_title'] ); ?>'><?php echo esc_html( $item['slider_title'] ); ?> </<?php echo esc_attr( $settings['title_tag'] ); ?>>

                                                    <div class="btn-box">
                                                        <?php if( $item['left_slider_button'] != '' ): ?>
                                                            <?php if( $item['left_slider_button_icon'] != '' ): ?>
                                                                <a href="<?php echo esc_url( $link ); ?>" class="default-btn">
                                                                    <i class="<?php echo esc_attr( $item['left_slider_button_icon'] ); ?>"></i>
                                                                    <?php echo esc_html( $item['left_slider_button'] ); ?>
                                                                </a>
                                                            <?php else: ?>
                                                                <a href="<?php echo esc_url( $link ); ?>" class="default-btn btn_without_icon">
                                                                    <?php echo esc_html( $item['left_slider_button'] ); ?>
                                                                </a>
                                                            <?php endif; ?>
                                                        <?php endif; ?>

                                                        <?php if( $item['right_slider_button'] != '' ): ?>
                                                            <?php if( $item['right_slider_button_icon'] != '' ): ?>
                                                                <a href="<?php echo esc_url( $item['right_button_link']['url'] ); ?>" class="popup-youtube optional-btn">
                                                                    <i class="<?php echo esc_attr( $item['right_slider_button_icon'] ); ?>"></i>
                                                                    <?php echo esc_html( $item['right_slider_button'] ); ?>
                                                                </a>
                                                            <?php else: ?>
                                                                <a href="<?php echo esc_url( $item['right_button_link']['url'] ); ?>" class="popup-youtube optional-btn btn_without_icon">
                                                                    <?php echo esc_html( $item['right_slider_button'] ); ?>
                                                                </a>
                                                            <?php endif; ?>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>  
                </div>
            <?php endif;
        endif;
	}

	protected function _content_template() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Doctrine_Banner_Slider );