<?php
/**
 * Covid19 Banner Three Widget
 */

namespace Elementor;
class Doctrine_BannerThree extends Widget_Base {

	public function get_name() {
        return 'Doctrine_BannerThree';
    }

	public function get_title() {
        return __( 'Banner Three', 'covid19-toolkit' );
    }

	public function get_icon() {
        return 'eicon-banner';
    }

	public function get_categories() {
        return [ 'covid19-elements' ];
    }

	protected function _register_controls() {

        $this->start_controls_section(
			'Doctrine_Banner',
			[
				'label' => __( 'Banner Content', 'covid19-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

			$this->add_control(
				'title',
				[
					'label' => __( 'Title', 'covid19-toolkit' ),
					'type' => Controls_Manager::TEXTAREA,
					'default' => esc_html__('COVID-19 Coronavirus Outbreak', 'covid19-toolkit'),
				]
            );
            $this->add_control(
                'title_tag',
                [
                    'label' => __( 'Title Tag', 'covid19-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1'         => __( 'h1', 'covid19-toolkit' ),
                        'h2'         => __( 'h2', 'covid19-toolkit' ),
                        'h3'         => __( 'h3', 'covid19-toolkit' ),
                        'h4'         => __( 'h4', 'covid19-toolkit' ),
                        'h5'         => __( 'h5', 'covid19-toolkit' ),
                        'h6'         => __( 'h6', 'covid19-toolkit' ),
                    ],
                    'default' => 'h1',
                ]
            );
			
			$this->add_control(
				'image',
				[
					'label' => __( 'Image', 'covid19-toolkit' ),
					'type' => Controls_Manager::MEDIA,
				]
			);
			$this->add_control(
				'background_image',
				[
					'label' => __( 'Background Image', 'covid19-toolkit' ),
					'type' => Controls_Manager::MEDIA,
				]
            );
               
            $card = new Repeater();
            $card->add_control(
                'title', 
                [
                    'label' => __( 'Title', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );
            $card->add_control(
                'icon', 
                [
                    'label' => __( 'Icon', 'covid19-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                    'label_block' => true,
                ]
            );
            $card->add_control(
                'count',
                [
                    'label' => __( 'Display Number By', 'covid19-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'cases'                 => __( 'Cases', 'covid19-toolkit' ),
                        'dead'                  => __( 'Deaths', 'covid19-toolkit' ),
                        'recovered'             => __( 'Recovered', 'covid19-toolkit' ),
                        'active'                => __( 'Active', 'covid19-toolkit' ),
                        'critical'              => __( 'Critical', 'covid19-toolkit' ),
                        'today-deaths'          => __( 'Deaths Today', 'covid19-toolkit' ),
                        'today-case'            => __( 'Cases Today', 'covid19-toolkit' ),
                        'affected-countries'    => __( 'Affected Countries', 'covid19-toolkit' ),
                    ],
                    'default' => 'cases',
                ]
            );
            $this->add_control(
                'cards',
                [
                    'label' => __( 'Add Card', 'covid19-toolkit' ),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $card->get_controls(),
                ]
            );
        $this->end_controls_section();

        $this->start_controls_section(
			'symptom_style',
			[
				'label' => __( 'Style', 'covid19-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'secbg_color',
                    'label' => __( 'Background', 'covid19-domain' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .hero-banner',
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => __( 'Title Typography', 'covid19-toolkit' ),
                    'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .hero-banner-content h1, .hero-banner-content h2, .hero-banner-content h3, .hero-banner-content h4, .hero-banner-content h5, .hero-banner-content h6',
                ]
            );
            
            $this->add_control(
                'title_color',
                [
                    'label' => __( 'Title Color', 'covid19-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .hero-banner-content h1, .hero-banner-content h2, .hero-banner-content h3, .hero-banner-content h4, .hero-banner-content h5, .hero-banner-content h6' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'number_typography',
                    'label' => __( 'Number Typography', 'covid19-toolkit' ),
                    'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .hero-banner-content .banner-box-list .single-banner-box h3',
                ]
            );
            
            $this->add_control(
                'number_color',
                [
                    'label' => __( 'Number Color', 'covid19-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .hero-banner-content .banner-box-list .single-banner-box h3' => 'color: {{VALUE}}',
                    ],
                ]
            );

        $this->end_controls_section();
    }

	protected function render() {

        $settings = $this->get_settings_for_display();	
        ?>
        <div class="hero-banner" style="background-image:url(<?php echo esc_url( $settings['background_image']['url'] ); ?>);">
            <div class="container">
                <div class="hero-banner-content">
                    <<?php echo esc_attr( $settings['title_tag'] ); ?>><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>

                    <div class="banner-box-list">
                        <div class="row">
                            <?php foreach( $settings['cards'] as $item ): ?>
                                <div class="col-lg-3 col-sm-6 col-md-6">
                                    <div class="single-banner-box">
                                        <div class="icon">
                                            <?php if( $item['icon']['url'] != '' ): ?>
                                                <img src="<?php echo esc_url( $item['icon']['url'] ); ?>" alt="<?php echo esc_attr( $item['title'] ); ?>">
                                            <?php endif; ?>
                                        </div>
                                        <h3 class="data-cls-<?php echo esc_attr( $item['count'] ); ?>"></h3>    
                                        <p><?php echo esc_html( $item['title'] ); ?></p>
                                    </div>
                                </div>
                            <?php endforeach; ?> 
                        </div>
                    </div>

                    <?php if( $settings['image']['url'] != '' ): ?>
                        <img src="<?php echo esc_url( $settings['image']['url'] ); ?>" alt="<?php echo esc_attr( $settings['title'] ); ?>">
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <?php
	}
	protected function _content_template() {}
}
Plugin::instance()->widgets_manager->register_widget_type( new Doctrine_BannerThree );