<?php
/**
 * Blog Post Widget
 */

namespace Elementor;
class Doctrine_Blog_Post extends Widget_Base {

	public function get_name() {
        return 'DoctrineBlogPost';
    }

	public function get_title() {
        return __( 'Blog Post', 'covid19-toolkit' );
    }

	public function get_icon() {
        return 'eicon-posts-grid';
    }

	public function get_categories() {
        return [ 'covid19-elements' ];
    }

	protected function _register_controls() {

        $this->start_controls_section(
			'blog_section',
			[
				'label' => __( 'Blog Post', 'covid19-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );
            $this->add_control(
                'style',
                [
                    'label' => __( 'Style', 'tryo-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        '1'         => __( 'Style One', 'tryo-toolkit' ),
                        '2'         => __( 'Style Two', 'tryo-toolkit' ),
                        '3'         => __( 'Style Three', 'tryo-toolkit' ),
                    ],
                    'default' => '1',
                ]
            );
            $this->add_control(
                'read_more',
                [
                    'label'     => __( 'Read More Text', 'covid19-toolkit' ),
                    'type'      => Controls_Manager::TEXT,
                    'default'   => __( 'Read More', 'covid19-toolkit' ),
                    'condition' => [
                        'style' => ['1','3'],
                    ],
                ]
            );
            $this->add_control(
                'cat_name',
                [
                    'label' => __( 'Select Category', 'covid19-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => covid19_toolkit_get_post_cat_list(),
                ]
            );

            $this->add_control(
                'order',
                [
                    'label' => __( 'Post Order By', 'covid19-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'DESC'      => __( 'DESC', 'covid19-toolkit' ),
                        'ASC'       => __( 'ASC', 'covid19-toolkit' ),
                    ],
                    'default' => 'DESC',
                ]
            );

            $this->add_control(
                'count',
                [
                    'label' => __( 'Post Per Page', 'covid19-toolkit' ),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 3,
                ]
            );
            $this->add_control(
                'meta_data',
                [
                    'label' => __( 'Display Meta Data', 'tryo-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'yes'         => __( 'Yes', 'tryo-toolkit' ),
                        'no'         => __( 'No', 'tryo-toolkit' ),
                    ],
                    'default' => 'yes',
                ]
            );

        $this->end_controls_section();

    }

	protected function render() { 
        $settings = $this->get_settings_for_display();

        if ($settings['cat_name'] != '') {
            $args = array(
                'orderby' => 'date', 
                'order' => $settings['order'], 
                'posts_per_page' => $settings['count'], 
                'ignore_sticky_posts' => 1, 
                'meta_key' => '_thumbnail_id', 
                'tax_query' => array( 
                    array( 
						'taxonomy' => 'category', 
						'field'    => 'slug',
                        'terms' => $settings['cat_name'], 
                    ) 
                )
            );
        }else{
            $args = array(
                'orderby' => 'date', 
                'order' => $settings['order'], 
                'posts_per_page' => $settings['count'], 
                'ignore_sticky_posts' => 1, 
                'meta_key' => '_thumbnail_id'
            );
        }
        $post_array = new \WP_Query( $args ); 
    
        ?>
            <?php if ( $settings['style'] == '1' ) : ?>
                <div class="container">
                    <div class="row">
                        <?php while($post_array->have_posts()): $post_array->the_post(); ?>  
                            <div class="col-lg-4 col-md-6">
                                <div class="single-spread-virus-box">
                                    <a href="<?php the_permalink(); ?>">
                                        <img src="<?php the_post_thumbnail_url( 'covid19_post_thumb_one' ); ?>" alt="<?php the_post_thumbnail_caption(); ?>">   
                                    </a>    
                                    <div class="caption">
                                        <?php if( $settings['meta_data'] == 'yes' ): ?>
                                            <div class="post-meta">
                                                <ul>
                                                    <li>
                                                        <i class='bx bx-user'></i>
                                                        <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ) ); ?>"><?php echo esc_html(get_the_author()); ?></a>
                                                    </li>
                                                    <li>
                                                        <i class='bx bx-calendar' ></i>
                                                        <?php echo esc_html(get_the_date()); ?>
                                                    </li>
                                                </ul>
                                            </div>
                                        <?php endif; ?>

                                        <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                                        <p><?php the_excerpt(); ?></p>

                                        <?php if( $settings['read_more'] != '' ): ?>
                                            <a href="<?php the_permalink(); ?>" class="read-more-btn"><?php echo esc_html( $settings['read_more'] ); ?></a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        <?php endwhile; ?>
                        <?php wp_reset_postdata(); ?>
                    </div>
                </div>
            <?php elseif ( $settings['style'] == '2' ) : ?>
                <div class="container blog-post-style-two">
                    <div class="row">
                        <div class="col-lg-6 col-md-12">
                            <?php $i = 1; while($post_array->have_posts()): $post_array->the_post(); ?> 
                                <?php if( $i < 2 ): ?>
                                    <div class="single-blog-post">
                                        <div class="post-image">
                                            <a href="<?php the_permalink(); ?>">
                                                <img src="<?php the_post_thumbnail_url( 'covid19_post_thumb_medium' ); ?>" alt="<?php the_post_thumbnail_caption(); ?>">
                                            </a>
                                        </div>

                                        <div class="post-content">
                                            <?php if( $settings['meta_data'] == 'yes' ): ?>
                                                <span class="date"><i class="flaticon-event"></i> <?php echo esc_html(get_the_date()); ?></span>
                                            <?php endif; ?>
                                            <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            <?php $i++; endwhile; ?>
                            <?php wp_reset_postdata(); ?>
                        </div>

                        <div class="col-lg-6 col-md-12">
                            <div class="small-blog-post">
                                <?php $count_i = 1; while($post_array->have_posts()): $post_array->the_post(); ?> 
                                    <?php if( $count_i != 1 ): ?>
                                        <div class="single-small-blog-post">
                                            <div class="d-flex align-items-center">
                                                <div class="post-image">
                                                    <a href="<?php the_permalink(); ?>">
                                                        <img src="<?php the_post_thumbnail_url( 'covid19_post_thumb_small' ); ?>" alt="<?php the_post_thumbnail_caption(); ?>">
                                                    </a>
                                                </div>
                
                                                <div class="post-content">
                                                    <?php if( $settings['meta_data'] == 'yes' ): ?>
                                                        <span class="date"><i class="flaticon-event"></i> <?php echo esc_html(get_the_date()); ?></span>
                                                    <?php endif; ?>
                                                    <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                <?php $count_i++; endwhile; ?>
                                <?php wp_reset_postdata(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php else : ?>
                <div class="container">
                    <div class="row">
                        <?php
                            $loop = 1;
                            while ( $post_array->have_posts() ): $post_array->the_post();
                            if ( $loop == 3 && $settings['count'] == 3 ) :
                                $colcls = "col-lg-4 col-md-6 offset-lg-0 offset-md-3";
                            else :
                                $colcls = "col-lg-4 col-md-6";
                            endif;
                        ?>
                            <div class="<?php echo esc_attr( $colcls ); ?>">
                                <div class="single-blog-post-item">
                                    <div class="post-image">
                                        <a href="<?php the_permalink(); ?>">
                                            <img src="<?php the_post_thumbnail_url( 'covid19_post_thumb_one' ); ?>" alt="<?php the_post_thumbnail_caption(); ?>">   
                                        </a>
                                        <?php if ( $settings['meta_data'] == 'yes' ) : ?>
                                            <div class="date">
                                                <span><?php echo esc_html(get_the_date()); ?></span>
                                            </div>
                                        <?php endif; ?>
                                    </div>

                                    <div class="post-content">
                                        <?php if ( $settings['meta_data'] == 'yes' ) : ?>
                                            <?php if ( get_the_tags() ) :
                                                $tags = get_the_tags();
                                                $count = 1;
                                                foreach ($tags as $tag ) : ?>
                                                    <span class="category"><?php echo esc_html($tag->name) ?></span>
                                                    <?php $count++; if ( $count == 2 ) :
                                                        break;
                                                    endif;
                                                endforeach; 
                                            endif; ?>
                                        <?php endif; ?>

                                        <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                                        <?php if( $settings['read_more'] != '' ): ?>
                                            <a href="<?php the_permalink(); ?>" class="details-btn"><?php echo esc_html( $settings['read_more'] ); ?></a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        <?php
                            $loop++;
                            endwhile;
                            wp_reset_query();
                        ?>
                    </div>
                </div>
            <?php endif; ?>
    <?php 
    } 

	protected function _content_template() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Doctrine_Blog_Post );