<?php
/**
 * Coming Soon Widget
 */

namespace Elementor;
class Doctrine_Coming_Soon extends Widget_Base {

	public function get_name() {
        return 'Doctrine_Coming_Soon';
    }

	public function get_title() {
        return __( 'Coming Soon', 'covid19-toolkit' );
    }

	public function get_icon() {
        return 'eicon-number-field';
    }

	public function get_categories() {
        return [ 'covid19-elements' ];
    }

	protected function _register_controls() {

        $this->start_controls_section(
			'Doctrine_Coming_Soon_Area',
			[
				'label' => __( 'Coming Soon Controls', 'covid19-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );
        

            $this->add_control(
                'due_date',
                [
                    'label' => __( 'Due Date', 'covid19-toolkit' ),
                    'type'  => Controls_Manager::DATE_TIME,
                ]
            );

            $this->add_control(
                'bg_image',
                [
                    'label' => __( 'Background Image', 'covid19-toolkit' ),
                    'type'  => Controls_Manager::MEDIA,
                ]
            );
		
			$this->add_control(
				'title',
				[
					'label' => __( 'Title', 'covid19-toolkit' ),
					'type' => Controls_Manager::TEXT,
					'default' => __('We Are Launching Soon', 'covid19-toolkit'),
				]
			);

            $this->add_control(
                'date', [
                    'label' => __( 'Day Text', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'Days' , 'covid19-toolkit' ),
                    'label_block' => true,
                ]
            );

            $this->add_control(
                'hours', [
                    'label' => __( 'Hours Text', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'Hours' , 'covid19-toolkit' ),
                    'label_block' => true,
                ]
            );

            $this->add_control(
                'minutes', [
                    'label' => __( 'Minutes Text', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'Minutes' , 'covid19-toolkit' ),
                    'label_block' => true,
                ]
            );

            $this->add_control(
                'seconds', [
                    'label' => __( 'Seconds Text', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'Seconds' , 'covid19-toolkit' ),
                    'label_block' => true,
                ]
            );
            
            $this->add_control(
                'placeholder_text', [
                    'label' => __( 'Placeholder Text', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'Enter your email' , 'covid19-toolkit' ),
                    'label_block' => true,
                ]
            );
    
            $this->add_control(
                'button_text', [
                    'label' => __( 'Button text', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'Subscribe' , 'covid19-toolkit' ),
                    'label_block' => true,
                ]
            );

            $this->add_control(
				'content',
				[
					'label' => __( 'Content', 'covid19-toolkit' ),
					'type' => Controls_Manager::TEXTAREA,
					'default' => __('If you would like to be notified when your app is live, Please subscribe to our mailing list', 'covid19-toolkit'),
				]
            );

        
        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();
		
        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $this-> add_inline_editing_attributes('content','none');

        global $covid19_opt;
        
        // Main site logo
        if( isset( $covid19_opt['covid19_main_logo']['url'] ) ):
            $covid19_logo 	= $covid19_opt['covid19_main_logo']['url'];
        else:
            $covid19_logo	= '';	
        endif;
		
		?>
        <div class="coming-soon-area" style="background-image:url(<?php echo esc_url( $settings['bg_image']['url'] ); ?>);">
            <div class="d-table">
                <div class="d-table-cell">
                    <div class="coming-soon-content">
                        <a class="logo" href="<?php echo esc_url( home_url( '/' ) ); ?>">
                            <?php if( $covid19_logo != '' ): ?>
                                <img src="<?php echo esc_url( $covid19_logo ); ?>" alt="<?php bloginfo( 'name' ); ?>">
                            <?php else: ?>
                                <h2><?php bloginfo( 'name' ); ?></h2>
                            <?php endif; ?>
                        </a>

						<h2><?php echo esc_html( $settings['title'] ); ?></h2>

                        <div id="timer" class="flex-wrap d-flex justify-content-center">
                            <div id="days" class="align-items-center flex-column d-flex justify-content-center"></div>
                            <div id="hours" class="align-items-center flex-column d-flex justify-content-center"></div>
                            <div id="minutes" class="align-items-center flex-column d-flex justify-content-center"></div>
                            <div id="seconds" class="align-items-center flex-column d-flex justify-content-center"></div>
                        </div>

                        <form class="newsletter-form" method="post" action="<?php echo home_url(); ?>/?na=s" onsubmit="return newsletter_check(this)">
                            <div class="form-group">
                                <input type="email" name="ne" class="input-newsletter" placeholder="<?php echo esc_attr( $settings['placeholder_text'] ); ?>" required autocomplete="off">
                                <span class="label-title"><i class='bx bx-envelope'></i></span>
                            </div>
                            
                            <?php if( $settings['button_text'] != '' ): ?>
                                <button type="submit" class="default-btn"><i class="flaticon-plane"></i> <?php echo esc_html( $settings['button_text'] ); ?></button>
                            <?php endif; ?>

							<p><?php echo esc_html( $settings['content'] ); ?></p>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <script>
            (function($){
            "use strict";
                $( window ).on( 'elementor/frontend/init', function() {
                    elementorFrontend.hooks.addAction( 'frontend/element_ready/Doctrine_Coming_Soon.default', function($scope, $){
                        // Count Time 
                        function makeTimer() {
                            var endTime = new Date("<?php echo $settings['due_date']; ?>");			
                            var endTime = (Date.parse(endTime)) / 1000;
                            var now = new Date();
                            var now = (Date.parse(now) / 1000);
                            var timeLeft = endTime - now;
                            var days = Math.floor(timeLeft / 86400); 
                            var hours = Math.floor((timeLeft - (days * 86400)) / 3600);
                            var minutes = Math.floor((timeLeft - (days * 86400) - (hours * 3600 )) / 60);
                            var seconds = Math.floor((timeLeft - (days * 86400) - (hours * 3600) - (minutes * 60)));
                            if (hours < "10") { hours = "0" + hours; }
                            if (minutes < "10") { minutes = "0" + minutes; }
                            if (seconds < "10") { seconds = "0" + seconds; }
                            $("#days").html(days + "<span><?php echo esc_html( $settings['date'] ); ?></span>");
                            $("#hours").html(hours + "<span><?php echo esc_html( $settings['hours'] ); ?></span>");
                            $("#minutes").html(minutes + "<span><?php echo esc_html( $settings['minutes'] ); ?></span>");
                            $("#seconds").html(seconds + "<span><?php echo esc_html( $settings['seconds'] ); ?></span>");
                        }
                        setInterval(function() { makeTimer(); }, 1000);
                        });

                });  

                if( typeof elementorFrontend !== 'undefined'  ){
                    elementorFrontend.hooks.addAction( 'frontend/element_ready/Doctrine_Coming_Soon.default', function($scope, $){
                        // Count Time 
                        function makeTimerLive() {
                            var endTime = new Date("<?php echo $settings['due_date']; ?>");			
                            var endTime = (Date.parse(endTime)) / 1000;
                            var now = new Date();
                            var now = (Date.parse(now) / 1000);
                            var timeLeft = endTime - now;
                            var days = Math.floor(timeLeft / 86400); 
                            var hours = Math.floor((timeLeft - (days * 86400)) / 3600);
                            var minutes = Math.floor((timeLeft - (days * 86400) - (hours * 3600 )) / 60);
                            var seconds = Math.floor((timeLeft - (days * 86400) - (hours * 3600) - (minutes * 60)));
                            if (hours < "10") { hours = "0" + hours; }
                            if (minutes < "10") { minutes = "0" + minutes; }
                            if (seconds < "10") { seconds = "0" + seconds; }
                            
                            $("#days").html(days + "<span><?php echo esc_html( $settings['date'] ); ?></span>");
                            $("#hours").html(hours + "<span><?php echo esc_html( $settings['hours'] ); ?></span>");
                            $("#minutes").html(minutes + "<span><?php echo esc_html( $settings['minutes'] ); ?></span>");
                            $("#seconds").html(seconds + "<span><?php echo esc_html( $settings['seconds'] ); ?></span>");
                        }
                        setInterval(function() { makeTimerLive(); }, 1000);
                    });
                }
            
            }(jQuery));
        </script>

        <?php
	}

	protected function _content_template() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Doctrine_Coming_Soon );