<?php
/**
 * Contact Area Widget
 */

namespace Elementor;
class Doctrine_Contact_Area extends Widget_Base {

	public function get_name() {
        return 'Doctrine_Contact_Area';
    }

	public function get_title() {
        return __( 'Contact Area', 'covid19-toolkit' );
    }

	public function get_icon() {
        return 'eicon-form-horizontal';
    }

	public function get_categories() {
        return [ 'covid19-elements' ];
    }

	protected function _register_controls() {

        $this->start_controls_section(
			'Doctrine_Contact_Area_Area',
			[
				'label' => __( 'Contact Area Controls', 'covid19-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

			$this->add_control(
				'title',
				[
					'label' => __( 'Title', 'covid19-toolkit' ),
					'type' => Controls_Manager::TEXT,
					'default' => __('Drop Us A Line', 'covid19-toolkit'),
				]
			);

			$this->add_control(
				'content',
				[
					'label' => __( 'Content', 'covid19-toolkit' ),
					'type' => Controls_Manager::TEXTAREA,
					'default' => __("We're happy to answer any questions you have or provide you with an estimate. Just send us a message in the form below with any questions you may have.", "covid19-toolkit"),
				]
			);

			$this->add_control(
				'shortcode',
				[
					'label' => __( 'Contact From 7 Shortcode', 'covid19-toolkit' ),
					'type' => Controls_Manager::TEXT,
				]
			);			

			$this->add_control(
				'right_title',
				[
					'label' => __( 'Right Side Title', 'covid19-toolkit' ),
					'type' => Controls_Manager::TEXT,
					'default' => __('Here to Help', 'covid19-toolkit'),
				]
			);
			$this->add_control(
				'right_content',
				[
					'label' => __( 'Right Side Content', 'covid19-toolkit' ),
					'type' => Controls_Manager::WYSIWYG,
					'default' => __('Have a question? You may find an answer in our FAQs. But you can also contact us.', 'covid19-toolkit'),
				]
            );
            
            $this->add_control(
				'social_link_title',
				[
					'label' => __( 'Social Title', 'covid19-toolkit' ),
					'type' => Controls_Manager::TEXT,
					'default' => __('Follow Us:', 'covid19-toolkit'),
				]
			);
		
        
        $this->end_controls_section();

        $this->start_controls_section(
			'banner_style',
			[
				'label' => __( 'Style', 'covid19-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);	

			$this->add_control(
				'title_color',
				[
					'label' => __( 'Title Color', 'covid19-toolkit' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .contact-form h3' => 'color: {{VALUE}}',
					],
				]
            );
            
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => __( 'Title Typography', 'covid19-toolkit' ),
                    'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .contact-form h3',
                ]
            );
			$this->add_control(
				'right_title_color',
				[
					'label' => __( 'Right Side Title Color', 'covid19-toolkit' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .contact-info h3' => 'color: {{VALUE}}',
					],
				]
            );
            
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'right_title_typography',
                    'label' => __( 'Right Side Title Typography', 'covid19-toolkit' ),
                    'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .contact-info h3',
                ]
            );
			
			
        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();
		
        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
		$this-> add_inline_editing_attributes('right_title','none');
		$this-> add_inline_editing_attributes('right_content','none');
		
		?>

        <div class="contact-area ptb-100">
            <div class="container">
                <div class="row">
                    <div class="col-lg-7 col-md-12">
                        <div class="contact-form">
                            <h3 <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></h3>

                            <p <?php echo $this-> get_render_attribute_string('content'); ?>><?php echo esc_html( $settings['content'] ); ?></p>

                            <?php echo do_shortcode( $settings['shortcode'] ); ?>
                        </div>
                    </div>

                    <div class="col-lg-5 col-md-12">
                        <div class="contact-info">

                            <h3 <?php echo $this-> get_render_attribute_string('right_title'); ?>><?php echo esc_html( $settings['right_title'] ); ?></h3>
                            <div  <?php echo $this-> get_render_attribute_string('right_content'); ?>><?php echo wp_kses_post( $settings['right_content'] ) ?></div>                   

                            <h3><?php echo esc_html( $settings['social_link_title'] ); ?></h3>
                            <ul class="social">
                                <?php covid19_social_link(); ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
	}

	protected function _content_template() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Doctrine_Contact_Area );