<?php
/**
 * Contact Card  Widget
 */

namespace Elementor;
class Doctrine_Contact_Card extends Widget_Base {

	public function get_name() {
        return 'Doctrine_Contact_Card';
    }

	public function get_title() {
        return __( 'Contact Box', 'covid19-toolkit' );
    }

	public function get_icon() {
        return 'eicon-call-to-action';
    }

	public function get_categories() {
        return [ 'covid19-elements' ];
    }

	protected function _register_controls() {

        $this->start_controls_section(
			'Doctrine_Contact_Card_Area',
			[
				'label' => __( 'Contact CTA Controls', 'covid19-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
			$this->add_control(
				'icon',
				[
					'label' => __( 'Icon', 'covid19-toolkit' ),
					'type' => Controls_Manager::ICON,
				]
			);

			$this->add_control(
				'title',
				[
					'label' => __( 'Title', 'covid19-toolkit' ),
					'type' => Controls_Manager::TEXT,
					'default' => __('Email Here', 'covid19-toolkit'),
				]
			);

			$this->add_control(
				'content',
				[
					'label' => __( 'Content', 'covid19-toolkit' ),
					'type' => Controls_Manager::WYSIWYG,
				]
			);
        
        $this->end_controls_section();

        $this->start_controls_section(
			'contact_cta__style',
			[
				'label' => __( 'Style', 'covid19-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

			$this->add_control(
				'title_color',
				[
					'label' => __( 'Title Color', 'covid19-toolkit' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .contact-cta-box h3' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_responsive_control(
				'title_size',
				[
					'label' => __( 'Title Font Size', 'covid19-toolkit' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px' ],
					'range' => [
						'px' => [
							'min' => 5,
							'max' => 70,
							'step' => 1,
						],
					],
					'devices' => [ 'desktop', 'tablet', 'mobile' ],
					'selectors' => [
						'{{WRAPPER}} .contact-info-box h3' => 'font-size: {{SIZE}}px;',
					],
				]
			);

        $this->end_controls_section();

    }

	protected function render() {

		$settings = $this->get_settings_for_display();
		
        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
		$this-> add_inline_editing_attributes('content','none');
	
        ?>
		<div class="contact-info-box">
			<div class="icon">
				<i class="<?php echo esc_attr( $settings['icon'] ); ?>"></i>
			</div>

			<h3 <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></h3>
			<div <?php echo $this-> get_render_attribute_string('content'); ?>><?php echo $settings['content']; ?></div>
		</div>
        <?php
	}

	protected function _content_template() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Doctrine_Contact_Card );