<?php
/**
 * CTA Widget
 */

namespace Elementor;
class Doctrine_CTA extends Widget_Base {

	public function get_name() {
        return 'CTA';
    }

	public function get_title() {
        return __( 'CTA Two Area', 'covid19-toolkit' );
    }

	public function get_icon() {
        return 'eicon-call-to-action';
    }

	public function get_categories() {
        return [ 'covid19-elements' ];
    }

	protected function _register_controls() {

        $this->start_controls_section(
			'Doctrine_CTA',
			[
				'label' => __( 'Doctrine CTA', 'covid19-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );        
            $this->add_control(
                'title',
                [
                    'label' => __( 'Title', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __('We operate 24h a day - every day!', 'covid19-toolkit'),
                ]
            );

            $this->add_control(
                'bottom_title',
                [
                    'label' => __( 'Bottom Title', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __('Call us if you have any problems.', 'covid19-toolkit'),
                ]
            );

            $this->add_control(
                'section_bg',
                [
                    'label' => __( 'Background Image', 'covid19-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                ]
            );

            $this->add_control(
                'image',
                [
                    'label' => __( 'Image', 'covid19-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                ]
            );

            $this->add_control(
                'title_tag',
                [
                    'label' => __( 'Title Tag', 'holab-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1'         => __( 'h1', 'holab-toolkit' ),
                        'h2'         => __( 'h2', 'holab-toolkit' ),
                        'h3'         => __( 'h3', 'holab-toolkit' ),
                        'h4'         => __( 'h4', 'holab-toolkit' ),
                        'h5'         => __( 'h5', 'holab-toolkit' ),
                        'h5'         => __( 'h6', 'holab-toolkit' ),
                    ],
                    'default' => 'h3',
                ]
            );
            $this->add_control(
                'button_top_text',
                [
                    'label' => __( 'Button Top Text', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __('Emergency Contact', 'covid19-toolkit'),
                ]
            );            
            $this->add_control(
				'button_icon',
				[
					'label' => __( 'Button Icon Class', 'covid19-toolkit' ),
					'type' => Controls_Manager::TEXT,
                    'default' => __('flaticon-call', 'covid19-toolkit'),
                    'description' => __('e.g flaticon-call. You can use Font-Awesome/Boxicons', 'covid19-toolkit'),
				]
			);
            $this->add_control(
                'button_text',
                [
                    'label' => __( 'Button Text', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __('+44 587 154756', 'covid19-toolkit'),
                ]
            );
            $this->add_control(
                'button_link',
                [
                    'label' => __( 'Button Link', 'covid19-toolkit' ),
                    'type' => Controls_Manager::URL,
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'section_style',
			[
				'label' => __( 'Style', 'covid19-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

            $this->add_control(
                'section_background_color',
                [
                    'label' => __( 'Section Background Color', 'covid19-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .cta-inner-area' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
        
            $this->add_control(
                'title_color',
                [
                    'label' => __( 'Title Color', 'covid19-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .cta-inner-area h1, .cta-inner-area h2, .cta-inner-area h3, .cta-inner-area h4, .cta-inner-area h5, .cta-inner-area h6' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'title_typography',
					'label' => __( 'Title Typography', 'covid19-toolkit' ),
					'scheme' => Scheme_Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .cta-inner-area h1, .cta-inner-area h2, .cta-inner-area h3, .cta-inner-area h4, .cta-inner-area h5, .cta-inner-area h6',
				]
            );
            
            $this->add_control(
                'bottom_title_color',
                [
                    'label' => __( 'Bottom Title Color', 'covid19-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .cta-inner-area p' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'bottom_title_typography',
					'label' => __( 'Bottom Title Typography', 'covid19-toolkit' ),
					'scheme' => Scheme_Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .cta-inner-area p',
				]
            );
            
            $this->add_control(
                'button_top_text_color',
                [
                    'label' => __( 'Button Top Text Color', 'covid19-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .cta-inner-area .cta-btn a span' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'button_top_typography',
					'label' => __( 'Button Top Text Typography', 'covid19-toolkit' ),
					'scheme' => Scheme_Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .cta-inner-area .cta-btn a span',
				]
            );
            
            $this->add_control(
                'button_text_color',
                [
                    'label' => __( 'Button Text Color', 'covid19-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .cta-inner-area .cta-btn a' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'button_typography',
					'label' => __( 'Button Text Typography', 'covid19-toolkit' ),
					'scheme' => Scheme_Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .cta-inner-area .cta-btn a',
				]
			);

        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');

        $target = $settings['button_link']['is_external'] ? ' target="_blank"' : '';
        ?>

        <div class="cta-area">
            <div class="container">
                <div class="cta-inner-area" style="background-image:url(<?php echo esc_url( $settings['section_bg']['url'] ); ?>);">
                    <div class="row align-items-center">
                        <div class="col-lg-8 col-md-12">
                            <div class="row align-items-center">
                                <div class="col-lg-5 col-md-5">
                                    <?php if( $settings['image']['url'] != '' ):?>
                                        <img src="<?php echo esc_url( $settings['image']['url'] ); ?>" alt="<?php echo esc_attr( $settings['title'] ); ?>">
                                    <?php endif; ?>
                                </div>

                                <div class="col-lg-7 col-md-7">
                                    <<?php echo esc_attr( $settings['title_tag'] ); ?>><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>
                                    <p><?php echo esc_html( $settings['bottom_title'] ); ?></p>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-4 col-md-12">
                            <div class="cta-btn">
                                <?php if( $settings['button_text'] != '' ): ?>
                                    <a href="<?php echo esc_url( $settings['button_link']['url'] ); ?>">
                                        <i class="<?php  echo esc_attr( $settings['button_icon'] ); ?>"></i>
                                        <span><?php echo esc_html( $settings['button_top_text'] ); ?></span>
                                        <?php echo esc_html( $settings['button_text'] ); ?>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
	}

	protected function _content_template() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Doctrine_CTA );