<?php
/**
 * CTA2 Widget
 */

namespace Elementor;
class Doctrine_CTA2 extends Widget_Base {

	public function get_name() {
        return 'CTA2';
    }

	public function get_title() {
        return __( 'CTA Two Area', 'covid19-toolkit' );
    }

	public function get_icon() {
        return 'eicon-call-to-action';
    }

	public function get_categories() {
        return [ 'covid19-elements' ];
    }

	protected function _register_controls() {

        $this->start_controls_section(
			'Doctrine_CTA2',
			[
				'label' => __( 'Doctrine CTA Two', 'covid19-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );   
        
            $this->add_control(
                'left_slider_button', 
                [
                    'label' => __( 'Left Button Text', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'left_slider_button_icon', 
                [
                    'label' => __( 'Left Button Icon Class Name', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                    'placeholder' => __( 'flaticon-open-book', 'covid19-toolkit' ),
                ]
            );
            $this->add_control(
                'link_type',
                [
                    'label' => esc_html__( 'Left Button Link Type', 'covid19-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options' => [
                        '1'     => esc_html__( 'Link To Page', 'covid19-toolkit' ),
                        '2'     => esc_html__( 'External Link', 'covid19-toolkit' ),
                    ], 
                ]
            );
            
            $this->add_control(
                'link_to_page',
                [
                    'label' => esc_html__( 'Left Button Link Page', 'covid19-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options' => covid19_toolkit_get_page_as_list(),
                    'condition' => [
                        'link_type' => '1',
                    ]
                ]
            );
            
            $this->add_control(
                'ex_link',
                [
                    'label'=>esc_html__('Left Button External Link', 'covid19-toolkit'),
                    'type'=>Controls_Manager:: TEXT,
                    'condition' => [
                        'link_type' => '2',
                    ]
                ]
            );
            $this->add_control(
                'right_slider_button_icon', 
                [
                    'label' => __( 'Right Button Icon Class Name', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                    'placeholder' => __( 'flaticon-play-button', 'covid19-toolkit' ),
                ]
            );
            $this->add_control(
                'right_slider_button', 
                [
                    'label' => __( 'Right Button Text', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'right_link_type',
                [
                    'label' => esc_html__( 'Right Button Link Type', 'covid19-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options' => [
                        '1'     => esc_html__( 'Link To Page', 'covid19-toolkit' ),
                        '2'     => esc_html__( 'External Link', 'covid19-toolkit' ),
                    ], 
                ]
            );
            
            $this->add_control(
                'right_link_to_page',
                [
                    'label' => esc_html__( 'Right Button Link Page', 'covid19-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options' => covid19_toolkit_get_page_as_list(),
                    'condition' => [
                        'right_link_type' => '1',
                    ]
                ]
            );
            
            $this->add_control(
                'right_ex_link',
                [
                    'label'=>esc_html__('Right Button External Link', 'covid19-toolkit'),
                    'type'=>Controls_Manager:: TEXT,
                    'condition' => [
                        'right_link_type' => '2',
                    ]
                ]
            );       

            $this->add_control(
                'section_bg',
                [
                    'label' => __( 'Background Image', 'covid19-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                ]
            );

            $this->add_control(
                'button_top_text',
                [
                    'label' => __( 'Button Top Text', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __('Emergency Contact', 'covid19-toolkit'),
                ]
            );            
            $this->add_control(
				'button_icon',
				[
					'label' => __( 'Button Icon Class', 'covid19-toolkit' ),
					'type' => Controls_Manager::TEXT,
                    'default' => __('flaticon-call', 'covid19-toolkit'),
                    'description' => __('e.g flaticon-call. You can use Font-Awesome/Boxicons', 'covid19-toolkit'),
				]
			);
            $this->add_control(
                'button_text',
                [
                    'label' => __( 'Button Text', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __('+44 587 154756', 'covid19-toolkit'),
                ]
            );
            $this->add_control(
                'button_link',
                [
                    'label' => __( 'Button Link', 'covid19-toolkit' ),
                    'type' => Controls_Manager::URL,
                ]
            );

        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        // Get Left Button Link
        if($settings['link_type'] == 1){
            $link = get_page_link($settings['link_to_page']); 
        } else {
            $link = $settings['ex_link'];
        }

        // Get Right Button Link
        if($settings['right_link_type'] == 1){
            $right_link = get_page_link($settings['right_link_to_page']); 
        } else {
            $right_link = $settings['right_ex_link'];
        }
        

        ?>

        <div class="emergency-contact-area">
            <div class="container">
                <div class="emergency-contact-inner" style="background-image:url(<?php echo esc_url( $settings['section_bg']['url'] ); ?>);">
                    <div class="row align-items-center">
                        <div class="col-lg-8 col-md-12">
                            <div class="btn-box">
                                <?php if( $settings['left_slider_button'] != '' ): ?>
                                    <?php if( $settings['left_slider_button_icon'] != '' ): ?>
                                        <a href="<?php echo esc_url( $link ); ?>" class="default-btn">
                                            <i class="<?php echo esc_attr( $settings['left_slider_button_icon'] ); ?>"></i>
                                            <?php echo esc_html( $settings['left_slider_button'] ); ?>
                                        </a>
                                    <?php else: ?>
                                        <a href="<?php echo esc_url( $settings['left_button_link']['url'] ); ?>" class="default-btn btn_without_icon">
                                            <?php echo esc_html( $settings['left_slider_button'] ); ?>
                                        </a>
                                    <?php endif; ?>
                                <?php endif; ?>

                                <?php if( $settings['right_slider_button'] != '' ): ?>
                                    <?php if( $settings['right_slider_button_icon'] != '' ): ?>
                                        <a href="<?php echo esc_url( $right_link ); ?>" class="default-btn">
                                            <i class="<?php echo esc_attr( $settings['right_slider_button_icon'] ); ?>"></i>
                                            <?php echo esc_html( $settings['right_slider_button'] ); ?>
                                        </a>
                                    <?php else: ?>
                                        <a href="<?php echo esc_url( $settings['right_button_link']['url'] ); ?>" class="default-btn btn_without_icon">
                                            <?php echo esc_html( $settings['right_slider_button'] ); ?>
                                        </a>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="col-lg-4 col-md-12">
                            <div class="contact-cta">
                                <?php if( $settings['button_text'] != '' ): ?>
                                    <a href="<?php echo esc_url( $settings['button_link']['url'] ); ?>">
                                        <i class="<?php  echo esc_attr( $settings['button_icon'] ); ?>"></i>
                                        <span><?php echo esc_html( $settings['button_top_text'] ); ?></span>
                                        <?php echo esc_html( $settings['button_text'] ); ?>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
	}

	protected function _content_template() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Doctrine_CTA2 );