<?php
/**
 * Doctor Widget
 */

namespace Elementor;
class Doctrine_Doctor extends Widget_Base {

	public function get_name() {
        return 'Doctrine_Doctor';
    }

	public function get_title() {
        return __( 'Doctors', 'covid19-toolkit' );
    }

	public function get_icon() {
        return 'fa fa-users';
    }

	public function get_categories() {
        return [ 'covid19-elements' ];
	}
	protected function _register_controls() {

        $this->start_controls_section(
			'Doctrine_Doctor',
			[
				'label' => __( 'Doctrine Doctor', 'covid19-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

			$this->add_control(
				'count',
				[
					'label' => __( 'How Much Doctors Display', 'covid19-toolkit' ),
					'type' => Controls_Manager::TEXT,
					'default' => __('3', 'covid19-toolkit'),
				]
			);
			$this->add_control(
				'order',
				[
					'label' => __( 'Doctors Order By', 'edali-toolkit' ),
					'type' => Controls_Manager::SELECT,
					'options' => [
						'DESC'      => __( 'DESC', 'edali-toolkit' ),
						'ASC'       => __( 'ASC', 'edali-toolkit' ),
					],
					'default' => 'DESC',
				]
			);

        $this->end_controls_section();

        $this->start_controls_section(
			'doctor_style',
			[
				'label' => __( 'Style', 'covid19-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		

		$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'title_typography',
					'label' => __( 'Name Typography', 'covid19-toolkit' ),
					'scheme' => Scheme_Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .single-doctors-box .content h1, .single-doctors-box .content h2, .single-doctors-box .content h3, .single-doctors-box .content h4, .single-doctors-box .content h5, .single-doctors-box .content h6',
				]
			);
			
			$this->add_control(
				'title_color',
				[
					'label' => __( 'Title Color', 'covid19-toolkit' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .single-doctors-box .content h1, .single-doctors-box .content h2, .single-doctors-box .content h3, .single-doctors-box .content h4, .single-doctors-box .content h5, .single-doctors-box .content h6' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'designation_typography',
					'label' => __( 'Designation Typography', 'covid19-toolkit' ),
					'scheme' => Scheme_Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .single-doctors-box .content span',
				]
			);
			
			$this->add_control(
				'designation_color',
				[
					'label' => __( 'Designation Color', 'covid19-toolkit' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .single-doctors-box .content span' => 'color: {{VALUE}}',
					],
				]
			);

        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display();

		// Post Query
 
		$args = array(
			'post_type'         => 'doctor',
			'posts_per_page'    => $settings['count'],
			'order'             => $settings['order'],
			'meta_key'          => '_thumbnail_id',
		);
        $post_array = new \WP_Query( $args );
        
		?>
		<div class="container">
			<div class="row">
				<?php while( $post_array->have_posts() ): $post_array->the_post(); ?>
					<?php $designation  = get_field('designation'); ?>
					<div class="col-lg-4 col-sm-6 col-md-6">
						<div class="single-doctors-box">
							<div class="image">	
								<a href="<?php the_permalink(); ?>">							
									<img src="<?php the_post_thumbnail_url( 'covid19_doctor_thumb' ); ?>" alt="<?php the_post_thumbnail_caption(); ?>">  
								</a>

								<?php if( have_rows('doctor_social_links') ): ?>
									<ul class="social">
										<?php  while ( have_rows('doctor_social_links') ) : the_row(); ?>
											<li><a href="<?php esc_url(the_sub_field('link')); ?>" target="_blank"><i class='<?php the_sub_field('doctor_select_icon'); ?>'></i></a></li>
										<?php endwhile; ?>
									</ul>
								<?php endif; ?>
							</div>

							<div class="content">
								<a href="<?php the_permalink(); ?>">	
									<h3><?php the_title(); ?></h3>
								</a>
								<span><?php echo esc_html( $designation ) ?></span>
							</div>
						</div>
					</div>
                <?php endwhile; ?>
                <?php wp_reset_query(); ?>
			</div>
		</div>
        <?php
	}

	protected function _content_template() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Doctrine_Doctor );