<?php
/**
 * Covid19 FAQ Video Widget
 */

namespace Elementor;
class Doctrine_FAQ_Video extends Widget_Base {

	public function get_name() {
        return 'Doctrine_FAQ_Video';
    }

	public function get_title() {
        return __( 'FAQ Video', 'covid19-toolkit' );
    }

	public function get_icon() {
        return 'eicon-accordion';
    }

	public function get_categories() {
        return [ 'covid19-elements' ];
    }

	protected function _register_controls() {

        $this->start_controls_section(
			'Doctrine_FAQ_Video',
			[
				'label' => __( 'FAQ Video', 'covid19-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

            $this->add_control(
                'image',
                [
                    'label' => __( 'Image', 'covid19-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                ]
            );

            $this->add_control(
                'video_link',
                [
                    'label' => __( 'Popup Video Link(YouTube)', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                ]
            );

			$this->add_control(
				'shape_image_one',
				[
					'label' => __( 'Shape Image One', 'covid19-toolkit' ),
					'type' => Controls_Manager::MEDIA,
				]
			);
			$this->add_control(
				'shape_image_two',
				[
					'label' => __( 'Shape Image Two', 'covid19-toolkit' ),
					'type' => Controls_Manager::MEDIA,
				]
			);
        $this->end_controls_section();
    }

	protected function render() {

        $settings = $this->get_settings_for_display();	
        ?>

        <div class="container">
            <div class="faq-img">
                <?php if( $settings['image']['url'] != '' ): ?>
                    <img src="<?php echo esc_url( $settings['image']['url'] ); ?>" alt="<?php echo esc_attr__( 'Video Image', 'covid19-toolkit' ); ?>">
                <?php endif; ?>

                <?php if($settings['video_link'] != '' ): ?>
                    <a href="<?php echo esc_url( $settings['video_link'] ); ?>" class="video-btn popup-youtube"><i class="flaticon-play-button"></i></a>
                <?php endif; ?>
            </div>
        </div>
        <?php
	}
	protected function _content_template() {}
}
Plugin::instance()->widgets_manager->register_widget_type( new Doctrine_FAQ_Video );