<?php
/**
 * Covid19 FAQ Widget
 */

namespace Elementor;
class Doctrine_FAQ extends Widget_Base {

	public function get_name() {
        return 'Doctrine_FAQ';
    }

	public function get_title() {
        return __( 'FAQ Style One', 'covid19-toolkit' );
    }

	public function get_icon() {
        return 'eicon-accordion';
    }

	public function get_categories() {
        return [ 'covid19-elements' ];
    }

	protected function _register_controls() {

        $this->start_controls_section(
			'Doctrine_FAQ',
			[
				'label' => __( 'FAQ', 'covid19-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

            $this->add_control(
                'image',
                [
                    'label' => __( 'Image', 'covid19-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                ]
            );

            $this->add_control(
                'video_link',
                [
                    'label' => __( 'Popup Video Link(YouTube)', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                ]
            );

			$this->add_control(
				'shape_image_one',
				[
					'label' => __( 'Shape Image One', 'covid19-toolkit' ),
					'type' => Controls_Manager::MEDIA,
				]
			);
			$this->add_control(
				'shape_image_two',
				[
					'label' => __( 'Shape Image Two', 'covid19-toolkit' ),
					'type' => Controls_Manager::MEDIA,
				]
			);
			               
            $item = new Repeater();

            $item->add_control(
                'title', 
                [
                    'label' => __( 'Title', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );
            $item->add_control(
                'content', 
                [
                    'label' => __( 'Content', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXTAREA,
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'items',
                [
                    'label' => __( 'Add Item', 'covid19-toolkit' ),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $item->get_controls(),
                    'default' => [
                        [
                            'title'     => __( 'What is the source of the virus?', 'covid19-toolkit' ),
                            'content'   => __( 'Coronaviruses are a large family of viruses. Some cause illness in people, and others, such as canine and feline coronaviruses, only infect animals. Rarely, animal coronaviruses that infect animals have emerged to infect people and can spread between people.', 'covid19-toolkit' ),
                        ],
                    ],
                    'title_field' => '{{{ title }}}',
                ]
            );
        $this->end_controls_section();

        $this->start_controls_section(
			'prevention_style',
			[
				'label' => __( 'Style', 'covid19-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => __( 'Title Typography', 'covid19-toolkit' ),
                    'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .faq-accordion .accordion .accordion-title',
                ]
            );
            
            $this->add_control(
                'title_color',
                [
                    'label' => __( 'Title Color', 'covid19-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .faq-accordion .accordion .accordion-title' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'content_typography',
                    'label' => __( 'Content Typography', 'covid19-toolkit' ),
                    'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .faq-accordion .accordion .accordion-content',
                ]
            );
            
            $this->add_control(
                'content_color',
                [
                    'label' => __( 'Content Color', 'covid19-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .faq-accordion .accordion .accordion-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );

        $this->end_controls_section();
    }

	protected function render() {

        $settings = $this->get_settings_for_display();	
        ?>

        <div class="container">
            <div class="row">
                <div class="col-lg-6 col-md-12">
                    <div class="faq-image faq-bg1" style="background-image:url(<?php echo esc_url( $settings['image']['url'] ); ?>);">
                        <?php if( $settings['image']['url'] != '' ): ?>
                            <img src="<?php echo esc_url( $settings['image']['url'] ); ?>" alt="<?php echo esc_attr__( 'Video Image', 'covid19-toolkit' ); ?>">
                        <?php endif; ?>

                        <?php if($settings['video_link'] != '' ): ?>
                            <a href="<?php echo esc_url( $settings['video_link'] ); ?>" class="video-btn popup-youtube"><i class="flaticon-play-button"></i></a>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="col-lg-6 col-md-12">
                    <div class="faq-accordion">
                        <ul class="accordion">
                            <?php $i = 0; foreach( $settings['items'] as $item ): ?>
                                <li class="accordion-item">
                                    <a class="accordion-title <?php if( $i == 0 ): echo 'active'; endif; ?>" href="javascript:void(0)">
                                        <i class="flaticon-add"></i>
                                        <?php echo esc_html( $item['title'] ); ?>
                                    </a>

                                    <div class="accordion-content <?php if( $i == 0 ): echo 'show'; endif; ?>">
                                        <p><?php echo esc_html( $item['content'] ); ?></p>
                                    </div>
                                </li>
                            <?php $i++; endforeach; ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <?php if( $settings['shape_image_one']['url'] != '' ): ?>
            <div class="faq-shape1"><img src="<?php echo esc_url( $settings['shape_image_one']['url'] ); ?>" alt="<?php echo esc_attr__( 'Shape Image', 'covid19-toolkit' ); ?>"></div>
        <?php endif; ?>

        <?php if( $settings['shape_image_two']['url'] != '' ): ?>
            <div class="faq-shape2"><img src="<?php echo esc_url( $settings['shape_image_two']['url'] ); ?>" alt="<?php echo esc_attr__( 'Shape Image', 'covid19-toolkit' ); ?>"></div>
        <?php endif; ?>
        <?php
	}
	protected function _content_template() {}
}
Plugin::instance()->widgets_manager->register_widget_type( new Doctrine_FAQ );