<?php
/**
 * FAQ Widget
 */

namespace Elementor;
class Doctrine_Faq_Two extends Widget_Base {

	public function get_name() {
        return 'FAQTwo';
    }

	public function get_title() {
        return __( 'FAQ Style Two', 'covid19-toolkit' );
    }

	public function get_icon() {
        return 'eicon-help-o';
    }

	public function get_categories() {
        return [ 'covid19-elements' ];
    }

	protected function _register_controls() {

        $this->start_controls_section(
			'Doctrine_Faq_Two',
			[
				'label' => __( 'Faq Control', 'covid19-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

		$this->add_control(
            'faq_tabs',
            [
                'label' => esc_html__('Faq Tabs', 'covid19-toolkit'),
                'type' => Controls_Manager::REPEATER,
                'separator' => 'before',
                'fields' => [
					[	
						'name'	=> 'tab_title',
						'label' => __( 'Tab Title', 'covid19-toolkit' ),
						'type' => Controls_Manager::TEXT,
						'default' => __( 'Getting Started', 'covid19-toolkit' ),
					],

                    [
                        'name'  => 'icon_type',
                        'label' => esc_html__( 'Icon Type', 'covid19-toolkit' ),
                        'type' => Controls_Manager::SELECT,
                        'label_block' => true,
                        'options' => [
                            '1'  => esc_html__( 'Default Icon', 'covid19-toolkit' ),
                            '2' => esc_html__( 'Font-Awesome Icon', 'covid19-toolkit' ),
                            '3' => esc_html__( 'Font Class Name', 'covid19-toolkit' ),
                        ],
                    ],
            
                    [
                        'name'  => 'default_icon',
                        'label' => esc_html__( 'Select Icon', 'covid19-toolkit' ),
                        'type' => Controls_Manager::SELECT,
                        'label_block' => true,
                        'options' => [
                            'bx bx-info-circle'         => esc_html__( 'Info Circle', 'covid19-toolkit' ),
                            'bx bx-book-open'           => esc_html__( 'Book Open', 'covid19-toolkit' ),
                            'bx bx-shopping-bag'        => esc_html__( 'Shopping', 'covid19-toolkit' ),
                            'bx bxs-badge-dollar'       => esc_html__( 'Dollar', 'covid19-toolkit' ),
                            'bx bx-code-alt'            => esc_html__( 'Code', 'covid19-toolkit' ),
                            'bx bx-flag'                => esc_html__( 'Flag', 'covid19-toolkit' ),
                            'bx bx-camera'              => esc_html__( 'Camera', 'covid19-toolkit' ),
                            'bx bx-layer'               => esc_html__( 'Layer', 'covid19-toolkit' ),
                            'bx bxs-flag-checkered'     => esc_html__( 'Flag Checkered', 'covid19-toolkit' ),
                            'bx bx-health'              => esc_html__( 'Star', 'covid19-toolkit' ),
                            'bx bx-line-chart'          => esc_html__( 'LLine Chart', 'covid19-toolkit' ),
                            'bx bx-book-reader'         => esc_html__( 'Book Reader', 'covid19-toolkit' ),
                            'bx bx-target-lock'         => esc_html__( 'Target Lock', 'covid19-toolkit' ),
                            'bx bxs-thermometer'        => esc_html__( 'Thermometer', 'covid19-toolkit' ),
                            'bx bx-shape-triangle'      => esc_html__( 'Triangle', 'covid19-toolkit' ),
                            'bx bx-font-family'         => esc_html__( 'Font Family', 'covid19-toolkit' ),
                            'bx bxs-drink'              => esc_html__( 'Drink', 'covid19-toolkit' ),
                            'bx bx-first-aid'           => esc_html__( 'First Aid', 'covid19-toolkit' ),
                            'bx bx-bar-chart-alt-2'     => esc_html__( 'Chart', 'covid19-toolkit' ),
                            'bx bx-briefcase-alt-2'     => esc_html__( 'Briefcase', 'covid19-toolkit' ),
                            'bx bx-book-reader'         => esc_html__( 'Book Reader', 'covid19-toolkit' ),
                            'bx bx-target-lock'         => esc_html__( 'Target Lock', 'covid19-toolkit' ),
                        ],
                        'condition' => [
                            'icon_type' => '1',
                        ]
                    ],
                    [
                        'name'  => 'fa_icon',
                        'label'=>esc_html__('Font-Awesome Icon', 'covid19-toolkit'),
                        'type'=>Controls_Manager:: ICON,
                        'condition' => [
                            'icon_type' => '2',
                        ]
                    ],
                    [
                        'name'  => 'custom_icon',
                        'label' => esc_html__('Icon Class Name', 'covid19-toolkit'),
                        'type'  => Controls_Manager:: TEXT,
                        'condition' => [
                            'icon_type' => '3',
                        ]
                    ],
                    [
                        'name'  => 'faqs',
                        'label'=>esc_html__('Faq Items(user * to add faq item)', 'covid19-toolkit'),
                        'type'=>Controls_Manager:: TEXTAREA,
                    ],
                ],
            ]
        );
       
        $this->end_controls_section();

        $this->start_controls_section(
			'partner_style',
			[
				'label' => __( 'Style', 'covid19-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

            $this->add_responsive_control(
                'tab_title_size',
                [
                    'label' => __( 'Tab Title Font Size', 'covid19-toolkit' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 5,
                            'max' => 70,
                            'step' => 1,
                        ],
                    ],
                    'devices' => [ 'desktop', 'tablet', 'mobile' ],
                    'selectors' => [
                        '{{WRAPPER}} .faq-accordion-tab .tabs li a span' => 'font-size: {{SIZE}}px;',
                    ],
                ]
            );

            $this->add_responsive_control(
                'faq_title_size',
                [
                    'label' => __( 'Faq Title Font Size', 'covid19-toolkit' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 1,
                            'max' => 70,
                            'step' => 1,
                        ],
                    ],
                    'devices' => [ 'desktop', 'tablet', 'mobile' ],
                    'selectors' => [
                        '{{WRAPPER}} .faq-accordion-content .accordion .accordion-title' => 'font-size: {{SIZE}}px;',
                    ],
                ]
            );
            $this->add_responsive_control(
                'faq_content_size',
                [
                    'label' => __( 'Faq Content Font Size', 'covid19-toolkit' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 5,
                            'max' => 70,
                            'step' => 1,
                        ],
                    ],
                    'devices' => [ 'desktop', 'tablet', 'mobile' ],
                    'selectors' => [
                        '{{WRAPPER}} .faq-accordion-content .accordion .accordion-title' => 'font-size: {{SIZE}}px;',
                    ],
                ]
            );
        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display();
        ?>

        <div class="container">
            <div class="tab faq-accordion-tab">
                <!-- <ul class="tabs d-flex flex-wrap justify-content-center">
                    <?php foreach( $settings['faq_tabs'] as $item ): ?>
                        <?php
                            // Icon
                            $icon = '';
                            if( $item['icon_type'] == 1 ){
                                $icon =$item['default_icon']; 
                            } elseif( $item['icon_type'] == 2 ) {
                                $icon = $item['fa_icon'];
                            } elseif( $item['icon_type'] == 3 ) {
                                $icon = $item['custom_icon'];
                            } 
                        ?>
                        <li><a href="#"><i class='<?php echo esc_attr( $icon ); ?>'></i> <span><?php echo esc_html( $item['tab_title'] ); ?></span></a></li>
                    <?php endforeach; ?>
                </ul>

                <div class="tab-content">
                    <?php foreach( $settings['faq_tabs'] as $item ): ?>
                        <div class="tabs-item">
                            <div class="faq-accordion-content">
                                <ul class="accordion">
                                    <?php $lists = explode('*',$item['faqs']); ?>
                                    <?php foreach(  $lists as $list ): ?>
                                        <li class="accordion-item">
                                            <a class="accordion-title" href="javascript:void(0)">
                                                <i class='bx bx-chevron-down'></i>
                                                <?php 
                                                $title = strtok($list, "\n"); ?>
                                                <?php echo esc_html( $title ); ?>
                                            </a>
            
                                            <div class="accordion-content">
                                                <?php $content = preg_replace('/^.+\n/', '', $list); ?>
                                                <p><?php echo esc_html( $content ); ?></p>
                                            </div>
                                        </li>
                                    <?php endforeach; ?>
                                </ul>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div> -->

                <div class="row">
                    <div class="col-lg-3 col-md-12">
                        <ul class="tabs">
                            <?php foreach( $settings['faq_tabs'] as $item ): ?>
                                <?php
                                    // Icon
                                    $icon = '';
                                    if( $item['icon_type'] == 1 ){
                                        $icon =$item['default_icon']; 
                                    } elseif( $item['icon_type'] == 2 ) {
                                        $icon = $item['fa_icon'];
                                    } elseif( $item['icon_type'] == 3 ) {
                                        $icon = $item['custom_icon'];
                                    } 
                                ?>
                                <li><a href="#"><i class='<?php echo esc_attr( $icon ); ?>'></i> <span><?php echo esc_html( $item['tab_title'] ); ?></span></a></li>
                            <?php endforeach; ?>
                        </ul>
                    </div>

                    <div class="col-lg-9 col-md-12">
                        <div class="tab-content">
                            <?php foreach( $settings['faq_tabs'] as $item ): ?>
                                <div class="tabs-item">
                                    <div class="faq-accordion-content">
                                        <ul class="accordion">
                                            <?php $lists = explode('*',$item['faqs']); ?>
                                            <?php foreach(  $lists as $list ): ?>
                                                <li class="accordion-item">
                                                    <a class="accordion-title" href="javascript:void(0)">
                                                        <i class='bx bx-chevron-down'></i>
                                                    <?php 
                                                        $title = strtok($list, "\n"); ?>
                                                    <?php echo esc_html( $title ); ?>
                                                    </a>
                    
                                                    <div class="accordion-content">
                                                        <?php $content = preg_replace('/^.+\n/', '', $list); ?>
                                                        <p><?php echo esc_html( $content ); ?></p>
                                                    </div>
                                                </li>
                                            <?php endforeach; ?>
                                        </ul>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php
	}

	protected function _content_template() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Doctrine_Faq_Two );