<?php
/**
 * Covid19 FAQ3 Widget
 */

namespace Elementor;
class Doctrine_FAQ_Three extends Widget_Base {

	public function get_name() {
        return 'Doctrine_FAQ_Three';
    }

	public function get_title() {
        return __( 'FAQ Style Three', 'covid19-toolkit' );
    }

	public function get_icon() {
        return 'eicon-accordion';
    }

	public function get_categories() {
        return [ 'covid19-elements' ];
    }

	protected function _register_controls() {

        $this->start_controls_section(
			'Doctrine_FAQ',
			[
				'label' => __( 'FAQ', 'covid19-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );           
            $item = new Repeater();

            $item->add_control(
                'title', 
                [
                    'label' => __( 'Title', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );
            $item->add_control(
                'content', 
                [
                    'label' => __( 'Content', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXTAREA,
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'items',
                [
                    'label' => __( 'Add Item', 'covid19-toolkit' ),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $item->get_controls(),
                    'default' => [
                        [
                            'title'     => __( 'What is the source of the virus?', 'covid19-toolkit' ),
                            'content'   => __( 'Coronaviruses are a large family of viruses. Some cause illness in people, and others, such as canine and feline coronaviruses, only infect animals. Rarely, animal coronaviruses that infect animals have emerged to infect people and can spread between people.', 'covid19-toolkit' ),
                        ],
                    ],
                    'title_field' => '{{{ title }}}',
                ]
            );
        $this->end_controls_section();

        $this->start_controls_section(
			'prevention_style',
			[
				'label' => __( 'Style', 'covid19-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => __( 'Title Typography', 'covid19-toolkit' ),
                    'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .faq-accordion .accordion .accordion-title',
                ]
            );
            
            $this->add_control(
                'title_color',
                [
                    'label' => __( 'Title Color', 'covid19-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .faq-accordion .accordion .accordion-title' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'content_typography',
                    'label' => __( 'Content Typography', 'covid19-toolkit' ),
                    'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .faq-accordion .accordion .accordion-content',
                ]
            );
            
            $this->add_control(
                'content_color',
                [
                    'label' => __( 'Content Color', 'covid19-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .faq-accordion .accordion .accordion-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );

        $this->end_controls_section();
    }

	protected function render() {

        $settings = $this->get_settings_for_display();	
        ?>

            <div class="faq-accordion">
                <ul class="accordion">
                    <?php $i = 0; foreach( $settings['items'] as $item ): ?>
                        <li class="accordion-item">
                            <a class="accordion-title <?php if( $i == 0 ): echo 'active'; endif; ?>" href="javascript:void(0)">
                                <i class="flaticon-add"></i>
                                <?php echo esc_html( $item['title'] ); ?>
                            </a>

                            <div class="accordion-content <?php if( $i == 0 ): echo 'show'; endif; ?>">
                                <p><?php echo esc_html( $item['content'] ); ?></p>
                            </div>
                        </li>
                    <?php $i++; endforeach; ?>
                </ul>
            </div>
        <?php
	}
	protected function _content_template() {}
}
Plugin::instance()->widgets_manager->register_widget_type( new Doctrine_FAQ_Three );