<?php
/**
 * Live Tracker Widget
 */

namespace Elementor;
class Doctrine_LiveTracker extends Widget_Base {

	public function get_name() {
        return 'Live Tracker';
    }

	public function get_title() {
        return __( 'Live Tracker', 'covid19-toolkit' );
    }

	public function get_icon() {
        return 'eicon-call-to-action';
    }

	public function get_categories() {
        return [ 'covid19-elements' ];
    }

	protected function _register_controls() {

        $this->start_controls_section(
			'Doctrine_LiveTrac',
			[
				'label' => __( 'Doctrine Live Tracker', 'covid19-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );        
            $this->add_control(
                'title',
                [
                    'label' => __( 'Home Button Text', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __('Back To Home', 'covid19-toolkit'),
                ]
            );

            $this->add_control(
                'tracker_url',
                [
                    'label' => __( 'Live Tracker URL', 'covid19-toolkit' ),
                    'type' => Controls_Manager::URL,
                ]
            );

        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        ?>
        <div id="live-map-tracker">
            <a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="link-btn"><?php echo esc_html( $settings['title'] ); ?></a>
            <iframe src="<?php echo esc_url( $settings['tracker_url']['url'] ); ?>"></iframe>
        </div>
        <?php
	}

	protected function _content_template() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Doctrine_LiveTracker );