<?php
/**
 * Banner Landing Widget
 */

namespace Elementor;
class Doctrine_Banner_Landing extends Widget_Base {

	public function get_name() {
        return 'BannerLanding';
    }

	public function get_title() {
        return __( 'Banner Landing', 'covid19-toolkit' );
    }

	public function get_icon() {
        return 'eicon-banner';
    }

	public function get_categories() {
        return [ 'covid19-elements' ];
    }

	protected function _register_controls() {

        $this->start_controls_section(
			'section',
			[
				'label' => __( 'Banner Content', 'covid19-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );
            $this->add_control(
                'title_tag',
                [
                    'label' => __( 'Title Tag', 'holab-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1'         => __( 'h1', 'holab-toolkit' ),
                        'h2'         => __( 'h2', 'holab-toolkit' ),
                        'h3'         => __( 'h3', 'holab-toolkit' ),
                        'h4'         => __( 'h4', 'holab-toolkit' ),
                        'h5'         => __( 'h5', 'holab-toolkit' ),
                        'h6'         => __( 'h6', 'holab-toolkit' ),
                    ],
                    'default' => 'h1',
                ]
            );

           $this->add_control(
                'top_title', 
                [
                    'label' => __( 'Top Title', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
					'default' => __('Stay Home &', 'covid19-toolkit'),
                ]
            );
           $this->add_control(
                'title', 
                [
                    'label' => __( 'Title', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXTAREA,
                    'label_block' => true,
					'default' => __('We’ll Defeat Coronavirus!', 'covid19-toolkit'),
                ]
            );            
           $this->add_control(
                'content', [
                    'label' => __( 'Content', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXTAREA,
                    'show_label' => false,
					'default' => __('Stay Aware of the Coronavirus, Stay Home & Safe For You and Others, And Maintain All the Safety Measures by Medical Professionals to Defeat It!', 'covid19-toolkit'),
                ]
            );
           $this->add_control(
                'background_image',
                [
                    'label' => __( 'Background Image', 'covid19-domain' ),
                    'type' => Controls_Manager::MEDIA,
                    'label_block' => true,
                    'separator'=>'after', 
                    'separator'=>'before',
                ]
            );
           $this->add_control(
                'image_one',
                [
                    'label' => __( 'Image One', 'covid19-domain' ),
                    'type' => Controls_Manager::MEDIA,
                    'label_block' => true,
                    'separator'=>'after', 
                    'separator'=>'before',
                ]
            );
            $this->add_control(
                'image_two',
                [
                    'label' => __( 'Image Two', 'covid19-domain' ),
                    'type' => Controls_Manager::MEDIA,
                    'label_block' => true,
                    'separator'=>'after', 
                    'separator'=>'before',
                ]
            );
            $this->add_control(
                'image_three',
                [
                    'label' => __( 'Image Three', 'covid19-domain' ),
                    'type' => Controls_Manager::MEDIA,
                    'label_block' => true,
                    'separator'=>'after', 
                    'separator'=>'before',
                ]
            );
            $this->add_control(
                'video_icon', 
                [
                    'label' => __( 'Video Button Icon Class Name', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                    'placeholder' => __( 'flaticon-play-button', 'plugin-domain' ),
					'default' 	=> __('flaticon-play-button', 'covid19-toolkit'),
                ]
            );
            $this->add_control(
                'video_button', 
                [
                    'label' => __( 'Video Button Text', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
					'default' 	=> __('Watch Video', 'covid19-toolkit'),
                ]
            );
            $this->add_control(
                'video_button_link', 
                [
                    'label' => esc_html__( 'Video Button Link( YouTube )', 'covid19-toolkit' ),
                    'type' => Controls_Manager::URL,
                    'label_block' => true,
                    'separator'=>'after', 
                    'separator'=>'before',   
                ]
            ); 

        $this->end_controls_section();
        
        $this->start_controls_section(
			'banner_style',
			[
				'label' => __( 'Style', 'covid19-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'top_title_typography',
                    'label' => __( 'Top Title Typography', 'covid19-toolkit' ),
                    'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .main-banner-content .sub-title',
                ]
            );

            $this->add_control(
                'top_title_color',
                [
                    'label' => __( 'Top Title Color', 'covid19-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .main-banner-content .sub-title' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => __( 'Title Typography', 'covid19-toolkit' ),
                    'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .main-banner-content h1, .main-banner-content h2, .main-banner-content h3, .main-banner-content h4, .main-banner-content h5, .main-banner-content h6',
                ]
            );
            
            $this->add_control(
                'title_color',
                [
                    'label' => __( 'Title Color', 'covid19-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .main-banner-content h1, .main-banner-content h2, .main-banner-content h3, .main-banner-content h4, .main-banner-content h5, .main-banner-content h6' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'content_typography',
                    'label' => __( 'Content Typography', 'covid19-toolkit' ),
                    'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .main-banner-content p',
                ]
            );
            $this->add_control(
                'content_color',
                [
                    'label' => __( 'Content Color', 'covid19-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .main-banner-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );

        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display();
        ?>
        
        <div class="banner-area" style="background-image:url(<?php echo esc_url($settings['background_image']['url']); ?>);">
            <div class="d-table">
                <div class="d-table-cell">
                    <div class="container">
                        <div class="row">
                            <div class="col-lg-6 col-md-12">
                                <div class="main-banner-content">
                                    <span class="sub-title"><?php echo esc_html( $settings['top_title'] ); ?></span>
                                    <<?php echo esc_attr( $settings['title_tag'] ); ?> data-shadow='<?php echo esc_html( $settings['title'] ); ?>'><?php echo esc_html( $settings['title'] ); ?> </<?php echo esc_attr( $settings['title_tag'] ); ?>>

                                    <p><?php echo wp_kses_post( $settings['content'] ); ?></p>
        
                                    <div class="btn-box">
                                        <?php if( $settings['video_button'] != '' ): ?>
                                            <?php if( $settings['video_icon'] != '' ): ?>
                                                <a href="<?php echo esc_url( $settings['video_button_link']['url'] ); ?>" class="popup-youtube optional-btn">
                                                    <i class="<?php echo esc_attr( $settings['video_icon'] ); ?>"></i>
                                                    <?php echo esc_html( $settings['video_button'] ); ?>
                                                </a>
                                            <?php else: ?>
                                                <a href="<?php echo esc_url( $settings['video_button_link']['url'] ); ?>" class="popup-youtube optional-btn btn_without_icon">
                                                    <?php echo esc_html( $settings['video_button'] ); ?>
                                                </a>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-6 col-md-12">
                                <div class="banner-image">
                                    <?php if ( $settings['image_one']['url'] != '' ) : ?>
                                        <img src="<?php echo esc_url( $settings['image_one']['url'] ); ?>" alt="<?php echo esc_attr( $settings['title'] ); ?>">
                                    <?php endif; ?>
                                    <?php if ( $settings['image_two']['url'] != '' ) : ?>
                                        <img src="<?php echo esc_url( $settings['image_two']['url'] ); ?>" alt="<?php echo esc_attr( $settings['title'] ); ?>">
                                    <?php endif; ?>
                                    <?php if ( $settings['image_three']['url'] != '' ) : ?>
                                        <img src="<?php echo esc_url( $settings['image_three']['url'] ); ?>" alt="<?php echo esc_attr( $settings['title'] ); ?>">
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
		
        <?php
	}

	protected function _content_template() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Doctrine_Banner_Landing );