<?php
/**
 * Covid19 Outbreak Widget
 */

namespace Elementor;
class Doctrine_Outbreak extends Widget_Base {

	public function get_name() {
        return 'Doctrine_Outbreak';
    }

	public function get_title() {
        return __( 'Outbreak', 'covid19-toolkit' );
    }

	public function get_icon() {
        return 'eicon-counter';
    }

	public function get_categories() {
        return [ 'covid19-elements' ];
    }

	protected function _register_controls() {

        $this->start_controls_section(
			'Doctrine_Outbreak',
			[
				'label' => __( 'Outbreak', 'covid19-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );
            $this->add_control(
                'outbreak_style',
                [
                    'label' => __( 'Style', 'covid19-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        '1'         => __( 'Style 1', 'covid19-toolkit' ),
                        '2'         => __( 'Style 2', 'covid19-toolkit' ),
                        '3'         => __( 'Style 3', 'covid19-toolkit' ),
                    ],
                    'default' => '1',
                ]
            );

			$this->add_control(
				'title',
				[
					'label' => __( 'Title', 'covid19-toolkit' ),
					'type' => Controls_Manager::TEXTAREA,
					'default' => esc_html__('COVID-19 Coronavirus Outbreak', 'covid19-toolkit'),
				]
            );
            $this->add_control(
                'title_tag',
                [
                    'label' => __( 'Title Tag', 'covid19-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1'         => __( 'h1', 'covid19-toolkit' ),
                        'h2'         => __( 'h2', 'covid19-toolkit' ),
                        'h3'         => __( 'h3', 'covid19-toolkit' ),
                        'h4'         => __( 'h4', 'covid19-toolkit' ),
                        'h5'         => __( 'h5', 'covid19-toolkit' ),
                        'h6'         => __( 'h6', 'covid19-toolkit' ),
                    ],
                    'default' => 'h2',
                ]
            );
			
			$this->add_control(
				'image',
				[
					'label' => __( 'Image', 'covid19-toolkit' ),
					'type' => Controls_Manager::MEDIA,
				]
			);
			$this->add_control(
				'background_image',
				[
					'label' => __( 'Background Image', 'covid19-toolkit' ),
					'type' => Controls_Manager::MEDIA,
				]
            );
               
            $card = new Repeater();
            $card->add_control(
                'title', 
                [
                    'label' => __( 'Title', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );
            $card->add_control(
                'icon', 
                [
                    'label' => __( 'Icon', 'covid19-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                    'label_block' => true,
                ]
            );
            $card->add_control(
                'count',
                [
                    'label' => __( 'Display Number By', 'covid19-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'cases'                 => __( 'Cases', 'covid19-toolkit' ),
                        'dead'                  => __( 'Deaths', 'covid19-toolkit' ),
                        'recovered'             => __( 'Recovered', 'covid19-toolkit' ),
                        'active'                => __( 'Active', 'covid19-toolkit' ),
                        'critical'              => __( 'Critical', 'covid19-toolkit' ),
                        'today-deaths'          => __( 'Deaths Today', 'covid19-toolkit' ),
                        'today-case'            => __( 'Cases Today', 'covid19-toolkit' ),
                        'affected-countries'    => __( 'Affected Countries', 'covid19-toolkit' ),
                    ],
                    'default' => 'cases',
                ]
            );
            $this->add_control(
                'cards',
                [
                    'label' => __( 'Add Card', 'covid19-toolkit' ),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $card->get_controls(),
                    'default' => [
                        [
                            'title'   => __( 'Total Country', 'covid19-toolkit' ),
                            'count'   => __( '187', 'covid19-toolkit' ),
                        ],
                        [
                            'title'   => __( 'Total Country', 'covid19-toolkit' ),
                            'count'   => __( '294110', 'covid19-toolkit' ),
                        ],
                    ],
                    'title_field' => '{{{ title }}}',
                ]
            );
            $this->add_control(
				'info',
				[
					'label' => __( 'Info Text', 'covid19-toolkit' ),
					'type' => Controls_Manager::WYSIWYG,
					'default' => esc_html__("Source: WHO on March 23, 2020", 'covid19-toolkit'),
				]
            );
        $this->end_controls_section();

        $this->start_controls_section(
			'symptom_style',
			[
				'label' => __( 'Style', 'covid19-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => __( 'Title Typography', 'covid19-toolkit' ),
                    'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .funfacts-area .section-title h1, .funfacts-area .section-title h2, .funfacts-area .section-title h3, .funfacts-area .section-title h4, .funfacts-area .section-title h5, .funfacts-area .section-title h6',
                ]
            );
            
            $this->add_control(
                'title_color',
                [
                    'label' => __( 'Title Color', 'covid19-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .funfacts-area .section-title h1, .funfacts-area .section-title h2, .funfacts-area .section-title h3, .funfacts-area .section-title h4, .funfacts-area .section-title h5, .funfacts-area .section-title h6' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'number_typography',
                    'label' => __( 'Number Typography', 'covid19-toolkit' ),
                    'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .single-funfacts-box h3, .outbreak-content .outbreak-box-list .single-outbreak-box h3, .outbreak-content .outbreak-box-list .row .col-lg-3:nth-child(2) .single-outbreak-box h3, .outbreak-content .outbreak-box-list .row .col-lg-3:nth-child(3) .single-outbreak-box h3, .outbreak-content .outbreak-box-list .row .col-lg-3:nth-child(4) .single-outbreak-box h3',
                ]
            );
            
            $this->add_control(
                'number_color',
                [
                    'label' => __( 'Number Color', 'covid19-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-funfacts-box h3, .outbreak-content .outbreak-box-list .single-outbreak-box h3, .outbreak-content .outbreak-box-list .row .col-lg-3:nth-child(2) .single-outbreak-box h3, .outbreak-content .outbreak-box-list .row .col-lg-3:nth-child(3) .single-outbreak-box h3, .outbreak-content .outbreak-box-list .row .col-lg-3:nth-child(4) .single-outbreak-box h3' => 'color: {{VALUE}}',
                    ],
                ]
            );

        $this->end_controls_section();
    }

	protected function render() {

        $settings = $this->get_settings_for_display();	
        ?>
        <?php if( $settings['outbreak_style'] == '1' ): ?>
            <div class="funfacts-area ptb-100 jarallax" data-jarallax='{"speed": 0.3}' style="background-image:url(<?php echo esc_url( $settings['background_image']['url'] ); ?>);">
                <div class="container">
                    <div class="section-title">
                        <<?php echo esc_attr( $settings['title_tag'] ); ?>><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>
                    </div>
                    
                    <div class="row align-items-center">
                        <div class="col-lg-6 col-md-12">
                            <div class="funfacts-image">
                                <?php if( $settings['image']['url'] != '' ): ?>
                                    <img src="<?php echo esc_url( $settings['image']['url'] ); ?>" alt="<?php echo esc_attr( $settings['title'] ); ?>">
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="col-lg-6 col-md-12">
                            <div class="funfacts-list">
                                <div class="row">
                                    <?php foreach( $settings['cards'] as $item ): ?>
                                        <div class="col-lg-6 col-md-6 col-sm-6">
                                            <div class="single-funfacts-box">
                                                <div class="icon">
                                                    <?php if( $item['icon']['url'] != '' ): ?>
                                                        <img src="<?php echo esc_url( $item['icon']['url'] ); ?>" alt="<?php echo esc_attr( $item['title'] ); ?>">
                                                    <?php endif; ?>
                                                </div>

                                                <h3 class="odometer" id="cov19-total-<?php echo esc_attr( $item['count'] ); ?>" data-count="0"></h3>                                           
                                                
                                                <p><?php echo esc_html( $item['title'] ); ?></p>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-12 col-md-12">
                            <div class="funfacts-info">
                                <p><?php echo wp_kses_post( $settings['info'] ) ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php elseif( $settings['outbreak_style'] == '2' ): ?>
            <div class="funfacts-section ptb-100">
                <div class="container">
                    <div class="section-title">
                        <<?php echo esc_attr( $settings['title_tag'] ); ?>><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>
                    </div>
                </div>
                    
                <div class="container-fluid">
                    <div class="row align-items-center">
                        <div class="col-lg-6 col-md-12">
                            <div class="funfacts-image">
                                <?php if( $settings['image']['url'] != '' ): ?>
                                    <img src="<?php echo esc_url( $settings['image']['url'] ); ?>" alt="<?php echo esc_attr( $settings['title'] ); ?>">
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="col-lg-6 col-md-12">
                            <div class="funfacts-list">
                                <div class="row">
                                    <?php foreach( $settings['cards'] as $item ): ?>
                                        <div class="col-lg-6 col-md-6 col-sm-6">
                                            <div class="single-funfacts-box bg-white">
                                                <div class="icon">
                                                    <?php if( $item['icon']['url'] != '' ): ?>
                                                        <img src="<?php echo esc_url( $item['icon']['url'] ); ?>" alt="<?php echo esc_attr( $item['title'] ); ?>">
                                                    <?php endif; ?>
                                                </div>
                                                <h3 class="odometer" id="cov19-total-<?php echo esc_attr( $item['count'] ); ?>" data-count="0"></h3>    
                                                <p><?php echo esc_html( $item['title'] ); ?></p>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>                                 

                                    <div class="col-lg-12 col-md-12">
                                        <div class="funfacts-info color-black">
                                            <p><?php echo wp_kses_post( $settings['info'] ) ?></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <?php if( $settings['background_image']['url'] != '' ): ?>
                    <div class="funfacts-shape1"><img src="<?php echo esc_url( $settings['background_image']['url'] ); ?>" alt="<?php echo esc_attr__( 'Shape Image', 'covid19-toolkit' ); ?>"></div>
                <?php endif; ?>
            </div>
        <?php else : ?>

            <div class="container">
                <div class="outbreak-content">
                    <div class="outbreak-box-list">
                        <div class="row">
                            <?php foreach ( $settings['cards'] as $item ) : ?>
                                <div class="col-lg-3 col-sm-6 col-md-6">
                                    <div class="single-outbreak-box">
                                        <div class="icon">
                                            <?php if( $item['icon']['url'] != '' ): ?>
                                                <img src="<?php echo esc_url( $item['icon']['url'] ); ?>" alt="<?php echo esc_attr( $item['title'] ); ?>">
                                            <?php endif; ?>
                                        </div>
                                        <h3 class="odometer" id="cov19-total-<?php echo esc_attr( $item['count'] ); ?>" data-count="0"></h3>    
                                        <p><?php echo esc_html( $item['title'] ); ?></p>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                    <?php if( $settings['image']['url'] != '' ): ?>
                        <img src="<?php echo esc_url( $settings['image']['url'] ); ?>" alt="<?php echo esc_attr( $settings['title'] ); ?>">
                    <?php endif; ?>
                </div>
            </div>

        <?php endif; ?>
        <?php
	}
	protected function _content_template() {}
}
Plugin::instance()->widgets_manager->register_widget_type( new Doctrine_Outbreak );