<?php
/**
 * Covid19 Prevention_Two Widget
 */

namespace Elementor;
class Doctrine_Prevention_Two extends Widget_Base {

	public function get_name() {
        return 'Doctrine_Prevention_Two';
    }

	public function get_title() {
        return __( 'Prevention Two', 'covid19-toolkit' );
    }

	public function get_icon() {
        return 'eicon-editor-list-ul';
    }

	public function get_categories() {
        return [ 'covid19-elements' ];
    }

	protected function _register_controls() {

        $this->start_controls_section(
			'Doctrine_Prevention_Two',
			[
				'label' => __( 'Prevention Two', 'covid19-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

			$this->add_control(
				'top_title',
				[
					'label' => __( 'Top Title', 'covid19-toolkit' ),
					'type' => Controls_Manager::TEXT,
					'default' => esc_html__('Prevention', 'covid19-toolkit'),
				]
			);
			$this->add_control(
				'title',
				[
					'label' => __( 'Title', 'covid19-toolkit' ),
					'type' => Controls_Manager::TEXTAREA,
					'default' => esc_html__('How to Protect Yourself', 'covid19-toolkit'),
				]
            );
            $this->add_control(
                'title_tag',
                [
                    'label' => __( 'Title Tag', 'covid19-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1'         => __( 'h1', 'covid19-toolkit' ),
                        'h2'         => __( 'h2', 'covid19-toolkit' ),
                        'h3'         => __( 'h3', 'covid19-toolkit' ),
                        'h4'         => __( 'h4', 'covid19-toolkit' ),
                        'h5'         => __( 'h5', 'covid19-toolkit' ),
                        'h6'         => __( 'h6', 'covid19-toolkit' ),
                    ],
                    'default' => 'h2',
                ]
            );

            $this->add_control(
				'left_table_title',
				[
					'label' => __( 'Left Table Title', 'covid19-toolkit' ),
					'type' => Controls_Manager::TEXT,
					'default' => esc_html__('Things You Should Do', 'covid19-toolkit'),
				]
			);
               
            $left_item = new Repeater();
            $left_item->add_control(
                'title', 
                [
                    'label' => __( 'Title', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );
            $left_item->add_control(
                'content', 
                [
                    'label' => __( 'Content', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXTAREA,
                    'label_block' => true,
                ]
            );
            $left_item->add_control(
                'image', 
                [
                    'label' => __( 'Image', 'covid19-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                ]
            );
            $this->add_control(
                'left_item',
                [
                    'label' => __( 'Left List Content', 'covid19-toolkit' ),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $left_item->get_controls(),
                    'default' => [
                        [
                            'title'     => __( 'Wash Your Hand For 20 Sec', 'covid19-toolkit' ),
                            'content'   => __( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore.', 'covid19-toolkit' ),
                        ],
                    ],
                    'title_field' => '{{{ title }}}',
                ]
            );

            $this->add_control(
				'right_table_title',
				[
					'label' => __( 'Right Table Title', 'covid19-toolkit' ),
					'type' => Controls_Manager::TEXT,
					'default' => esc_html__('Things You Shouldn’t Do', 'covid19-toolkit'),
				]
			);

            $right_item = new Repeater();
            $right_item->add_control(
                'title', 
                [
                    'label' => __( 'Title', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );
            $right_item->add_control(
                'content', 
                [
                    'label' => __( 'Content', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXTAREA,
                    'label_block' => true,
                ]
            );
            
            $right_item->add_control(
                'image', 
                [
                    'label' => __( 'Image', 'covid19-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                ]
            );
            $this->add_control(
                'right_item',
                [
                    'label' => __( 'Right List Content', 'covid19-toolkit' ),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $right_item->get_controls(),
                    'default' => [
                        [
                            'title'     => __( 'Avoid Crowded Places', 'covid19-toolkit' ),
                            'content'   => __( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore.', 'covid19-toolkit' ),
                        ],
                    ],
                    'title_field' => '{{{ title }}}',
                ]
            );
        $this->end_controls_section();

        $this->start_controls_section(
			'symptom_style',
			[
				'label' => __( 'Style', 'covid19-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'top_title_typography',
                    'label' => __( 'Top Title Typography', 'covid19-toolkit' ),
                    'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .section-title .sub-title',
                ]
            );

            $this->add_control(
                'top_title_color',
                [
                    'label' => __( 'Top Title Color', 'covid19-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .section-title .sub-title' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => __( 'Title Typography', 'covid19-toolkit' ),
                    'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .section-title h1, .section-title h2, .section-title h3, .section-title h4, .section-title h5, .section-title h6',
                ]
            );
            
            $this->add_control(
                'title_color',
                [
                    'label' => __( 'Title Color', 'covid19-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .section-title h1, .section-title h2, .section-title h3, .section-title h4, .section-title h5, .section-title h6' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'table_title_typography',
                    'label' => __( 'Table Title Typography', 'covid19-toolkit' ),
                    'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .prevention-content .title h3',
                ]
            );
            
            $this->add_control(
                'table_title_color',
                [
                    'label' => __( 'Table Title Color', 'covid19-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .prevention-content .title h3' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_control(
                'table_title_bg_color',
                [
                    'label' => __( 'Left Table Title Color', 'covid19-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .prevention-content .title' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'right_table_title_bg_color',
                [
                    'label' => __( 'Right Table Title Color', 'covid19-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .col-lg-6:nth-child(2) .prevention-content .title' => 'background-color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'list_typography',
                    'label' => __( 'List Title Typography', 'covid19-toolkit' ),
                    'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .prevention-content .content-list .content h3',
                ]
            );
            
            $this->add_control(
                'list_title_color',
                [
                    'label' => __( 'List Title Color', 'covid19-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .prevention-content .content-list .content h3' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'list_content_typography',
                    'label' => __( 'List Content Typography', 'covid19-toolkit' ),
                    'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .prevention-content .content-list .content p',
                ]
            );
            
            $this->add_control(
                'list_content_color',
                [
                    'label' => __( 'List Content Color', 'covid19-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .prevention-content .content-list .content p' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_control(
                'shape_image1',
                [
                    'label' => __( 'Shape Image One', 'covid19-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                ]
            );
            $this->add_control(
                'shape_image2',
                [
                    'label' => __( 'Shape Image Two', 'covid19-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                ]
            );
            $this->add_control(
                'shape_image3',
                [
                    'label' => __( 'Shape Image Three', 'covid19-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                ]
            );
            $this->add_control(
                'shape_image4',
                [
                    'label' => __( 'Shape Image Four', 'covid19-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                ]
            );

        $this->end_controls_section();
    }

	protected function render() {

        $settings = $this->get_settings_for_display();	

        
        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');
        $this-> add_inline_editing_attributes('left_table_title','none');
        $this-> add_inline_editing_attributes('right_table_title','none');

        ?>
        <div class="prevention-area pt-100 pb-70">
            <div class="container">
                <div class="section-title">
                    <span class="sub-title"><?php echo esc_html( $settings['top_title'] ); ?></span>
                    <<?php echo esc_attr( $settings['title_tag'] ); ?> <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>
                </div>

                <div class="row">
                    <div class="col-lg-6 col-md-6">
                        <div class="prevention-content">
                            <div class="title">
                                <h3 <?php echo $this-> get_render_attribute_string('left_table_title'); ?>><?php echo esc_html( $settings['left_table_title'] ); ?></h3>
                            </div>

                            <div class="content-list">
                                <?php foreach( $settings['left_item'] as $item ): ?>
                                    <div class="content">
                                        <?php if( $item['image']['url'] ): ?>
                                            <div class="icon">
                                                <img src="<?php echo esc_url( $item['image']['url'] ); ?>" alt="<?php echo esc_attr( $item['title'] ); ?>">
                                            </div>
                                        <?php endif; ?>
                                        <h3><?php echo esc_html( $item['title'] ); ?></h3>
                                        <p><?php echo esc_html( $item['content'] ); ?></p>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-6 col-md-6">
                        <div class="prevention-content">
                            <div class="title">
                                <h3 <?php echo $this-> get_render_attribute_string('right_table_title'); ?>><?php echo esc_html( $settings['right_table_title'] ); ?></h3>
                            </div>

                            <div class="content-list">
                                <?php foreach( $settings['right_item'] as $right_item ): ?>
                                    <div class="content">
                                        <?php if( $right_item['image']['url'] ): ?>
                                            <div class="icon">
                                                <img src="<?php echo esc_url( $right_item['image']['url'] ); ?>" alt="<?php echo esc_attr( $right_item['title'] ); ?>">
                                            </div>
                                        <?php endif; ?>
                                        <h3><?php echo esc_html( $right_item['title'] ); ?></h3>
                                        <p><?php echo esc_html( $right_item['content'] ); ?></p>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <?php if( $settings['shape_image1']['url'] != '' ): ?>
                <div class="prevention-shape1"><img src="<?php echo esc_url( $settings['shape_image1']['url'] ); ?>" alt="<?php echo esc_attr( $settings['title'] ); ?>"></div>
            <?php endif; ?>

            <?php if( $settings['shape_image2']['url'] != '' ): ?>
                <div class="prevention-shape2"><img src="<?php echo esc_url( $settings['shape_image2']['url'] ); ?>" alt="<?php echo esc_attr( $settings['title'] ); ?>"></div>
            <?php endif; ?>

            <?php if( $settings['shape_image2']['url'] != '' ): ?>
                <div class="prevention-shape2"><img src="<?php echo esc_url( $settings['shape_image3']['url'] ); ?>" alt="<?php echo esc_attr( $settings['title'] ); ?>"></div>
            <?php endif; ?>

            <?php if( $settings['shape_image2']['url'] != '' ): ?>
                <div class="prevention-shape2"><img src="<?php echo esc_url( $settings['shape_image4']['url'] ); ?>" alt="<?php echo esc_attr( $settings['title'] ); ?>"></div>
            <?php endif; ?>
        </div>
        <?php
	}
	protected function _content_template() {}
}
Plugin::instance()->widgets_manager->register_widget_type( new Doctrine_Prevention_Two );