<?php
/**
 * Covid19 Prevention Widget
 */

namespace Elementor;
class Doctrine_Prevention extends Widget_Base {

	public function get_name() {
        return 'Doctrine_Prevention';
    }

	public function get_title() {
        return __( 'Prevention', 'covid19-toolkit' );
    }

	public function get_icon() {
        return 'eicon-table-of-contents';
    }

	public function get_categories() {
        return [ 'covid19-elements' ];
    }

	protected function _register_controls() {

        $this->start_controls_section(
			'Doctrine_Prevention',
			[
				'label' => __( 'Prevention', 'covid19-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

            $this->add_control(
                'style',
                [
                    'label' => __( 'Style', 'covid19-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        '1'         => __( 'Style One', 'covid19-toolkit' ),
                        '2'         => __( 'Style Two', 'covid19-toolkit' ),
                    ],
                    'default' => '1',
                ]
            );

			$this->add_control(
				'shape_image_one',
				[
					'label' => __( 'Shape Image One', 'covid19-toolkit' ),
					'type' => Controls_Manager::MEDIA,
                    'condition' => [
                        'style' => ['1', '3'],
                    ],
				]
			);
			$this->add_control(
				'shape_image_two',
				[
					'label' => __( 'Shape Image Two', 'covid19-toolkit' ),
					'type' => Controls_Manager::MEDIA,
                    'condition' => [
                        'style' => ['1'],
                    ],
				]
			);
			$this->add_control(
				'shape_image_three',
				[
					'label' => __( 'Shape Image Three', 'covid19-toolkit' ),
					'type' => Controls_Manager::MEDIA,
                    'condition' => [
                        'style' => ['1'],
                    ],
				]
			);
			$this->add_control(
				'shape_image_four',
				[
					'label' => __( 'Shape Image Four', 'covid19-toolkit' ),
					'type' => Controls_Manager::MEDIA,
                    'condition' => [
                        'style' => ['1'],
                    ],
				]
			);
			$this->add_control(
				'section_image',
				[
					'label' => __( 'Section Image', 'covid19-toolkit' ),
					'type' => Controls_Manager::MEDIA,
                    'condition' => [
                        'style' => ['2'],
                    ],
				]
			);
               
            $item = new Repeater();

            $item->add_control(
                'style',
                [
                    'label' => __( 'Style', 'covid19-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        '1'         => __( 'Style One', 'covid19-toolkit' ),
                        '2'         => __( 'Style Two', 'covid19-toolkit' ),
                    ],
                    'default' => '1',
                ]
            );
            $item->add_control(
                'title', 
                [
                    'label' => __( 'Title', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );
            $item->add_control(
				'icon',
				[
					'label' => __( 'Icon Class', 'covid19-toolkit' ),
					'type' => Controls_Manager::TEXT,
                    'default' => __('flaticon-hand-wash', 'covid19-toolkit'),
                    'description' => wp_kses_post( 'e.g flaticon-open-book. You can use Font-Awesome/Boxicons. Please follow <a href="https://docs.envytheme.com/docs/covid19-theme-documentation/faqs/how-to-use-icons/" target="_blank">documentation</a> for icon use', 'covid19-toolkit'),
                    'condition' => [
                        'style' => ['1', '2'],
                    ],
				]
			);
            $item->add_control(
                'content', 
                [
                    'label' => __( 'Content', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXTAREA,
                    'label_block' => true,
                ]
            );
            $item->add_control(
                'image', 
                [
                    'label' => __( 'Image', 'covid19-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                    'label_block' => true,
                    'condition' => [
                        'style' => ['1'],
                    ],
                ]
            );
            $this->add_control(
                'items',
                [
                    'label' => __( 'Add Item', 'covid19-toolkit' ),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $item->get_controls(),
                    'default' => [
                        [
                            'title'     => __( 'Wash your hands', 'covid19-toolkit' ),
                            'content'   => __( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor.', 'covid19-toolkit' ),
                            'icon'      => __( 'flaticon-hand-wash', 'covid19-toolkit' ),
                        ],
                    ],
                    'title_field' => '{{{ title }}}',
                ]
            );
        $this->end_controls_section();

        $this->start_controls_section(
			'prevention_style',
			[
				'label' => __( 'Style', 'covid19-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => __( 'Title Typography', 'covid19-toolkit' ),
                    'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .how-to-protect-content .content .text h3, .how-to-protect-content-list .content .text h3',
                ]
            );
            
            $this->add_control(
                'title_color',
                [
                    'label' => __( 'Title Color', 'covid19-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .how-to-protect-content .content .text h3, .how-to-protect-content-list .content .text h3' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'content_typography',
                    'label' => __( 'Content Typography', 'covid19-toolkit' ),
                    'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .how-to-protect-content .content .text p, .how-to-protect-content-list .content .text p',
                ]
            );
            
            $this->add_control(
                'content_color',
                [
                    'label' => __( 'Content Color', 'covid19-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .how-to-protect-content .content .text p, .how-to-protect-content-list .content .text p' => 'color: {{VALUE}}',
                    ],
                ]
            );

        $this->end_controls_section();
    }

	protected function render() {

        $settings = $this->get_settings_for_display();	
        ?>
        <?php if( $settings['style'] == '1' ): ?>
            <div class="container">
                <div class="row">
                    <div class="col-lg-5 col-md-12">
                        <div class="how-to-protect-content">
                            <?php foreach( $settings['items'] as $item ): ?>
                                <div class="content">
                                    <div class="text">
                                        <div class="icon">
                                            <i class="<?php echo esc_attr( $item['icon'] ); ?>"></i>
                                        </div>
                                        <h3><?php echo esc_html( $item['title'] ); ?></h3>
                                        <p><?php echo esc_html( $item['content'] ); ?></p>
                                    </div>
                                </div>
                            <?php endforeach; ?>                        
                        </div>
                    </div>

                    <div class="col-lg-7 col-md-12">
                        <div class="how-to-protect-image">
                            <?php $i = 1; foreach( $settings['items'] as $item ): ?>
                                <?php if( $item['image']['url'] != '' ): ?>
                                    <img src="<?php echo esc_url( $item['image']['url'] ); ?>" class="main-image main-image<?php echo esc_attr( $i ); ?>" alt="<?php echo esc_attr( $item['title'] ); ?>">
                                <?php endif; ?>
                            <?php $i++; endforeach; ?>

                            <div class="how-to-protect-shape">
                            
                                <?php if( $settings['shape_image_one']['url'] != '' ): ?>
                                    <img src="<?php echo esc_url( $settings['shape_image_one']['url'] ); ?>" alt="<?php echo esc_attr__( 'Shape Image', 'covid19-toolkit' ); ?>">
                                <?php endif; ?>

                                <?php if( $settings['shape_image_two']['url'] != '' ): ?>
                                    <img src="<?php echo esc_url( $settings['shape_image_two']['url'] ); ?>" alt="<?php echo esc_attr__( 'Shape Image', 'covid19-toolkit' ); ?>">
                                <?php endif; ?>

                                <?php if( $settings['shape_image_three']['url'] != '' ): ?>
                                    <img src="<?php echo esc_url( $settings['shape_image_three']['url'] ); ?>" alt="<?php echo esc_attr__( 'Shape Image', 'covid19-toolkit' ); ?>">
                                <?php endif; ?>

                                <?php if( $settings['shape_image_four']['url'] != '' ): ?>
                                    <img src="<?php echo esc_url( $settings['shape_image_four']['url'] ); ?>" alt="<?php echo esc_attr__( 'Shape Image', 'covid19-toolkit' ); ?>">
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php elseif( $settings['style'] == '2' ): ?>
            <div class="container-fluid">
                <div class="row">
                    <div class="col-lg-5 col-md-12">
                        <div class="how-to-protect-content-list">
                            <?php foreach( $settings['items'] as $item ): ?>
                                <div class="content">
                                    <div class="text">
                                        <div class="icon">
                                            <i class="<?php echo esc_attr( $item['icon'] ); ?>"></i>
                                        </div>
                                        <h3><?php echo esc_html( $item['title'] ); ?></h3>
                                        <p><?php echo esc_html( $item['content'] ); ?></p>
                                    </div>
                                </div>
                            <?php endforeach; ?>                        
                        </div>
                    </div>

                    <div class="col-lg-7 col-md-12">
                        <div class="how-to-protect-image">
                            <?php if( $settings['section_image']['url'] != '' ): ?>
                                <img src="<?php echo esc_url( $settings['section_image']['url'] ); ?>" alt="<?php echo esc_attr__( 'Shape Image', 'covid19-toolkit' ); ?>">
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
        <?php
	}
	protected function _content_template() {}
}
Plugin::instance()->widgets_manager->register_widget_type( new Doctrine_Prevention );