<?php
/**
 * Section Widget
 */

namespace Elementor;
class Doctrine_Single_Doctor_Card extends Widget_Base {

	public function get_name() {
        return 'SingleDoctorCard';
    }

	public function get_title() {
        return __( 'Single Doctor Card', 'covid19-toolkit' );
    }

	public function get_icon() {
        return 'eicon-info-box';
    }

	public function get_categories() {
        return [ 'covid19-elements' ];
    }

	protected function _register_controls() {

        $this->start_controls_section(
			'Doctrine_Single_Doctor_Card',
			[
				'label' => __( 'Doctrine Single Doctor Card', 'covid19-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
				'description' => __( 'This widget properly worked on single doctor page', 'covid19-toolkit' ),
			]
        );

            $this->add_control(
                'title',
                [
                    'label' => __( 'Title', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __('Hello i’m Dr. Sophia Charlotte.', 'covid19-toolkit'),
                ]
            );

            $this->add_control(
                'title_tag',
                [
                    'label' => __( 'Title Tag', 'holab-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1'         => __( 'h1', 'holab-toolkit' ),
                        'h2'         => __( 'h2', 'holab-toolkit' ),
                        'h3'         => __( 'h3', 'holab-toolkit' ),
                        'h4'         => __( 'h4', 'holab-toolkit' ),
                        'h5'         => __( 'h5', 'holab-toolkit' ),
                        'h6'         => __( 'h6', 'holab-toolkit' ),
                    ],
                    'default' => 'h2',
                ]
            );

            $this->add_control(
                'content',
                [
                    'label' => __( 'Content', 'covid19-toolkit' ),
                    'type' => Controls_Manager::WYSIWYG,
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'section_style',
			[
				'label' => __( 'Style', 'covid19-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

            $this->add_control(
                'title_color',
                [
                    'label' => __( 'Title Color', 'covid19-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .doctor-details-desc h1, .doctor-details-desc h2, .doctor-details-desc h3, .doctor-details-desc h4, .doctor-details-desc h5, .doctor-details-desc h6' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'title_typography',
					'label' => __( 'Title Typography', 'covid19-toolkit' ),
					'scheme' => Scheme_Typography::TYPOGRAPHY_1,
					'selector' => '{{WRAPPER}} .doctor-details-desc h1, .doctor-details-desc h2, .doctor-details-desc h3, .doctor-details-desc h4, .doctor-details-desc h5, .doctor-details-desc h6',
				]
            );

        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');

        ?>
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-5 col-md-12">
                    <div class="doctor-details-image">						
                        <img src="<?php the_post_thumbnail_url( 'covid19_doctor_thumb' ); ?>" alt="<?php the_post_thumbnail_caption(); ?>">  

                        <h3><?php the_title(); ?></h3>
                        
                        <?php $designation  = get_field('designation'); ?>
                        <span><?php echo esc_html( $designation ) ?></span>

                        <?php if( have_rows('doctor_social_links') ): ?>
                            <ul class="social">
                                <?php  while ( have_rows('doctor_social_links') ) : the_row(); ?>
                                    <li><a href="<?php esc_url(the_sub_field('link')); ?>" target="_blank"><i class='<?php the_sub_field('doctor_select_icon'); ?>'></i></a></li>
                                <?php endwhile; ?>
                            </ul>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="col-lg-7 col-md-12">
                    <div class="doctor-details-desc">
                        <<?php echo esc_attr( $settings['title_tag'] ); ?> <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>

                       <?php echo $settings['content']; ?>
                    </div>
                </div>
            </div>
        </div>            
        <?php
	}

	protected function _content_template() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Doctrine_Single_Doctor_Card );