<?php
/**
 * Spreads Virus Widget
 */

namespace Elementor;
class Doctrine_Spreads_Virus extends Widget_Base {

	public function get_name() {
        return 'SpreadsVirus';
    }

	public function get_title() {
        return __( 'Spreads Virus', 'covid19-toolkit' );
    }

	public function get_icon() {
        return 'eicon-anchor';
    }

	public function get_categories() {
        return [ 'covid19-elements' ];
    }

	protected function _register_controls() {

        $this->start_controls_section(
			'section',
			[
				'label' => __( 'Spreads Content', 'covid19-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );
            $this->add_control(
                'image_position',
                [
                    'label' => __( 'Image Position Left', 'covid19-toolkit' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => __( 'Yes', 'covid19-toolkit' ),
                    'label_off' => __( 'No', 'covid19-toolkit' ),
                    'return_value' => 'yes',
                    'default' => 'yes',
                ]
            );
            $this->add_control(
                'title_tag',
                [
                    'label' => __( 'Title Tag', 'holab-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1'         => __( 'h1', 'holab-toolkit' ),
                        'h2'         => __( 'h2', 'holab-toolkit' ),
                        'h3'         => __( 'h3', 'holab-toolkit' ),
                        'h4'         => __( 'h4', 'holab-toolkit' ),
                        'h5'         => __( 'h5', 'holab-toolkit' ),
                        'h6'         => __( 'h6', 'holab-toolkit' ),
                    ],
                    'default' => 'h1',
                ]
            );
           $this->add_control(
                'title', 
                [
                    'label' => __( 'Title', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXTAREA,
                    'label_block' => true,
					'default' => __('Close Contact With An Infected Person', 'covid19-toolkit'),
                ]
            );            
           $this->add_control(
                'content', [
                    'label' => __( 'Content', 'covid19-toolkit' ),
                    'type' => Controls_Manager::WYSIWYG,
                    'show_label' => false,
					'default' => __('Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Quis ipsum suspendisse ultrices gravida. Risus commodo viverra maecenas accumsan lacus vel facilisis.', 'covid19-toolkit'),
                ]
            );
           $this->add_control(
                'top_image',
                [
                    'label' => __( 'Section Title Image', 'plugin-domain' ),
                    'type' => Controls_Manager::MEDIA,
                    'label_block' => true,
                    'separator'=>'after', 
                    'separator'=>'before',
                ]
            );
           $this->add_control(
                'image',
                [
                    'label' => __( 'Image', 'plugin-domain' ),
                    'type' => Controls_Manager::MEDIA,
                    'label_block' => true,
                    'separator'=>'after', 
                    'separator'=>'before',
                ]
            );
            $this->add_control(
                'shape_image1',
                [
                    'label' => __( 'Shape Image One', 'plugin-domain' ),
                    'type' => Controls_Manager::MEDIA,
                    'label_block' => true,
                    'separator'=>'after', 
                    'separator'=>'before',
                ]
            );
            $this->add_control(
                'shape_image2',
                [
                    'label' => __( 'Shape Image Two', 'plugin-domain' ),
                    'type' => Controls_Manager::MEDIA,
                    'label_block' => true,
                    'separator'=>'after', 
                    'separator'=>'before',
                ]
            );
        $this->end_controls_section();
        
        $this->start_controls_section(
			'spreads_style',
			[
				'label' => __( 'Style', 'covid19-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => __( 'Title Typography', 'covid19-toolkit' ),
                    'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .overview-box .overview-content .content h1, .overview-box .overview-content .content h2, .overview-box .overview-content .content h3, .overview-box .overview-content .content h4, .overview-box .overview-content .content h5, .overview-box .overview-content .content h6',
                ]
            );
            
            $this->add_control(
                'title_color',
                [
                    'label' => __( 'Title Color', 'covid19-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .overview-box .overview-content .content h1, .overview-box .overview-content .content h2, .overview-box .overview-content .content h3, .overview-box .overview-content .content h4, .overview-box .overview-content .content h5, .overview-box .overview-content .content h6' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'content_typography',
                    'label' => __( 'Content Typography', 'covid19-toolkit' ),
                    'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .overview-box .overview-content .content p',
                ]
            );
            $this->add_control(
                'content_color',
                [
                    'label' => __( 'Content Color', 'covid19-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .overview-box .overview-content .content p' => 'color: {{VALUE}}',
                    ],
                ]
            );

        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display();
        
        ?>
        <div class="container">
            <div class="overview-box">
                <?php if( $settings['image_position'] == 'yes' ): ?>
                    <div class="overview-image">
                        <div class="image">
                            <?php if( $settings['image']['url'] != '' ): ?>
                                <img class="main-image" src="<?php echo esc_url( $settings['image']['url'] ); ?>" alt="<?php echo esc_attr( $settings['title'] ); ?>">
                            <?php endif; ?>

                            <div class="shape">                            
                                <?php if( $settings['shape_image1']['url'] != '' ): ?>
                                    <img src="<?php echo esc_url( $settings['shape_image1']['url'] ); ?>" alt="<?php echo esc_attr( $settings['title'] ); ?>">
                                <?php endif; ?>

                                <?php if( $settings['shape_image2']['url'] != '' ): ?>
                                    <img src="<?php echo esc_url( $settings['shape_image2']['url'] ); ?>" alt="<?php echo esc_attr( $settings['title'] ); ?>">
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <div class="overview-content">
                    <div class="content">
                        <div class="icon">
                            <?php if( $settings['top_image']['url'] != '' ): ?>
                                <img src="<?php echo esc_url( $settings['top_image']['url'] ); ?>" alt="<?php echo esc_attr( $settings['title'] ); ?>">
                            <?php endif; ?>
                        </div>
                        
                        <<?php echo esc_attr( $settings['title_tag'] ); ?> data-shadow='<?php echo esc_html( $settings['title'] ); ?>'><?php echo esc_html( $settings['title'] ); ?> </<?php echo esc_attr( $settings['title_tag'] ); ?>>

                        <?php echo wp_kses_post( $settings['content'] ); ?>
                    </div>
                </div>
                
                <?php if( $settings['image_position'] != 'yes' ): ?>
                    <div class="overview-image">
                        <div class="image">
                            <?php if( $settings['image']['url'] != '' ): ?>
                                <img class="main-image" src="<?php echo esc_url( $settings['image']['url'] ); ?>" alt="<?php echo esc_attr( $settings['title'] ); ?>">
                            <?php endif; ?>

                            <div class="shape">                            
                                <?php if( $settings['shape_image1']['url'] != '' ): ?>
                                    <img src="<?php echo esc_url( $settings['shape_image1']['url'] ); ?>" alt="<?php echo esc_attr( $settings['title'] ); ?>">
                                <?php endif; ?>

                                <?php if( $settings['shape_image2']['url'] != '' ): ?>
                                    <img src="<?php echo esc_url( $settings['shape_image2']['url'] ); ?>" alt="<?php echo esc_attr( $settings['title'] ); ?>">
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

            </div>	
        </div>	
        <?php
	}

	protected function _content_template() {}

}

Plugin::instance()->widgets_manager->register_widget_type( new Doctrine_Spreads_Virus );