<?php
/**
 * Covid19 SpreadVirus2 Widget
 */

namespace Elementor;
class Doctrine_SpreadVirus_Two extends Widget_Base {

	public function get_name() {
        return 'Doctrine_SpreadVirus_Two';
    }

	public function get_title() {
        return __( 'Spread Virus Two', 'covid19-toolkit' );
    }

	public function get_icon() {
        return 'eicon-anchor';
    }

	public function get_categories() {
        return [ 'covid19-elements' ];
    }

	protected function _register_controls() {

        $this->start_controls_section(
			'Doctrine_Spread_two',
			[
				'label' => __( 'Spread Virus Two', 'covid19-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

			$this->add_control(
				'top_title',
				[
					'label' => __( 'Top Title', 'covid19-toolkit' ),
					'type' => Controls_Manager::TEXT,
					'default' => esc_html__('Spreads', 'covid19-toolkit'),
				]
			);
			$this->add_control(
				'title',
				[
					'label' => __( 'Title', 'covid19-toolkit' ),
					'type' => Controls_Manager::TEXTAREA,
					'default' => esc_html__('How Covid-19 Spreads', 'covid19-toolkit'),
				]
            );
            $this->add_control(
                'title_tag',
                [
                    'label' => __( 'Title Tag', 'covid19-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1'         => __( 'h1', 'covid19-toolkit' ),
                        'h2'         => __( 'h2', 'covid19-toolkit' ),
                        'h3'         => __( 'h3', 'covid19-toolkit' ),
                        'h4'         => __( 'h4', 'covid19-toolkit' ),
                        'h5'         => __( 'h5', 'covid19-toolkit' ),
                        'h6'         => __( 'h6', 'covid19-toolkit' ),
                    ],
                    'default' => 'h2',
                ]
            );
            $this->add_control(
				'sec_content',
				[
					'label' => __( 'Content', 'covid19-toolkit' ),
					'type' => Controls_Manager::TEXTAREA,
					'default' => esc_html__('Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Quis ipsum suspendisse ultrices gravida. Risus commodo viverra maecenas accumsan lacus vel facilisis.', 'covid19-toolkit'),
				]
            );

            $this->add_control(
                'image',
                [
                    'label' => __( 'Image', 'covid19-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                ]
            );

            $this->add_control(
                'shape_one',
                [
                    'label' => __( 'Shape One', 'covid19-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                ]
            );
               
            $spread = new Repeater();
            $spread->add_control(
                'img_icon',
                [
                    'label' => __( 'Image Icon', 'covid19-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                ]
            );
            $spread->add_control(
                'title', 
                [
                    'label' => __( 'Title', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );
            $spread->add_control(
                'content', 
                [
                    'label' => __( 'Content', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXTAREA,
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'spread_virus',
                [
                    'label' => __( 'Spread Virus List', 'covid19-toolkit' ),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $spread->get_controls(),
                    'default' => [
                        [
                            'title'   => __( 'Human Contact', 'covid19-toolkit' ),
                        ],
                        [
                            'title'   => __( 'Air Transmission', 'covid19-toolkit' ),
                        ],
                        [
                            'title'   => __( 'Contaminated Objects', 'covid19-toolkit' ),
                        ],
                    ],
                    'title_field' => '{{{ title }}}',
                ]
            );
        $this->end_controls_section();

        $this->start_controls_section(
			'spread_style',
			[
				'label' => __( 'Style', 'covid19-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'top_title_typography',
                    'label' => __( 'Top Title Typography', 'covid19-toolkit' ),
                    'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .spread-virus-content .sub-title',
                ]
            );

            $this->add_control(
                'top_title_color',
                [
                    'label' => __( 'Top Title Color', 'covid19-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .spread-virus-content .sub-title' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => __( 'Title Typography', 'covid19-toolkit' ),
                    'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .spread-virus-content h2, .spread-virus-content h1, .spread-virus-content h3, .spread-virus-content h4, .spread-virus-content h5, .spread-virus-content h6',
                ]
            );
            
            $this->add_control(
                'title_color',
                [
                    'label' => __( 'Title Color', 'covid19-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .spread-virus-content h2, .spread-virus-content h1, .spread-virus-content h3, .spread-virus-content h4, .spread-virus-content h5, .spread-virus-content h6' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'content_typography',
                    'label' => __( 'Content Typography', 'covid19-toolkit' ),
                    'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .spread-virus-content p',
                ]
            );
            
            $this->add_control(
                'content_color',
                [
                    'label' => __( 'Content Color', 'covid19-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .spread-virus-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'card_title_typography',
                    'label' => __( 'Card Title Typography', 'covid19-toolkit' ),
                    'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .spread-virus-content ul li h3',
                ]
            );
            
            $this->add_control(
                'card_title_color',
                [
                    'label' => __( 'Card Title Color', 'covid19-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .spread-virus-content ul li h3' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'card_content_typography',
                    'label' => __( 'Card Content Typography', 'covid19-toolkit' ),
                    'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .spread-virus-content ul li p',
                ]
            );
            
            $this->add_control(
                'card_content_color',
                [
                    'label' => __( 'Card Content Color', 'covid19-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .spread-virus-content ul li p' => 'color: {{VALUE}}',
                    ],
                ]
            );

        $this->end_controls_section();
    }

	protected function render() {

        $settings = $this->get_settings_for_display();	

        
        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');

        ?>

        <div class="spread-virus-area pt-100">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-lg-6 col-md-12">
                        <div class="spread-virus-content">
                            <span class="sub-title"><?php echo esc_html( $settings['top_title'] ); ?></span>
                            <<?php echo esc_attr( $settings['title_tag'] ); ?> <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>
                            <p><?php echo wp_kses_post( $settings['sec_content'] ); ?></p>

                            <ul>
                                <?php foreach ( $settings['spread_virus'] as $item ) : ?>
                                    <li>
                                        <div class="icon">
                                            <img src="<?php echo esc_url( $item['img_icon']['url'] ); ?>" alt="<?php echo esc_attr( $item['title'] ); ?>">
                                        </div>
                                        <h3><?php echo esc_html( $item['title'] ); ?></h3>
                                        <p><?php echo esc_html( $item['content'] ); ?></p>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>

                    <div class="col-lg-6 col-md-12">
                        <div class="spread-virus-image">
                            <?php if ( $settings['image']['url'] != '' ) : ?>
                                <img src="<?php echo esc_url( $settings['image']['url'] ); ?>" alt="<?php echo esc_attr( $settings['title'] ); ?>">
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <div class="spread-shape3">
                <img src="<?php echo esc_url( $settings['shape_one']['url'] ); ?>" alt="<?php echo esc_attr( $settings['title'] ); ?>">
            </div>
        </div>
        <?php
	}
	protected function _content_template() {}
}
Plugin::instance()->widgets_manager->register_widget_type( new Doctrine_SpreadVirus_Two );