<?php
/**
 * Covid19 Symptom Widget
 */

namespace Elementor;
class Doctrine_Symptom extends Widget_Base {

	public function get_name() {
        return 'Doctrine_Symptom';
    }

	public function get_title() {
        return __( 'Symptom', 'covid19-toolkit' );
    }

	public function get_icon() {
        return 'eicon-editor-list-ul';
    }

	public function get_categories() {
        return [ 'covid19-elements' ];
    }

	protected function _register_controls() {

        $this->start_controls_section(
			'Doctrine_Symptom',
			[
				'label' => __( 'Symptom', 'covid19-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

			$this->add_control(
				'top_title',
				[
					'label' => __( 'Top Title', 'covid19-toolkit' ),
					'type' => Controls_Manager::TEXT,
					'default' => esc_html__('Symptoms', 'covid19-toolkit'),
				]
			);
			$this->add_control(
				'title',
				[
					'label' => __( 'Title', 'covid19-toolkit' ),
					'type' => Controls_Manager::TEXTAREA,
					'default' => esc_html__('Coronavirus Symptoms', 'covid19-toolkit'),
				]
            );
            $this->add_control(
                'title_tag',
                [
                    'label' => __( 'Title Tag', 'covid19-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1'         => __( 'h1', 'covid19-toolkit' ),
                        'h2'         => __( 'h2', 'covid19-toolkit' ),
                        'h3'         => __( 'h3', 'covid19-toolkit' ),
                        'h4'         => __( 'h4', 'covid19-toolkit' ),
                        'h5'         => __( 'h5', 'covid19-toolkit' ),
                        'h6'         => __( 'h6', 'covid19-toolkit' ),
                    ],
                    'default' => 'h2',
                ]
            );
               
            $symptom = new Repeater();
            $symptom->add_control(
                'title', 
                [
                    'label' => __( 'Title', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );
            $symptom->add_control(
                'font-type',
                [
                    'label' => __( 'Icon Type', 'covid19-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'flaticon'         => __( 'Flat Icon', 'covid19-toolkit' ),
                        'fontawesome'      => __( 'Font Awesome', 'covid19-toolkit' ),
                        'custom_class'     => __( 'Font Class Name', 'covid19-toolkit' ),
                    ],
                    'default' => 'flaticon',
                ]
            );
            $symptom->add_control(
                'flat-icon',
                [
                    'label' => __( 'Flat Icon', 'covid19-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'flaticon-cough'                    => __( 'Cough', 'covid19-toolkit' ),
                        'flaticon-fever'                    => __( 'Fever', 'covid19-toolkit' ),
                        'flaticon-girl'                     => __( 'Girl', 'covid19-toolkit' ),
                        'flaticon-headache'                 => __( 'Headache', 'covid19-toolkit' ),
                        'flaticon-difficulty-breathing'     => __( 'Difficulty Breathing', 'covid19-toolkit' ),
                        'flaticon-chest-pain'               => __( 'Chest Pain', 'covid19-toolkit' ),
                        'flaticon-sore-throat'              => __( 'Sore Throat', 'covid19-toolkit' ),
                        'flaticon-antihistamines'           => __( 'Antihistamines', 'covid19-toolkit' ),
                    ],
                    'condition' => [
                        'font-type' => ['flaticon'],
                    ],
                ]
            );
            $symptom->add_control(
                'font-awesome',
                [
                    'label' => __( 'Font Awesome Icon', 'covid19-toolkit' ),
                    'type' => Controls_Manager::ICON,
                    'condition' => [
                        'font-type' => ['fontawesome'],
                    ],
                ]
            );
            $symptom->add_control(
                'custom_icon',
                [
                    'label' => __( 'Custom Font Class Name', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'condition' => [
                        'font-type' => ['custom_class'],
                    ],
                ]
            );
            $this->add_control(
                'symptoms',
                [
                    'label' => __( 'Symptoms List', 'covid19-toolkit' ),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $symptom->get_controls(),
                    'default' => [
                        [
                            'title'   => __( 'Cough', 'covid19-toolkit' ),
                        ],
                        [
                            'title'   => __( 'Fever', 'covid19-toolkit' ),
                        ],
                        [
                            'title'   => __( 'Tiredness', 'covid19-toolkit' ),
                        ],
                    ],
                    'title_field' => '{{{ title }}}',
                ]
            );
        $this->end_controls_section();

        $this->start_controls_section(
			'symptom_style',
			[
				'label' => __( 'Style', 'covid19-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'top_title_typography',
                    'label' => __( 'Top Title Typography', 'covid19-toolkit' ),
                    'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .symptoms-area .sub-title',
                ]
            );

            $this->add_control(
                'top_title_color',
                [
                    'label' => __( 'Top Title Color', 'covid19-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .symptoms-area .sub-title' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => __( 'Title Typography', 'covid19-toolkit' ),
                    'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .symptoms-area h1, .symptoms-area h2, .symptoms-area h3, .symptoms-area h4, .symptoms-area h5, .symptoms-area h6',
                ]
            );
            
            $this->add_control(
                'title_color',
                [
                    'label' => __( 'Title Color', 'covid19-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .symptoms-area h1, .symptoms-area h2, .symptoms-area h3, .symptoms-area h4, .symptoms-area h5, .symptoms-area h6' => 'color: {{VALUE}}',
                    ],
                ]
            );

        $this->end_controls_section();
    }

	protected function render() {

        $settings = $this->get_settings_for_display();	

        
        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');

        ?>
        <div class="symptoms-area pt-100 pb-70">
            <div class="container">
                <div class="section-title">
                    <span class="sub-title"><?php echo esc_html( $settings['top_title'] ); ?></span>
                    <<?php echo esc_attr( $settings['title_tag'] ); ?> <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>
                </div>

                <div class="row">

                    <?php foreach( $settings['symptoms'] as $item ): ?>
                        <?php
                        // Icon Class
                        if( $item['font-type'] == 'flaticon' ):
                            $icon = $item['flat-icon'];
                        elseif( $item['font-type'] == 'fontawesome' ):
                            $icon = $item['font-awesome'];
                        else:
                            $icon = $item['custom_icon'];
                        endif;
                        ?>
                        <div class="col-lg-3 col-sm-6 col-md-4">
                            <div class="single-symptoms-box">
                                <i class='<?php echo esc_attr( $icon ); ?>'></i>
                                <?php echo esc_html( $item['title'] ); ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
        <?php
	}
	protected function _content_template() {}
}
Plugin::instance()->widgets_manager->register_widget_type( new Doctrine_Symptom );