<?php
/**
 * Covid19 Symptom2 Widget
 */

namespace Elementor;
class Doctrine_Symptom_Two extends Widget_Base {

	public function get_name() {
        return 'Doctrine_Symptom_Two';
    }

	public function get_title() {
        return __( 'Symptom Two', 'covid19-toolkit' );
    }

	public function get_icon() {
        return 'eicon-editor-list-ul';
    }

	public function get_categories() {
        return [ 'covid19-elements' ];
    }

	protected function _register_controls() {

        $this->start_controls_section(
			'Doctrine_Symptom_two',
			[
				'label' => __( 'Symptom Two', 'covid19-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

			$this->add_control(
				'top_title',
				[
					'label' => __( 'Top Title', 'covid19-toolkit' ),
					'type' => Controls_Manager::TEXT,
					'default' => esc_html__('Symptoms', 'covid19-toolkit'),
				]
			);
			$this->add_control(
				'title',
				[
					'label' => __( 'Title', 'covid19-toolkit' ),
					'type' => Controls_Manager::TEXTAREA,
					'default' => esc_html__('Coronavirus Symptoms', 'covid19-toolkit'),
				]
            );
            $this->add_control(
                'title_tag',
                [
                    'label' => __( 'Title Tag', 'covid19-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1'         => __( 'h1', 'covid19-toolkit' ),
                        'h2'         => __( 'h2', 'covid19-toolkit' ),
                        'h3'         => __( 'h3', 'covid19-toolkit' ),
                        'h4'         => __( 'h4', 'covid19-toolkit' ),
                        'h5'         => __( 'h5', 'covid19-toolkit' ),
                        'h6'         => __( 'h6', 'covid19-toolkit' ),
                    ],
                    'default' => 'h2',
                ]
            );

            $this->add_control(
                'image',
                [
                    'label' => __( 'Image', 'covid19-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                ]
            );

            $this->add_control(
                'shape_one',
                [
                    'label' => __( 'Shape One', 'covid19-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                ]
            );

            $this->add_control(
                'shape_two',
                [
                    'label' => __( 'Shape Two', 'covid19-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                ]
            );
               
            $symptom = new Repeater();
            $symptom->add_control(
                'img_icon',
                [
                    'label' => __( 'Image Icon', 'covid19-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                ]
            );
            $symptom->add_control(
                'title', 
                [
                    'label' => __( 'Title', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );
            $symptom->add_control(
                'content', 
                [
                    'label' => __( 'Content', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXTAREA,
                    'label_block' => true,
                ]
            );
            $this->add_control(
                'symptoms',
                [
                    'label' => __( 'Symptoms List', 'covid19-toolkit' ),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $symptom->get_controls(),
                    'default' => [
                        [
                            'title'   => __( 'Cough', 'covid19-toolkit' ),
                        ],
                        [
                            'title'   => __( 'Fever', 'covid19-toolkit' ),
                        ],
                        [
                            'title'   => __( 'Tiredness', 'covid19-toolkit' ),
                        ],
                    ],
                    'title_field' => '{{{ title }}}',
                ]
            );
        $this->end_controls_section();

        $this->start_controls_section(
			'symptom_style',
			[
				'label' => __( 'Style', 'covid19-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'top_title_typography',
                    'label' => __( 'Top Title Typography', 'covid19-toolkit' ),
                    'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .section-title .sub-title',
                ]
            );

            $this->add_control(
                'top_title_color',
                [
                    'label' => __( 'Top Title Color', 'covid19-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .section-title .sub-title' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => __( 'Title Typography', 'covid19-toolkit' ),
                    'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .section-title h2, .section-title h1, .section-title h3, .section-title h4, .section-title h5, .section-title h6',
                ]
            );
            
            $this->add_control(
                'title_color',
                [
                    'label' => __( 'Title Color', 'covid19-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .section-title h2, .section-title h1, .section-title h3, .section-title h4, .section-title h5, .section-title h6' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'card_title_typography',
                    'label' => __( 'Card Title Typography', 'covid19-toolkit' ),
                    'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .symptoms-box-list .box-item h3',
                ]
            );
            
            $this->add_control(
                'card_title_color',
                [
                    'label' => __( 'Card Title Color', 'covid19-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .symptoms-box-list .box-item h3' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'card_content_typography',
                    'label' => __( 'Card Content Typography', 'covid19-toolkit' ),
                    'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .symptoms-box-list .box-item p',
                ]
            );
            
            $this->add_control(
                'card_content_color',
                [
                    'label' => __( 'Card Content Color', 'covid19-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .symptoms-box-list .box-item p' => 'color: {{VALUE}}',
                    ],
                ]
            );

        $this->end_controls_section();
    }

	protected function render() {

        $settings = $this->get_settings_for_display();	

        
        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');

        ?>
        <div class="symptoms-section bg-white-color pb-100">
            <div class="container">
                <div class="section-title">
                    <span class="sub-title"><?php echo esc_html( $settings['top_title'] ); ?></span>
                    <<?php echo esc_attr( $settings['title_tag'] ); ?> <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>
                </div>

                <div class="row align-items-center">
                    <?php $i = 1; ?>
                    <div class="col-lg-4 col-md-6 col-sm-6">
                        <div class="symptoms-box-list">
                            <?php foreach ( $settings['symptoms'] as $item ) : 
                                if ( $i % 2 != 0 ) : ?>
                                    <div class="box-item">
                                        <div class="img">
                                            <img src="<?php echo esc_url( $item['img_icon']['url'] ); ?>" alt="<?php echo esc_attr( $item['title'] ); ?>">
                                        </div>
                                        <h3><?php echo esc_html( $item['title'] ); ?></h3>
                                        <p><?php echo esc_html( $item['content'] ); ?></p>
                                    </div><?php
                                endif;
                            $i++;
                            endforeach; ?>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-12 col-sm-12">
                        <div class="symptoms-img">
                            <?php if ( $settings['image']['url'] != '' ) : ?>
                                <img src="<?php echo esc_url( $settings['image']['url'] ); ?>" alt="<?php echo esc_attr( $settings['title'] ); ?>">
                            <?php endif; ?>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-6 col-sm-6">
                        <div class="symptoms-box-list">
                        <?php $i = 1; ?>
                            <?php foreach ( $settings['symptoms'] as $item ) :
                                if ( $i % 2 == 0 ) : ?>
                                    <div class="box-item">
                                        <div class="img">
                                            <img src="<?php echo esc_url( $item['img_icon']['url'] ); ?>" alt="<?php echo esc_attr( $item['title'] ); ?>">
                                        </div>
                                        <h3><?php echo esc_html( $item['title'] ); ?></h3>
                                        <p><?php echo esc_html( $item['content'] ); ?></p>
                                    </div>
                                    <?php
                                endif;
                            $i++;
                            endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
            
            <?php if ( $settings['shape_two']['url'] != '' ) : ?>
                <div class="symptoms-shape1"><img src="<?php echo esc_url( $settings['shape_two']['url'] ); ?>" alt="<?php echo esc_attr( $settings['title'] ); ?>"></div>
            <?php endif; ?>

            <?php if ( $settings['shape_one']['url'] != '' ) : ?>
                <div class="symptoms-shape2"><img src="<?php echo esc_url( $settings['shape_one']['url'] ); ?>" alt="<?php echo esc_attr( $settings['title'] ); ?>"></div>
            <?php endif; ?>
        </div>
        <?php
	}
	protected function _content_template() {}
}
Plugin::instance()->widgets_manager->register_widget_type( new Doctrine_Symptom_Two );