<?php
/**
 * Covid19 Symptom Widget
 */

namespace Elementor;
class Doctrine_Symptom_Three extends Widget_Base {

	public function get_name() {
        return 'Doctrine_Symptom_Three';
    }

	public function get_title() {
        return __( 'Symptom Three', 'covid19-toolkit' );
    }

	public function get_icon() {
        return 'eicon-editor-list-ul';
    }

	public function get_categories() {
        return [ 'covid19-elements' ];
    }

	protected function _register_controls() {

        $this->start_controls_section(
			'Doctrine_Symptom_three',
			[
				'label' => __( 'Symptom Three', 'covid19-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

			$this->add_control(
				'top_title',
				[
					'label' => __( 'Top Title', 'covid19-toolkit' ),
					'type' => Controls_Manager::TEXT,
					'default' => esc_html__('Symptoms', 'covid19-toolkit'),
				]
			);
			$this->add_control(
				'title',
				[
					'label' => __( 'Title', 'covid19-toolkit' ),
					'type' => Controls_Manager::TEXTAREA,
					'default' => esc_html__('Coronavirus Symptoms', 'covid19-toolkit'),
				]
            );
            $this->add_control(
                'title_tag',
                [
                    'label' => __( 'Title Tag', 'covid19-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'h1'         => __( 'h1', 'covid19-toolkit' ),
                        'h2'         => __( 'h2', 'covid19-toolkit' ),
                        'h3'         => __( 'h3', 'covid19-toolkit' ),
                        'h4'         => __( 'h4', 'covid19-toolkit' ),
                        'h5'         => __( 'h5', 'covid19-toolkit' ),
                        'h6'         => __( 'h6', 'covid19-toolkit' ),
                    ],
                    'default' => 'h2',
                ]
            );
            $this->add_control(
				'content',
				[
					'label' => __( 'Content', 'covid19-toolkit' ),
					'type' => Controls_Manager::TEXTAREA,
					'default' => esc_html__('Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Quis ipsum suspendisse ultrices gravida. Risus commodo viverra maecenas accumsan lacus vel facilisis.', 'covid19-toolkit'),
				]
            );

            $this->add_control(
				'image',
				[
					'label' => __( 'Image', 'covid19-toolkit' ),
					'type' => Controls_Manager::MEDIA,
				]
			);
			$this->add_control(
				'background_image',
				[
					'label' => __( 'Background Image', 'covid19-toolkit' ),
					'type' => Controls_Manager::MEDIA,
				]
            );
               
            $symptom = new Repeater();
            $symptom->add_control(
                'title', 
                [
                    'label' => __( 'Title', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );
            $symptom->add_control(
                'font_type',
                [
                    'label' => __( 'Icon Type', 'covid19-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'fontawesome'      => __( 'Font Awesome', 'covid19-toolkit' ),
                        'custom_class'     => __( 'Font Class Name', 'covid19-toolkit' ),
                    ],
                    'default' => 'flaticon',
                ]
            );
            $symptom->add_control(
                'font_awesome',
                [
                    'label' => __( 'Font Awesome Icon', 'covid19-toolkit' ),
                    'type' => Controls_Manager::ICON,
                    'condition' => [
                        'font_type' => ['fontawesome'],
                    ],
                ]
            );
            $symptom->add_control(
                'custom_icon',
                [
                    'label' => __( 'Custom Font Class Name', 'covid19-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'condition' => [
                        'font_type' => ['custom_class'],
                    ],
                ]
            );
            $this->add_control(
                'symptoms',
                [
                    'label' => __( 'Symptoms List', 'covid19-toolkit' ),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $symptom->get_controls(),
                    'default' => [
                        [
                            'title'   => __( 'Cough', 'covid19-toolkit' ),
                        ],
                        [
                            'title'   => __( 'Fever', 'covid19-toolkit' ),
                        ],
                        [
                            'title'   => __( 'Tiredness', 'covid19-toolkit' ),
                        ],
                    ],
                    'title_field' => '{{{ title }}}',
                ]
            );
        $this->end_controls_section();

        $this->start_controls_section(
			'symptom_style',
			[
				'label' => __( 'Style', 'covid19-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
        );

            $this->add_control(
                'bg_color',
                [
                    'label' => __( 'Background Color', 'covid19-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .symptoms-area' => 'background-color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'top_title_typography',
                    'label' => __( 'Top Title Typography', 'covid19-toolkit' ),
                    'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .symptoms-content .sub-title',
                ]
            );

            $this->add_control(
                'top_title_color',
                [
                    'label' => __( 'Top Title Color', 'covid19-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .symptoms-content .sub-title' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => __( 'Title Typography', 'covid19-toolkit' ),
                    'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .symptoms-content h2, .symptoms-content h1, .symptoms-content h3, .symptoms-content h4, .symptoms-content h5, .symptoms-content h6',
                ]
            );
            
            $this->add_control(
                'title_color',
                [
                    'label' => __( 'Title Color', 'covid19-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .symptoms-content h2, .symptoms-content h1, .symptoms-content h3, .symptoms-content h4, .symptoms-content h5, .symptoms-content h6' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'content_typography',
                    'label' => __( 'Content Typography', 'covid19-toolkit' ),
                    'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                    'selector' => '{{WRAPPER}} .symptoms-content p',
                ]
            );
            
            $this->add_control(
                'content_color',
                [
                    'label' => __( 'Content Color', 'covid19-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .symptoms-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );
        $this->end_controls_section();
    }

	protected function render() {

        $settings = $this->get_settings_for_display();	

        
        // Inline Editing
        $this-> add_inline_editing_attributes('title','none');

        ?>
        <div class="symptoms-area pt-100" style="background-image:url(<?php echo esc_url( $settings['background_image']['url'] ); ?>);">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-6 col-md-12">
                        <div class="symptoms-image">
                            <?php if ( $settings['image']['url'] != '' ) : ?>
                                <img src="<?php echo esc_url( $settings['image']['url'] ); ?>" alt="<?php echo esc_attr( $settings['title'] ); ?>">
                            <?php endif; ?>
                        </div>
                    </div>

                    <div class="col-lg-6 col-md-12">
                        <div class="symptoms-content">
                            <span class="sub-title"><?php echo esc_html( $settings['top_title'] ); ?></span>
                            <<?php echo esc_attr( $settings['title_tag'] ); ?> <?php echo $this-> get_render_attribute_string('title'); ?>><?php echo esc_html( $settings['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>
                            <p><?php echo esc_html( $settings['content'] ); ?></p>

                            <ul>
                                <?php foreach( $settings['symptoms'] as $item ): ?>
                                    <?php
                                    // Icon Class
                                    if( $item['font_type'] == 'fontawesome' ):
                                        $icon = $item['font_awesome'];
                                    else:
                                        $icon = $item['custom_icon'];
                                    endif;
                                    ?>
                                    <li><span><i class='<?php echo esc_attr( $icon ); ?>'></i> <?php echo esc_html( $item['title'] ); ?></span></li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php
	}
	protected function _content_template() {}
}
Plugin::instance()->widgets_manager->register_widget_type( new Doctrine_Symptom_Three );